/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleTypeBLOB
extends OracleType
implements Serializable {
    static final long serialVersionUID = -2311211431562030662L;
    static int fixed_data_size = 86;
    transient OracleConnection m_conn;

    protected OracleTypeBLOB() {
    }

    public OracleTypeBLOB(OracleConnection oracleConnection) {
        this.m_conn = oracleConnection;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BLOB bLOB = null;
        if (object != null) {
            if (object instanceof BLOB) {
                bLOB = (BLOB)object;
            } else {
                DBError.check_error(59, object);
            }
        }
        return bLOB;
    }

    public int getTypeCode() {
        return 2004;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        return OracleTypeBLOB.lobUnpickle80rec(this, this.null_offset, this.lds_offset, unpickleContext, n, n2, fixed_data_size);
    }

    protected static Object lobUnpickle80rec(OracleType oracleType, int n, int n2, UnpickleContext unpickleContext, int n3, int n4, int n5) throws SQLException {
        switch (n3) {
            case 1: {
                if (unpickleContext.is_null(n)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[n2]);
                if (n4 == 9) {
                    unpickleContext.skip_bytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.read_ptrBytes();
                unpickleContext.reset();
                return oracleType.toObject(byArray, n4, null);
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1) {
                    unpickleContext.skip_ptrBytes();
                    return null;
                }
            }
            case 3: {
                long l = unpickleContext.offset() + n5;
                if (n4 == 9) {
                    unpickleContext.skip_to(l);
                    return null;
                }
                byte[] byArray = unpickleContext.read_ptrBytes();
                if ((long)unpickleContext.offset() < l) {
                    unpickleContext.skip_to(l);
                }
                return oracleType.toObject(byArray, n4, null);
            }
        }
        DBError.throwSqlException(1, "format=" + n3);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: 
            case 2: {
                return new BLOB(this.m_conn, byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DBError.throwSqlException(59, byArray);
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.m_conn = oracleConnection;
    }
}

