/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.model;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.dbuml.base.model.Database;

public abstract class DBElement {
    protected Map _props;
    protected String _sName;
    protected Object _objModel;
    private Database owningDB = null;

    public DBElement() {
        this("", null);
    }

    public DBElement(String sName) {
        this(sName, null);
    }

    public DBElement(String sName, Map properties) {
        this._props = properties != null ? properties : new TreeMap();
        this._sName = sName;
    }

    public DBElement(String sName, Object objModel, Properties properties) {
        this(sName);
        this._objModel = objModel;
        this.setProperties(properties);
    }

    protected void setProperties(Properties properties) {
        if (this._props != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this._props.put(key, properties.getProperty(key));
            }
        }
    }

    public void setProperty(String name, String value) {
        String val = value;
        if (val == null) {
            val = "";
        }
        if (this._props != null) {
            this._props.put(name, val);
        }
    }

    public String getProperty(String name) {
        String value = null;
        if (this._props != null) {
            value = (String)this._props.get(name);
        }
        return value;
    }

    public Map getProperties() {
        return this._props;
    }

    public String getName() {
        return this._sName;
    }

    public Object getModelElement() {
        return this._objModel;
    }

    public void setModelElement(Object objModel) {
        this._objModel = objModel;
    }

    public void setName(String name) {
        this._sName = name;
    }

    public abstract String getStereostring();

    public boolean equals(DBElement dbe) {
        boolean value = false;
        if (dbe != null && this._sName.equals(dbe._sName) && this._props.size() == dbe._props.size()) {
            Iterator it = this._props.keySet().iterator();
            value = true;
            while (it.hasNext()) {
                if (dbe._props.containsKey(it.next())) continue;
                value = false;
                break;
            }
        }
        return value;
    }

    public void setOwningDatabase(Database db) {
        this.owningDB = db;
    }

    protected boolean hasOwningDatabase() {
        return this.owningDB != null;
    }

    protected Database getOwningDatabase() {
        return this.owningDB;
    }

    public String getFixedName() {
        String value = this.getName();
        if (this.owningDB != null) {
            value = this.owningDB.fixName(value);
        }
        return value;
    }

    public String fixName(String identifier) {
        String value = identifier;
        if (this.owningDB != null) {
            value = this.owningDB.fixName(value);
        }
        return value;
    }

    protected static class KeyComparator
    implements Comparator {
        private List orderedPropNames;

        public KeyComparator(List orderedPropertyNames) {
            this.orderedPropNames = orderedPropertyNames;
        }

        public int compare(Object o1, Object o2) {
            int retVal = 0;
            if (this.orderedPropNames != null) {
                int index1 = this.orderedPropNames.indexOf(o1.toString());
                int index2 = this.orderedPropNames.indexOf(o2.toString());
                if (index1 >= 0 && index2 >= 0) {
                    retVal = index1 - index2;
                } else if (index1 < 0 && index2 >= 0) {
                    retVal = index2 - index1;
                } else if (index2 < 0 && index1 >= 0) {
                    retVal = index2 - index1;
                }
                retVal = o1.toString().compareTo(o2.toString());
            } else {
                retVal = o1.toString().compareTo(o2.toString());
            }
            return retVal;
        }
    }
}

