/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.domain.user;

import com.jgoodies.app.domain.user.UserRole;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.display.Displayable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class UserAccount
extends Bean
implements Displayable {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_ROLLEN = "rollen";
    private String name;
    private final String firstName;
    private final String lastName;
    private final List<UserRole> rollen;

    public UserAccount(String name, UserRole ... rollen) {
        this(name, (String)null, (String)null, rollen);
    }

    public UserAccount(String name, String firstName, String lastName, UserRole ... rollen) {
        this.name = name;
        this.firstName = firstName;
        this.lastName = lastName;
        this.rollen = new ArrayList<UserRole>();
        this.rollen.addAll(Arrays.asList(rollen));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
        this.firePropertyChange(PROPERTY_NAME, this.name, this.name);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getRealName() {
        return this.firstName == null || this.lastName == null ? this.name : this.firstName + " " + this.lastName;
    }

    public String getShortRealName() {
        return this.firstName == null || this.lastName == null ? this.name : this.firstName.charAt(0) + ".\u202f" + this.lastName;
    }

    public List<UserRole> getRollen() {
        return Collections.unmodifiableList(this.rollen);
    }

    public void setRollen(List<UserRole> newValue) {
        this.rollen.clear();
        this.rollen.addAll(newValue);
        this.firePropertyChange(PROPERTY_ROLLEN, null, this.getRollen());
    }

    public boolean hatRolle(UserRole rolle) {
        return this.rollen.contains(rolle);
    }

    public void addBenutzerrolle(UserRole rolle) {
        this.rollen.add(rolle);
        this.firePropertyChange(PROPERTY_ROLLEN, null, this.getRollen());
    }

    public void updateBenutzerrolle(UserRole oldValue, UserRole newValue) {
        int index = this.rollen.indexOf(oldValue);
        Preconditions.checkArgument(index != -1, "The Benutzerrolle %1$s does not exist in Benutzerkonto %2$s and so, it cannot be updated.", oldValue, this);
        this.rollen.set(index, newValue);
        this.firePropertyChange(PROPERTY_ROLLEN, null, this.getRollen());
    }

    public void removeRolle(UserRole daten) {
        this.rollen.remove(daten);
        this.firePropertyChange(PROPERTY_ROLLEN, null, this.getRollen());
    }

    public boolean matches(String name) {
        return name.equalsIgnoreCase(this.getName()) || name.equalsIgnoreCase(this.getFirstName());
    }

    @Override
    public String getDisplayString() {
        boolean hasName = Strings.isNotBlank(this.name);
        return hasName ? this.name : "<Unbenannt>";
    }
}

