/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.quicksearch;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.quicksearch.Activatable;
import com.jgoodies.quicksearch.QuickSearchPublisher;
import javax.swing.Icon;

abstract class AbstractActivatableBuilder<B extends AbstractActivatableBuilder<B>> {
    protected String displayString;
    protected Icon icon;
    protected Object additionalInfo;
    protected String category;
    protected int rank;

    protected AbstractActivatableBuilder() {
    }

    public B icon(Icon icon) {
        this.icon = icon;
        return (B)this;
    }

    public B displayString(String text, Object ... args) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "display string");
        this.displayString = Strings.get(text, args);
        return (B)this;
    }

    public B additionalInfo(Object info) {
        this.additionalInfo = info;
        return (B)this;
    }

    public B category(String category) {
        this.category = category;
        return (B)this;
    }

    public B rank(int rank) {
        this.rank = rank;
        return (B)this;
    }

    public void publish(QuickSearchPublisher publisher) {
        Object activatable = this.build();
        publisher.publish(new Activatable[]{activatable});
    }

    public abstract <C extends Activatable> C build();
}

