/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SRC_TRACE_PROCESSOR_TABLES_PROFILER_TABLES_H_
#define SRC_TRACE_PROCESSOR_TABLES_PROFILER_TABLES_H_

#include "src/trace_processor/tables/macros.h"
#include "src/trace_processor/tables/track_tables_py.h"

namespace perfetto {
namespace trace_processor {
namespace tables {

// A callsite. This is a list of frames that were on the stack.
// This is generated by the stack profilers: heapprofd and traced_perf.
// @param depth distance from the bottom-most frame of the callstack.
// @param parent_id parent frame on the callstack. NULL for the bottom-most.
// @param frame_id frame at this position in the callstack.
// @tablegroup Callstack profilers
#define PERFETTO_TP_STACK_PROFILE_CALLSITE_DEF(NAME, PARENT, C) \
  NAME(StackProfileCallsiteTable, "stack_profile_callsite")     \
  PERFETTO_TP_ROOT_TABLE(PARENT, C)                             \
  C(uint32_t, depth)                                            \
  C(std::optional<StackProfileCallsiteTable::Id>, parent_id)    \
  C(StackProfileFrameTable::Id, frame_id)

}  // namespace tables
}  // namespace trace_processor
}  // namespace perfetto

#endif  // SRC_TRACE_PROCESSOR_TABLES_PROFILER_TABLES_H_
