/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.LineBreak;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RFloatInfo;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RLine
extends BaseRCollection {
    private final ArrayList renderables = new ArrayList(8);
    private int baseLineOffset;
    private int desiredMaxWidth;
    private int xoffset;
    private boolean allowOverflow = false;
    private boolean firstAllowOverflowWord = false;
    private BoundableRenderable mousePressTarget;
    private LineBreak lineBreak;

    public RLine(ModelNode modelNode, RenderableContainer container, int x, int y, int desiredMaxWidth, int height, boolean initialAllowOverflow) {
        super(container, modelNode);
        this.x = x;
        this.y = y;
        this.height = height;
        this.desiredMaxWidth = desiredMaxWidth;
        this.layoutUpTreeCanBeInvalidated = true;
        this.allowOverflow = initialAllowOverflow;
    }

    public void setAllowOverflow(boolean flag) {
        if (flag != this.allowOverflow) {
            this.allowOverflow = flag;
            if (flag) {
                this.firstAllowOverflowWord = true;
            }
        }
    }

    public boolean isAllowOverflow() {
        return this.allowOverflow;
    }

    public void changeLimits(int x, int desiredMaxWidth) {
        this.x = x;
        this.desiredMaxWidth = desiredMaxWidth;
    }

    public int getBaselineOffset() {
        return this.baseLineOffset;
    }

    protected void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Iterator i;
        RenderState rs = this.modelNode.getRenderState();
        if (rs != null) {
            Color textColor = rs.getColor();
            g.setColor(textColor);
            Font font = rs.getFont();
            g.setFont(font);
        }
        if ((i = this.renderables.iterator()) != null) {
            while (i.hasNext()) {
                Object r = i.next();
                if (r instanceof RElement) {
                    RElement relement = (RElement)r;
                    Graphics newG = g.create(relement.getX(), relement.getY(), relement.getWidth(), relement.getHeight());
                    try {
                        relement.paint(newG);
                        continue;
                    }
                    finally {
                        newG.dispose();
                        continue;
                    }
                }
                if (r instanceof BoundableRenderable) {
                    BoundableRenderable br = (BoundableRenderable)r;
                    br.paintTranslated(g);
                    continue;
                }
                ((Renderable)r).paint(g);
            }
        }
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        boolean result = super.extractSelectionText(buffer, inSelection, startPoint, endPoint);
        if (result) {
            LineBreak br = this.lineBreak;
            if (br != null) {
                buffer.append(System.getProperty("line.separator"));
            } else {
                ArrayList renderables = this.renderables;
                int size = renderables.size();
                if (size > 0 && !(renderables.get(size - 1) instanceof RBlank)) {
                    buffer.append(" ");
                }
            }
        }
        return result;
    }

    public final void addStyleChanger(RStyleChanger sc) {
        this.renderables.add(sc);
    }

    public final void simplyAdd(Renderable r) {
        this.renderables.add(r);
    }

    public final void add(Renderable renderable) throws OverflowException {
        if (renderable instanceof RWord) {
            this.addWord((RWord)renderable);
        } else if (renderable instanceof RBlank) {
            this.addBlank((RBlank)renderable);
        } else if (renderable instanceof RUIControl) {
            this.addElement((RElement)renderable);
        } else if (renderable instanceof RSpacing) {
            this.addSpacing((RSpacing)renderable);
        } else if (renderable instanceof RStyleChanger) {
            this.addStyleChanger((RStyleChanger)renderable);
        } else if (renderable instanceof RFloatInfo) {
            this.simplyAdd((RFloatInfo)renderable);
        } else {
            throw new IllegalArgumentException("Can't add " + renderable);
        }
    }

    public final void addWord(RWord rword) throws OverflowException {
        int maxAscentPlusLeading;
        int offset = this.xoffset;
        int wiwidth = rword.width;
        boolean allowOverflow = this.allowOverflow;
        boolean firstAllowOverflowWord = this.firstAllowOverflowWord;
        if (allowOverflow && firstAllowOverflowWord) {
            this.firstAllowOverflowWord = false;
        }
        if ((!allowOverflow || firstAllowOverflowWord) && offset != 0 && offset + wiwidth > this.desiredMaxWidth) {
            ArrayList renderables = this.renderables;
            ArrayList<RWord> overflow = null;
            boolean cancel = false;
            int newOffset = offset;
            int newWidth = offset;
            int i = renderables.size();
            while (--i >= 0) {
                Renderable renderable = (Renderable)renderables.get(i);
                if (renderable instanceof RWord || !(renderable instanceof BoundableRenderable)) {
                    if (overflow == null) {
                        overflow = new ArrayList<RWord>();
                    }
                    if (renderable != rword && renderable instanceof RWord && ((RWord)renderable).getX() == 0) {
                        cancel = true;
                        break;
                    }
                    overflow.add(0, (RWord)renderable);
                    renderables.remove(i);
                    continue;
                }
                if (renderable instanceof RBlank) {
                    RBlank rblank = (RBlank)renderable;
                    newWidth = rblank.getX();
                    newOffset = newWidth + rblank.getWidth();
                    break;
                }
                BoundableRenderable br = (BoundableRenderable)renderable;
                newWidth = newOffset = br.getX() + br.getWidth();
                break;
            }
            if (cancel) {
                if (overflow != null) {
                    Iterator i2 = overflow.iterator();
                    while (i2.hasNext()) {
                        renderables.add(i2.next());
                    }
                }
            } else {
                this.xoffset = newOffset;
                this.width = newWidth;
                if (overflow == null) {
                    throw new OverflowException(Collections.singleton(rword));
                }
                overflow.add(rword);
                throw new OverflowException(overflow);
            }
        }
        int extraHeight = 0;
        int maxDescent = this.height - this.baseLineOffset;
        if (rword.descent > maxDescent) {
            extraHeight += rword.descent - maxDescent;
        }
        if (rword.ascentPlusLeading > (maxAscentPlusLeading = this.baseLineOffset)) {
            extraHeight += rword.ascentPlusLeading - maxAscentPlusLeading;
        }
        if (extraHeight > 0) {
            int newHeight = this.height + extraHeight;
            this.adjustHeight(newHeight, newHeight, 4);
        }
        this.renderables.add(rword);
        rword.setParent(this);
        int x = offset;
        this.width = this.xoffset = (offset += wiwidth);
        rword.setOrigin(x, this.baseLineOffset - rword.ascentPlusLeading);
    }

    public final void addBlank(RBlank rblank) {
        int x = this.xoffset;
        int width = rblank.width;
        rblank.setOrigin(x, this.baseLineOffset - rblank.ascentPlusLeading);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.xoffset = x + width;
    }

    public final void addSpacing(RSpacing rblank) {
        int x = this.xoffset;
        int width = rblank.width;
        rblank.setOrigin(x, (this.height - rblank.height) / 2);
        this.renderables.add(rblank);
        rblank.setParent(this);
        this.width = this.xoffset = x + width;
    }

    private final void setElementY(RElement relement, int elementHeight, int valign) {
        int yoffset;
        switch (valign) {
            case 4: {
                yoffset = this.height - elementHeight;
                break;
            }
            case 3: {
                yoffset = (this.height - elementHeight) / 2;
                break;
            }
            case 2: 
            case 5: {
                yoffset = this.baseLineOffset - elementHeight;
                break;
            }
            case 1: {
                yoffset = this.baseLineOffset - elementHeight / 2;
                break;
            }
            case 0: {
                yoffset = 0;
                break;
            }
            default: {
                yoffset = this.baseLineOffset - elementHeight;
            }
        }
        relement.setY(yoffset);
    }

    private final void addElement(RElement relement) throws OverflowException {
        int newX;
        int requiredHeight;
        int origXOffset = this.xoffset;
        int desiredMaxWidth = this.desiredMaxWidth;
        int pw = relement.getWidth();
        boolean allowOverflow = this.allowOverflow;
        boolean firstAllowOverflowWord = this.firstAllowOverflowWord;
        if (allowOverflow && firstAllowOverflowWord) {
            this.firstAllowOverflowWord = false;
        }
        if ((!allowOverflow || firstAllowOverflowWord) && origXOffset != 0 && origXOffset + pw > desiredMaxWidth) {
            throw new OverflowException(Collections.singleton(relement));
        }
        int boundsh = this.height;
        int ph = relement.getHeight();
        int valign = relement.getVAlign();
        switch (valign) {
            case 2: 
            case 5: {
                requiredHeight = ph + (boundsh - this.baseLineOffset);
                break;
            }
            case 1: {
                requiredHeight = Math.max(ph, ph / 2 + (boundsh - this.baseLineOffset));
                break;
            }
            default: {
                requiredHeight = ph;
            }
        }
        if (requiredHeight > boundsh) {
            this.adjustHeight(requiredHeight, ph, valign);
        }
        this.renderables.add(relement);
        relement.setParent(this);
        relement.setX(origXOffset);
        this.setElementY(relement, ph, valign);
        this.width = this.xoffset = (newX = origXOffset + pw);
    }

    private void adjustHeight(int newHeight, int elementHeight, int valign) {
        int baseline;
        this.height = newHeight;
        ArrayList renderables = this.renderables;
        FontMetrics firstFm = this.modelNode.getRenderState().getFontMetrics();
        int maxDescent = firstFm.getDescent();
        int maxAscentPlusLeading = firstFm.getAscent() + firstFm.getLeading();
        Iterator i = renderables.iterator();
        while (i.hasNext()) {
            int ascentPlusLeading;
            Object r = i.next();
            if (!(r instanceof RStyleChanger)) continue;
            RStyleChanger rstyleChanger = (RStyleChanger)r;
            FontMetrics fm = rstyleChanger.getModelNode().getRenderState().getFontMetrics();
            int descent = fm.getDescent();
            if (descent > maxDescent) {
                maxDescent = descent;
            }
            if ((ascentPlusLeading = fm.getAscent() + fm.getLeading()) <= maxAscentPlusLeading) continue;
            maxAscentPlusLeading = ascentPlusLeading;
        }
        int textHeight = maxDescent + maxAscentPlusLeading;
        switch (valign) {
            case 4: {
                baseline = newHeight - maxDescent;
                break;
            }
            case 3: {
                baseline = (newHeight + textHeight) / 2 - maxDescent;
                break;
            }
            case 2: 
            case 5: {
                baseline = elementHeight;
                break;
            }
            case 1: {
                baseline = newHeight / 2;
                break;
            }
            case 0: {
                baseline = maxAscentPlusLeading;
                break;
            }
            default: {
                baseline = elementHeight;
            }
        }
        this.baseLineOffset = baseline;
        Iterator i2 = renderables.iterator();
        while (i2.hasNext()) {
            Object r = i2.next();
            if (r instanceof RWord) {
                RWord rword = (RWord)r;
                rword.setY(baseline - rword.ascentPlusLeading);
                continue;
            }
            if (r instanceof RBlank) {
                RBlank rblank = (RBlank)r;
                rblank.setY(baseline - rblank.ascentPlusLeading);
                continue;
            }
            if (!(r instanceof RElement)) continue;
            RElement relement = (RElement)r;
            this.setElementY(relement, relement.getHeight(), relement.getVAlign());
        }
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable r = MarkupUtilities.findRenderable(rarray, x, y, false);
        if (r != null) {
            Rectangle rbounds = r.getBounds();
            return r.onMouseClick(event, x - rbounds.x, y - rbounds.y);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable r = MarkupUtilities.findRenderable(rarray, x, y, false);
        if (r != null) {
            Rectangle rbounds = r.getBounds();
            return r.onDoubleClick(event, x - rbounds.x, y - rbounds.y);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable r = MarkupUtilities.findRenderable(rarray, x, y, false);
        if (r != null) {
            this.mousePressTarget = r;
            Rectangle rbounds = r.getBounds();
            return r.onMousePressed(event, x - rbounds.x, y - rbounds.y);
        }
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable br = MarkupUtilities.findRenderable(rarray, x, y, false);
        if (br != null) {
            Rectangle rbounds = br.getBounds();
            return br.getLowestRenderableSpot(x - rbounds.x, y - rbounds.y);
        }
        return new RenderableSpot(this, x, y);
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        Renderable[] rarray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable r = MarkupUtilities.findRenderable(rarray, x, y, false);
        if (r != null) {
            Rectangle rbounds = r.getBounds();
            BoundableRenderable oldArmedRenderable = this.mousePressTarget;
            if (oldArmedRenderable != null && r != oldArmedRenderable) {
                oldArmedRenderable.onMouseDisarmed(event);
                this.mousePressTarget = null;
            }
            return r.onMouseReleased(event, x - rbounds.x, y - rbounds.y);
        }
        BoundableRenderable oldArmedRenderable = this.mousePressTarget;
        if (oldArmedRenderable != null) {
            oldArmedRenderable.onMouseDisarmed(event);
            this.mousePressTarget = null;
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable target = this.mousePressTarget;
        if (target != null) {
            this.mousePressTarget = null;
            return target.onMouseDisarmed(event);
        }
        return true;
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Iterator getRenderables() {
        return this.renderables.iterator();
    }

    public boolean isContainedByNode() {
        return false;
    }

    public LineBreak getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(LineBreak lineBreak) {
        this.lineBreak = lineBreak;
    }

    public boolean isEmpty() {
        return this.xoffset == 0;
    }
}

