/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.utils.CoreUtility;
import pcgen.system.LanguageBundle;

public class PreItemTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int number;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"PreItem.error.bad_operand", (Object[])new Object[]{prereq.toString()}));
        }
        int runningTotal = 0;
        if (display.hasEquipment()) {
            String aString = prereq.getKey();
            List typeList = null;
            if (aString.startsWith("TYPE=") || aString.startsWith("TYPE.")) {
                String stripped = aString.substring(5);
                typeList = CoreUtility.split((String)stripped, (char)'.');
            }
            for (Equipment eq : display.getEquipmentSet()) {
                if (typeList != null) {
                    boolean bMatches = true;
                    int x = typeList.size();
                    for (int i = 0; i < x; ++i) {
                        if (eq.isType((String)typeList.get(i))) continue;
                        bMatches = false;
                        break;
                    }
                    if (!bMatches) continue;
                    ++runningTotal;
                    continue;
                }
                String eqName = eq.getName().toUpperCase();
                if (aString.indexOf(37) >= 0) {
                    int percentPos = aString.indexOf(37);
                    String substring = aString.substring(0, percentPos).toUpperCase();
                    if (!eqName.startsWith(substring)) continue;
                    ++runningTotal;
                    break;
                }
                if (!eqName.equalsIgnoreCase(aString)) continue;
                ++runningTotal;
                break;
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "ITEM";
    }
}

