/*
 * Decompiled with CFR 0.152.
 */
package gmgen.gui;

import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.RelativeImageView;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class ExtendedHTMLEditorKit
extends HTMLEditorKit {
    private static final Action[] defaultActions = new Action[]{new PasteAction()};

    public static HTML.Tag getHTMLTag(Element e) {
        HashMap<String, HTML.Tag> tags = new HashMap<String, HTML.Tag>();
        HTML.Tag[] tagList = HTML.getAllTags();
        for (int i = 0; i < tagList.length; ++i) {
            tags.put(tagList[i].toString(), tagList[i]);
        }
        if (tags.containsKey(e.getName())) {
            return (HTML.Tag)tags.get(e.getName());
        }
        return null;
    }

    public static Element getListItemParent(Element eleSearch) {
        String listItemTag = HTML.Tag.LI.toString();
        Element workingElement = eleSearch;
        do {
            if (!listItemTag.equals(workingElement.getName())) continue;
            return workingElement;
        } while (!(workingElement = workingElement.getParentElement()).getName().equals(HTML.Tag.HTML.toString()));
        return null;
    }

    public static String[] getUniqueString(int strings, String source) {
        String[] result = new String[strings];
        for (int i = 0; i < strings; ++i) {
            String idString;
            boolean hit;
            int counter = 0;
            do {
                hit = false;
                idString = "diesisteineidzumsuchen" + counter + "#" + i;
                if (source.indexOf(idString) <= -1) continue;
                hit = true;
                if (++counter <= 10000) continue;
                return null;
            } while (hit);
            result[i] = idString;
        }
        return result;
    }

    @Override
    public ViewFactory getViewFactory() {
        return new HTMLFactoryExtended();
    }

    public static boolean checkParentsTag(Element e, HTML.Tag tag) {
        if (e.getName().equalsIgnoreCase(tag.toString())) {
            return true;
        }
        Element workingElement = e;
        do {
            if (!(workingElement = workingElement.getParentElement()).getName().equalsIgnoreCase(tag.toString())) continue;
            return true;
        } while (!workingElement.getName().equalsIgnoreCase("html"));
        return false;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        StyleSheet ss = new StyleSheet();
        ss.addStyleSheet(styles);
        ExtendedHTMLDocument doc = new ExtendedHTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    public static void delete(JTextPane pane) throws BadLocationException {
        ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)pane.getStyledDocument();
        int selStart = pane.getSelectionStart();
        int selEnd = pane.getSelectionEnd();
        String[] posStrings = ExtendedHTMLEditorKit.getUniqueString(2, pane.getText());
        if (posStrings == null) {
            return;
        }
        htmlDoc.insertString(selStart, posStrings[0], null);
        htmlDoc.insertString(selEnd + posStrings[0].length(), posStrings[1], null);
        int start = pane.getText().indexOf(posStrings[0]);
        int end = pane.getText().indexOf(posStrings[1]);
        if (start == -1 || end == -1) {
            return;
        }
        String htmlString = pane.getText().substring(0, start);
        htmlString = htmlString + pane.getText().substring(start + posStrings[0].length(), end);
        String source = htmlString = htmlString + pane.getText().substring(end + posStrings[1].length(), pane.getText().length());
        htmlString = source.substring(0, start);
        htmlString = htmlString + ExtendedHTMLEditorKit.getAllTableTags(source.substring(start, end -= posStrings[0].length()));
        htmlString = htmlString + source.substring(end, source.length());
        pane.setText(htmlString);
    }

    public static void insertListElement(JTextPane pane, String content) {
        String idString;
        boolean hit;
        int pos = pane.getCaretPosition();
        ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)pane.getStyledDocument();
        String source = pane.getText();
        int counter = 0;
        do {
            hit = false;
            idString = "diesisteineidzumsuchenimsource" + counter;
            if (source.indexOf(idString) <= -1) continue;
            hit = true;
            if (++counter <= 10000) continue;
            return;
        } while (hit);
        Element element = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(pane.getCaretPosition()));
        if (element == null) {
            return;
        }
        SimpleAttributeSet sa = new SimpleAttributeSet(element.getAttributes());
        sa.addAttribute("id", idString);
        ((ExtendedHTMLDocument)pane.getStyledDocument()).replaceAttributes(element, sa, HTML.Tag.LI);
        source = pane.getText();
        StringBuilder newHtmlString = new StringBuilder();
        int[] positions = ExtendedHTMLEditorKit.getPositions(element, source, true, idString);
        newHtmlString.append(source.substring(0, positions[3]));
        newHtmlString.append("<li>");
        newHtmlString.append(content);
        newHtmlString.append("</li>");
        newHtmlString.append(source.substring(positions[3] + 1, source.length()));
        pane.setText(newHtmlString.toString());
        pane.setCaretPosition(pos - 1);
        element = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(pane.getCaretPosition()));
        sa = new SimpleAttributeSet(element.getAttributes());
        sa = ExtendedHTMLEditorKit.removeAttributeByKey(sa, "id");
        ((ExtendedHTMLDocument)pane.getStyledDocument()).replaceAttributes(element, sa, HTML.Tag.LI);
    }

    public static SimpleAttributeSet removeAttribute(SimpleAttributeSet sourceAS, SimpleAttributeSet removeAS) {
        try {
            String[] sourceKeys = new String[sourceAS.getAttributeCount()];
            String[] sourceValues = new String[sourceAS.getAttributeCount()];
            Enumeration<?> sourceEn = sourceAS.getAttributeNames();
            int i = 0;
            while (sourceEn.hasMoreElements()) {
                Object temp = sourceEn.nextElement();
                sourceKeys[i] = temp.toString();
                sourceValues[i] = "";
                sourceValues[i] = sourceAS.getAttribute(temp).toString();
                ++i;
            }
            String[] removeKeys = new String[removeAS.getAttributeCount()];
            String[] removeValues = new String[removeAS.getAttributeCount()];
            Enumeration<?> removeEn = removeAS.getAttributeNames();
            int j = 0;
            while (removeEn.hasMoreElements()) {
                removeKeys[j] = removeEn.nextElement().toString();
                removeValues[j] = removeAS.getAttribute(removeKeys[j]).toString();
                ++j;
            }
            SimpleAttributeSet result = new SimpleAttributeSet();
            for (int countSource = 0; countSource < sourceKeys.length; ++countSource) {
                boolean hit = false;
                if ("name".equals(sourceKeys[countSource]) || "resolver".equals(sourceKeys[countSource])) {
                    hit = true;
                } else {
                    for (int countRemove = 0; countRemove < removeKeys.length; ++countRemove) {
                        if (!"NULL".equals(removeKeys[countRemove])) {
                            if (!sourceKeys[countSource].equals(removeKeys[countRemove])) continue;
                            if (!"NULL".equals(removeValues[countRemove])) {
                                if (!sourceValues[countSource].equals(removeValues[countRemove])) continue;
                                hit = true;
                                continue;
                            }
                            if (!"NULL".equals(removeValues[countRemove])) continue;
                            hit = true;
                            continue;
                        }
                        if (!"NULL".equals(removeKeys[countRemove]) || !sourceValues[countSource].equals(removeValues[countRemove])) continue;
                        hit = true;
                    }
                }
                if (hit) continue;
                result.addAttribute(sourceKeys[countSource], sourceValues[countSource]);
            }
            return result;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static SimpleAttributeSet removeAttributeByKey(SimpleAttributeSet sourceAS, String removeKey) {
        SimpleAttributeSet temp = new SimpleAttributeSet();
        temp.addAttribute(removeKey, "NULL");
        return ExtendedHTMLEditorKit.removeAttribute(sourceAS, temp);
    }

    public static void removeTag(JTextPane pane, Element element, boolean closingTag) {
        String idString;
        boolean hit;
        if (element == null) {
            return;
        }
        HTML.Tag tag = ExtendedHTMLEditorKit.getHTMLTag(element);
        String source = pane.getText();
        int counter = 0;
        do {
            hit = false;
            idString = "diesisteineidzumsuchenimsource" + counter;
            if (source.indexOf(idString) <= -1) continue;
            hit = true;
            if (++counter <= 10000) continue;
            return;
        } while (hit);
        SimpleAttributeSet sa = new SimpleAttributeSet(element.getAttributes());
        sa.addAttribute("id", idString);
        ((ExtendedHTMLDocument)pane.getStyledDocument()).replaceAttributes(element, sa, tag);
        source = pane.getText();
        StringBuilder newHtmlString = new StringBuilder();
        int[] position = ExtendedHTMLEditorKit.getPositions(element, source, closingTag, idString);
        if (position == null) {
            return;
        }
        for (int i = 0; i < position.length; ++i) {
            if (position[i] >= 0) continue;
            return;
        }
        int beginStartTag = position[0];
        int endStartTag = position[1];
        if (closingTag) {
            int beginEndTag = position[2];
            int endEndTag = position[3];
            newHtmlString.append(source.substring(0, beginStartTag));
            newHtmlString.append(source.substring(endStartTag, beginEndTag));
            newHtmlString.append(source.substring(endEndTag, source.length()));
        } else {
            newHtmlString.append(source.substring(0, beginStartTag));
            newHtmlString.append(source.substring(endStartTag, source.length()));
        }
        pane.setText(newHtmlString.toString());
    }

    static InputStream getResourceAsStream(String name) {
        return ExtendedHTMLEditorKit.class.getResourceAsStream(name);
    }

    private static String getAllTableTags(String source) {
        StringBuilder result = new StringBuilder();
        int caret = -1;
        do {
            int[] tableCarets = new int[]{source.indexOf("<table", ++caret), source.indexOf("<tr", caret), source.indexOf("<td", caret), source.indexOf("</table", caret), source.indexOf("</tr", caret), source.indexOf("</td", caret)};
            Arrays.sort(tableCarets);
            caret = -1;
            for (int i = 0; i < tableCarets.length; ++i) {
                if (tableCarets[i] < 0) continue;
                caret = tableCarets[i];
                break;
            }
            if (caret == -1) continue;
            result.append(source.substring(caret, source.indexOf(">", caret) + 1));
        } while (caret != -1);
        return result.toString();
    }

    private static int[] getPositions(Element element, String source, boolean closingTag, String idString) {
        HTML.Tag tag = ExtendedHTMLEditorKit.getHTMLTag(element);
        int[] position = new int[4];
        for (int i = 0; i < position.length; ++i) {
            position[i] = -1;
        }
        String searchString = "<" + tag.toString();
        int caret = source.indexOf(idString);
        if (caret != -1) {
            position[0] = source.lastIndexOf("<", caret);
            position[1] = source.indexOf(">", caret) + 1;
        }
        if (closingTag) {
            boolean end;
            String searchEndTagString = "</" + tag.toString() + ">";
            caret = position[1];
            int beginEndTag = source.indexOf(searchEndTagString, caret);
            int endEndTag = beginEndTag + searchEndTagString.length();
            int interncaret = position[1];
            do {
                boolean flaghitup;
                int hitUp = 0;
                do {
                    flaghitup = false;
                    int temphitpoint = source.indexOf(searchString, interncaret);
                    if (temphitpoint <= 0 || temphitpoint >= beginEndTag) continue;
                    ++hitUp;
                    flaghitup = true;
                    interncaret = temphitpoint + searchString.length();
                } while (flaghitup);
                if (hitUp == 0) {
                    end = true;
                    continue;
                }
                for (int i = 1; i <= hitUp; ++i) {
                    caret = endEndTag;
                    beginEndTag = source.indexOf(searchEndTagString, caret);
                    endEndTag = beginEndTag + searchEndTagString.length();
                }
                end = false;
            } while (!end);
            if (beginEndTag < 0 | endEndTag < 0) {
                return null;
            }
            position[2] = beginEndTag;
            position[3] = endEndTag;
        }
        return position;
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getTextComponent(e);
            Clipboard clipboard = target.getToolkit().getSystemClipboard();
            clipboard.getContents(null);
            Class<?> k = target.getClass();
            try {
                BeanInfo bi = Introspector.getBeanInfo(k);
                bi.getPropertyDescriptors();
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
            target.paste();
        }
    }

    public static class InsertListAction
    extends HTMLEditorKit.InsertHTMLTextAction {
        private HTML.Tag baseTag;

        public InsertListAction(String label, HTML.Tag listType) {
            super(label, "", listType, HTML.Tag.LI);
            this.baseTag = listType;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                JEditorPane editor = this.getEditor(ae);
                ExtendedHTMLDocument doc = (ExtendedHTMLDocument)editor.getDocument();
                String selTextBase = editor.getSelectedText();
                Element elem = doc.getParagraphElement(editor.getCaretPosition());
                int textLength = -1;
                if (selTextBase != null) {
                    textLength = selTextBase.length();
                }
                if (selTextBase == null || textLength < 1) {
                    if (!"newListPoint".equals(ae.getActionCommand()) && (ExtendedHTMLEditorKit.checkParentsTag(elem, HTML.Tag.OL) || ExtendedHTMLEditorKit.checkParentsTag(elem, HTML.Tag.UL))) {
                        return;
                    }
                    String sListType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                    StringBuilder sbNew = new StringBuilder();
                    if (ExtendedHTMLEditorKit.checkParentsTag(elem, this.baseTag)) {
                        sbNew.append("<li></li>");
                        this.insertHTML(editor, doc, editor.getCaretPosition(), sbNew.toString(), 0, 0, HTML.Tag.LI);
                    } else {
                        sbNew.append("<").append(sListType).append("><li></li></").append(sListType).append("><p>&nbsp;</p>");
                        this.insertHTML(editor, doc, editor.getCaretPosition(), sbNew.toString(), 0, 0, sListType.equals("ol") ? HTML.Tag.OL : HTML.Tag.UL);
                    }
                } else {
                    String sListType = this.baseTag == HTML.Tag.OL ? "ol" : "ul";
                    HTMLDocument htmlDoc = (HTMLDocument)editor.getDocument();
                    int iStart = editor.getSelectionStart();
                    int iEnd = editor.getSelectionEnd();
                    String selText = htmlDoc.getText(iStart, iEnd - iStart);
                    StringBuilder sbNew = new StringBuilder();
                    String sToken = selText.indexOf("\r") > -1 ? "\r" : "\n";
                    StringTokenizer stTokenizer = new StringTokenizer(selText, sToken);
                    sbNew.append("<").append(sListType).append(">");
                    while (stTokenizer.hasMoreTokens()) {
                        sbNew.append("<li>");
                        sbNew.append(stTokenizer.nextToken());
                        sbNew.append("</li>");
                    }
                    sbNew.append("</").append(sListType).append("><p>&nbsp;</p>");
                    htmlDoc.remove(iStart, iEnd - iStart);
                    this.insertHTML(editor, htmlDoc, iStart, sbNew.toString(), 1, 1, null);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class HTMLFactoryExtended
    extends HTMLEditorKit.HTMLFactory
    implements ViewFactory {
        @Override
        public View create(Element elem) {
            HTML.Tag tagType;
            Object obj = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (obj instanceof HTML.Tag && (tagType = (HTML.Tag)obj) == HTML.Tag.IMG) {
                return new RelativeImageView(elem);
            }
            return super.create(elem);
        }
    }
}

