/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreMultParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class PreParserFactory
implements PluginLoader {
    private static PreParserFactory instance = null;
    private static Map<String, PrerequisiteParserInterface> parserLookup = new HashMap<String, PrerequisiteParserInterface>();

    private PreParserFactory() throws PersistenceLayerException {
        PreParserFactory.register(new PreMultParser());
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        PreParserFactory.register((PrerequisiteParserInterface)clazz.newInstance());
    }

    public Class[] getPluginClasses() {
        return new Class[]{PrerequisiteParserInterface.class};
    }

    public static PreParserFactory getInstance() throws PersistenceLayerException {
        if (instance == null) {
            instance = new PreParserFactory();
        }
        return instance;
    }

    public PrerequisiteParserInterface getParser(String kind) {
        return parserLookup.get(kind.toLowerCase());
    }

    public static void register(PrerequisiteParserInterface testClass) throws PersistenceLayerException {
        String[] kindsHandled = testClass.kindsHandled();
        for (int i = 0; i < kindsHandled.length; ++i) {
            PrerequisiteParserInterface test = parserLookup.get(kindsHandled[i].toLowerCase());
            if (test != null) {
                throw new PersistenceLayerException("Error registering '" + testClass.getClass().getName() + "' as test '" + kindsHandled[i] + "'. The test is already registered to '" + test.getClass().getName() + "'");
            }
            parserLookup.put(kindsHandled[i].toLowerCase(), testClass);
        }
    }

    public List<Prerequisite> parse(List<String> preStrings) {
        ArrayList<Prerequisite> ret = new ArrayList<Prerequisite>(preStrings.size());
        for (String prestr : preStrings) {
            try {
                PreParserFactory factory = PreParserFactory.getInstance();
                Prerequisite prereq = factory.parse(prestr);
                ret.add(prereq);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint(ple.getMessage(), ple);
            }
        }
        return ret;
    }

    public Prerequisite parse(String prereqStr) throws PersistenceLayerException {
        PrerequisiteParserInterface parser;
        if (prereqStr == null || prereqStr.length() <= 0) {
            throw new PersistenceLayerException("Null or empty PRE string");
        }
        int index = prereqStr.indexOf(58);
        if (index < 0) {
            throw new PersistenceLayerException("'" + prereqStr + "'" + " is a badly formatted prereq.");
        }
        String kind = prereqStr.substring(0, index);
        String formula = prereqStr.substring(index + 1);
        boolean overrideQualify = false;
        if (formula.startsWith("Q:")) {
            formula = formula.substring(2);
            overrideQualify = true;
        }
        boolean invertResult = false;
        if (kind.startsWith("!")) {
            invertResult = true;
            kind = kind.substring(1);
        }
        if ((parser = this.getParser(kind = kind.substring(3))) == null) {
            throw new PersistenceLayerException("Can not determine which parser to use for '" + prereqStr + "'");
        }
        try {
            Prerequisite prereq = parser.parse(kind, formula, invertResult, overrideQualify);
            while (prereq.getKind() == null && prereq.getPrerequisiteCount() == 1 && prereq.getOperator().equals((Object)PrerequisiteOperator.GTEQ) && prereq.getOperand().equals("1")) {
                Prerequisite sub = prereq.getPrerequisites().get(0);
                sub.setOriginalCheckmult(prereq.isOriginalCheckMult());
                prereq = sub;
            }
            return prereq;
        }
        catch (Throwable t) {
            throw new PersistenceLayerException("Can not parse '" + prereqStr + "': " + t.getMessage());
        }
    }

    public static boolean isPreReqString(String token) {
        return (token.startsWith("PRE") || token.startsWith("!PRE")) && token.indexOf(":") > 0;
    }

    public static void clear() {
        parserLookup.clear();
        if (instance != null) {
            try {
                PreParserFactory.register(new PreMultParser());
            }
            catch (PersistenceLayerException e) {
                e.printStackTrace();
            }
        }
    }
}

