/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.gui.ProgrammaticProperty;

public class Resample
extends Filter
implements UnsupervisedFilter,
OptionHandler,
Randomizable,
WeightedAttributesHandler {
    static final long serialVersionUID = 3119607037607101160L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement. The original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. When used in batch mode, subsequent batches are NOT resampled.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        result.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        result.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('Z', options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", options));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', options));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getRandomSeed());
        result.add("-Z");
        result.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            result.add("-no-replacement");
            if (this.getInvertSelection()) {
                result.add("-V");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    @Override
    @ProgrammaticProperty
    public void setSeed(int seed) {
        this.setRandomSeed(seed);
    }

    @Override
    @ProgrammaticProperty
    public int getSeed() {
        return this.getRandomSeed();
    }

    public String sampleSizePercentTipText() {
        return "Size of the subsample as a percentage of the original dataset.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double newSampleSizePercent) {
        this.m_SampleSizePercent = newSampleSizePercent;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean value) {
        this.m_NoReplacement = value;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (this.getNoReplacement() && this.getSampleSizePercent() > 100.0) {
            throw new WekaException("Sample size cannot exceed 100% for sampling *without* replacement!");
        }
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    protected void createSubsample() {
        Instances data = this.getInputFormat();
        int numEligible = data.numInstances();
        int sampleSize = (int)((double)numEligible * this.m_SampleSizePercent / 100.0);
        Random random = new Random(this.m_RandomSeed);
        if (this.getNoReplacement()) {
            int j;
            int[] selected = new int[numEligible];
            for (j = 0; j < numEligible; ++j) {
                selected[j] = j;
            }
            for (int i = 0; i < sampleSize; ++i) {
                int chosenLocation = random.nextInt(numEligible);
                int chosen = selected[chosenLocation];
                selected[chosenLocation] = selected[--numEligible];
                selected[numEligible] = chosen;
            }
            if (this.getInvertSelection()) {
                for (j = 0; j < numEligible; ++j) {
                    this.push(data.instance(selected[j]), false);
                }
            } else {
                for (j = numEligible; j < data.numInstances(); ++j) {
                    this.push(data.instance(selected[j]), false);
                }
            }
        } else {
            for (int i = 0; i < sampleSize; ++i) {
                this.push(data.instance(random.nextInt(numEligible)), false);
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15266 $");
    }

    public static void main(String[] argv) {
        Resample.runFilter(new Resample(), argv);
    }
}

