// test.cpp - Test
// Copyright (C) 2010  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#include "test.h"

#include "../config.h"
#include "../udialog.h"
#include "../utils.h"

#include <QFormLayout>

// TestAction

// public

TestAction::TestAction() :
	Action(i18n("Show Message (no shutdown)"), "dialog-ok", "test")
{
// TODO: sound beep
	setCanBookmark(true);
	setCommandLineOption({ "test" });
	setVisibleInMainMenu(false);
	setVisibleInSystemTrayMenu(false);

	// TEST: setEnabled(false, "Test", InfoWidget::Type::Info);
}

void TestAction::initContainerWidget() {
	m_textEdit = new QPlainTextEdit(m_defaultText);
	m_textEdit->setFixedHeight(70_px);
	m_textEdit->setPlaceholderText(i18n("Enter a message"));

	auto *layout = makeFormLayout();
	layout->addRow(i18n("Text:"), m_textEdit);
}

bool TestAction::onAction() {
	QString text = (m_textEdit != nullptr) ? m_textEdit->toPlainText() : "";
	text = text.trimmed();

	if (text.isEmpty())
		text = Utils::makeHTML("<h1 style=\"background-color: red; color: white\">" + i18n("Test") + "</h1>");

	UDialog::info(nullptr, text);
	
	return true;
}

void TestAction::readConfig() {
	m_defaultText = Config::readString(configGroup(), "Text", "");
}

void TestAction::writeConfig() {
	if (m_textEdit != nullptr)
		Config::writeString(configGroup(), "Text", m_textEdit->toPlainText());
}
