// infowidget.h - Info Widget
// Copyright (C) 2009  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include <QFrame>

#ifdef Q_OS_WIN32
	#include <QStyle>
#endif // Q_OS_WIN32

#ifdef KS_KF5
	#include <KMessageWidget>
#endif // KS_KF5

class ULabel;

class InfoWidget final: public QFrame {
public:
	enum class Type { Error, Info, Warning };

	explicit InfoWidget();
	virtual ~InfoWidget() = default;

	#ifdef KS_PURE_QT
	virtual bool event(QEvent *e) override;
	#endif // KS_PURE_QT

	static InfoWidget *info(const QString &text);
	static InfoWidget *warning(const QString &text);

	void setText(const QString &text, const Type type);
private:
	Q_DISABLE_COPY(InfoWidget)
#ifdef KS_KF5
	KMessageWidget *m_messageWidget;
#else
	bool m_handlePaletteChange = false;
	Type m_type = Type::Info;
	ULabel *m_messageWidget;
	void updateColors();
#endif // KS_KF5
};
