// ulabel.cpp - A widget with both icon and text
// Copyright (C) 2021  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#include "ulabel.h"
#include "utils.h"

#include <QDebug>

// public:

ULabel::ULabel(QWidget *parent)
	: QFrame(parent) {

	m_iconLabel = new QLabel();
	m_textLabel = new QLabel();

	auto *layout = new QHBoxLayout(this);
	setMarginAndSpacing(0_px, 0_px);

	layout->addWidget(m_iconLabel);
	layout->addWidget(m_textLabel);
	layout->addStretch();
}

QHBoxLayout *ULabel::labelLayout() {
	return dynamic_cast<QHBoxLayout *>(layout());
}

void ULabel::setIcon(const QIcon &value, const int size) {
	if (value.isNull()) {
		m_iconLabel->hide();
		m_iconLabel->setPixmap(QPixmap());
	}
	else {
		m_iconLabel->show();
		m_iconLabel->setPixmap(value.pixmap(size));
	}
}

void ULabel::setIcon(const QString &iconName, const int size) {
	setIcon(QIcon::fromTheme(iconName), size);
}

void ULabel::setIcon(const QStyle::StandardPixmap standardIcon, const int size) {
	setIcon(QApplication::style()->standardIcon(standardIcon), size);
}

void ULabel::setText(const QString &value) {
	m_textLabel->setText(value);
}

void ULabel::setMarginAndSpacing(const int margin, const int spacing) {
	//qDebug() << labelLayout()->contentsMargins();
	//qDebug() << labelLayout()->spacing();
	Utils::setMargin(labelLayout(), margin);
	labelLayout()->setSpacing(spacing);
}
