// ulabel.h - A widget with both icon and text
// Copyright (C) 2021  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#include <QHBoxLayout>
#include <QLabel>
#include <QStyle>

class ULabel final: public QFrame {
public:
	explicit ULabel(QWidget *parent = nullptr);
	QLabel *iconLabel() { return m_iconLabel; }
	QLabel *textLabel() { return m_textLabel; }
	QHBoxLayout *labelLayout();
	void setIcon(const QIcon &value, const int size);
	void setIcon(const QString &iconName, const int size);
	void setIcon(const QStyle::StandardPixmap standardIcon, const int size);
	void setText(const QString &value);
	void setMarginAndSpacing(const int margin, const int spacing);
private:
	Q_DISABLE_COPY(ULabel)
	QLabel *m_iconLabel;
	QLabel *m_textLabel;
};
