// usystemtray.h - A system tray and notification area
// Copyright (C) 2012  Konrad Twardowski
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

#pragma once

#ifdef KS_KF5
	#include <KStatusNotifierItem>
#else
	#include <QSystemTrayIcon>
#endif // KS_KF5

class MainWindow;

class USystemTray final: public QObject {
public:
	explicit USystemTray(MainWindow *mainWindow);
	virtual ~USystemTray() = default;
	void info(const QString &message) const;
	bool isSupported() const;
	static QPixmap makeIcon(const QIcon &baseIcon, const int size, const bool custom, const bool active, const QColor &normalColor, const QColor &activeColor);
	void setToolTip(const QString &toolTip);
	void setVisible(const bool visible);
	void updateIcon();
	void warning(const QString &message) const;
private:
	Q_DISABLE_COPY(USystemTray)
	#ifdef KS_KF5
	KStatusNotifierItem *m_trayIcon = nullptr;
	#else
	bool m_applyIconHack = true;
	bool m_sessionRestored;
	QSystemTrayIcon *m_trayIcon = nullptr;
	#endif // KS_KF5
	QString m_toolTip = QString();
	MainWindow *getMainWindow();
};
