#!/bin/bash

# DOC: https://clang.llvm.org/extra/clang-tidy/

if [ ! -d "src" ]; then
	echo "Usage: ./tools/clang-tidy.sh"
	exit 1
fi

CHECKS="*"\
",-altera-id-dependent-backward-branch,-altera-unroll-loops"\
",-cppcoreguidelines-avoid-goto,-cppcoreguidelines-avoid-magic-numbers,-cppcoreguidelines-init-variables"\
",-cppcoreguidelines-owning-memory,-cppcoreguidelines-pro-bounds-array-to-pointer-decay,-cppcoreguidelines-pro-type-static-cast-downcast,-cppcoreguidelines-pro-type-vararg"\
",-fuchsia-default-arguments-calls,-fuchsia-statically-constructed-objects"\
",-google-readability-braces-around-statements,-google-readability-todo"\
",-hicpp-avoid-goto,-hicpp-braces-around-statements,-hicpp-vararg,-hicpp-no-array-decay"\
",-llvmlibc-callee-namespace,-llvmlibc-implementation-in-namespace,-llvmlibc-restrict-system-libc-headers"\
",-misc-const-correctness"\
",-modernize-use-trailing-return-type"\
",-readability-braces-around-statements,-readability-convert-member-functions-to-static,-readability-function-cognitive-complexity,-readability-identifier-length,-readability-magic-numbers"

run-clang-tidy \
	-checks "$CHECKS" \
	-j2 \
	-p build.tmp
