/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import gps.log.GPSRecord;
import gps.log.out.GPSFile;

public final class GPSPLTFile
extends GPSFile {
    public final void writeFileHeader(String string) {
        super.writeFileHeader(string);
        this.writeTxt("BT747 Track Point File http://www.bt747.org Version 2.1.7\r\nWGS 84\r\nAltitude is in feet\r\nReserved 3\r\n0,2,255," + string + ",0,0,2,8421376\r\n50000\r\n");
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (gPSRecord != null && this.ptFilters[0].doFilter(gPSRecord)) {
            String string = "";
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                string = string + JavaLibBridge.toString(gPSRecord.getLatitude(), 6);
            }
            string = string + ",";
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                string = string + JavaLibBridge.toString(gPSRecord.getLongitude(), 6);
            }
            string = string + ",";
            string = string + "0,";
            string = gPSRecord.hasHeight() && this.selectedFileFields.hasHeight() ? string + (int)(gPSRecord.getHeight() * 3.28084f) : string + "-777";
            string = string + ",";
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                string = string + JavaLibBridge.toString(((double)gPSRecord.getUtc() + (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond() ? (double)gPSRecord.milisecond / 1000.0 : 0.0)) / 86400.0 + 25569.0, 7);
                string = string + ",";
                string = string + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + "/" + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay() + "/" + this.t.getYear() + "," + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + ":" + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute() + ":" + (this.t.getSecond() < 10 ? "0" : "") + this.t.getSecond();
                if (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond()) {
                    string = string + ".";
                    string = string + (gPSRecord.milisecond < 100 ? "0" : "");
                    string = string + (gPSRecord.milisecond < 10 ? "0" : "");
                    string = string + gPSRecord.milisecond;
                }
            } else {
                string = string + ",,";
            }
            string = string + "\r\n";
            this.writeTxt(string);
        }
    }
}

