/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.IOError;

public class UserFont {
    public short fontType;
    public short firstChar;
    public short lastChar;
    public short maxWidth;
    public short kernMax;
    public short nDescent;
    public short fRectWidth;
    public short fRectHeight;
    public short owTLoc;
    public short ascent;
    public short descent;
    public short leading;
    public short rowWords;
    public int rowWidthInBytes;
    public int numberOfChars;
    public int bitmapTableSize;
    public byte[] bitmapTable;
    public short[] bitIndexTable;
    public boolean loaded;

    protected UserFont() {
    }

    public UserFont(String fontName, String sufix) {
        block9: {
            Catalog c = new Catalog(String.valueOf(fontName) + ".Font.Font", 1);
            if (!c.isOpen()) {
                c = new Catalog(String.valueOf(fontName) + sufix + ".Font.Font", 1);
            }
            if (!c.isOpen()) break block9;
            try {
                fontName = String.valueOf(fontName) + sufix;
                DataStream ds = new DataStream(c);
                int n = c.getRecordCount();
                if (n > 1) {
                    boolean found = false;
                    int i = 0;
                    while (i < n) {
                        String name;
                        if (c.setRecordPos(i) && (name = ds.readCString()).equals(fontName)) {
                            int l = name.length() + 1;
                            ds.skip((l + 3) / 4 * 4 - l);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        c.close();
                        return;
                    }
                } else {
                    c.setRecordPos(0);
                }
                this.fontType = ds.readShort();
                this.firstChar = ds.readShort();
                this.lastChar = ds.readShort();
                this.maxWidth = ds.readShort();
                this.kernMax = ds.readShort();
                this.nDescent = ds.readShort();
                this.fRectWidth = ds.readShort();
                this.fRectHeight = ds.readShort();
                this.owTLoc = ds.readShort();
                this.ascent = ds.readShort();
                this.descent = ds.readShort();
                this.leading = ds.readShort();
                this.rowWords = ds.readShort();
                this.rowWidthInBytes = this.rowWords << 1;
                this.numberOfChars = this.lastChar - this.firstChar + 1;
                this.bitmapTableSize = this.rowWidthInBytes * this.fRectHeight;
                this.bitmapTable = new byte[this.bitmapTableSize];
                ds.readBytes(this.bitmapTable);
                this.bitIndexTable = new short[this.numberOfChars + 2];
                int i = 0;
                while (i < this.bitIndexTable.length) {
                    this.bitIndexTable[i] = ds.readShort();
                    ++i;
                }
                this.loaded = true;
                c.close();
            }
            catch (IOError iOError) {}
        }
    }

    public int charWidth(char ch) {
        short offset;
        byte width;
        if (ch == '\r' || ch == '\n') {
            return 0;
        }
        int index = (short)ch - this.firstChar;
        if (index < 0 || ch > this.lastChar) {
            index = this.numberOfChars;
        }
        if ((width = (byte)(this.bitIndexTable[index + 1] - (offset = this.bitIndexTable[index]))) == 0 && ch != '\r') {
            width = (byte)(this.bitIndexTable[this.numberOfChars + 1] - this.bitIndexTable[this.numberOfChars]);
        }
        return width;
    }

    public void setCharBits(char ch, CharBits bits) {
        int index;
        if (ch > '\u00ff') {
            ch = '\u0000';
        }
        if ((index = (short)ch - this.firstChar) >= 0 && ch <= this.lastChar) {
            bits.offset = this.bitIndexTable[index];
            bits.width = this.bitIndexTable[index + 1] - bits.offset;
            if (bits.width > 0) {
                return;
            }
        }
        index = this.numberOfChars;
        bits.offset = this.bitIndexTable[index];
        bits.width = this.bitIndexTable[index + 1] - bits.offset;
    }

    public int stringWidth(String s) {
        char[] ac = s.toCharArray();
        int sum = 0;
        int i = ac.length - 1;
        while (i >= 0) {
            sum += this.charWidth(ac[i]);
            --i;
        }
        return sum;
    }

    public int stringWidth(char[] chars, int start, int length) {
        int sum = 0;
        while (length-- > 0) {
            sum += this.charWidth(chars[start++]);
        }
        return sum;
    }

    public static class CharBits {
        public int rowWIB;
        public byte[] charBitmapTable;
        public int offset;
        public int width;

        public CharBits setFrom(UserFont f) {
            this.rowWIB = f.rowWidthInBytes;
            this.charBitmapTable = f.bitmapTable;
            this.width = 0;
            this.offset = 0;
            return this;
        }
    }
}

