/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Palette;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;

public final class Color {
    protected int red;
    protected int green;
    protected int blue;
    protected int rgb;
    protected int gray;
    public int equ;
    protected Color bright;
    protected Color dark;
    private static Hashtable htColors = new Hashtable(2047);
    private static boolean isGray = Settings.isColor ^ true;
    private static int colorDiv = Settings.maxColors == 4 ? 6 : 4;
    private static int fadeStep = Settings.maxColors == 4 ? 1 : 7;
    private static int smallerFadeStep = Settings.maxColors == 4 ? 1 : 4;
    private Color cursor;
    private Color lbright;
    private Color ldark;
    private Color hdark;
    public static final Color WHITE = Color.getColor(255, 255, 255);
    public static final Color BRIGHT = Color.getColor(191, 191, 191);
    public static final Color DARK = Color.getColor(127, 127, 127);
    public static final Color BLACK = Color.getColor(0, 0, 0);
    public static final Color RED = Color.getColor(255, 0, 0);
    public static final Color PINK = Color.getColor(255, 175, 175);
    public static final Color ORANGE = Color.getColor(255, 200, 0);
    public static final Color YELLOW = Color.getColor(255, 255, 0);
    public static final Color GREEN = Color.getColor(0, 255, 0);
    public static final Color MAGENTA = Color.getColor(255, 0, 255);
    public static final Color CYAN = Color.getColor(0, 255, 255);
    public static final Color BLUE = Color.getColor(0, 0, 255);
    public static final int WHITE_PIXEL = Settings.isHighColor ? 0xFFFFFF : (Settings.isColor ? 0 : Settings.maxColors - 1);

    private Color() {
    }

    public Color(int rgb) {
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.rgb = rgb;
        this.equ = isGray ? (this.gray = ((this.red << 5) + (this.green << 6) + (this.blue << 2)) / 100 >> colorDiv) : this.rgb;
    }

    public Color(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.rgb = red << 16 | green << 8 | blue;
        this.equ = isGray ? (this.gray = ((red << 5) + (green << 6) + (blue << 2)) / 100 >> colorDiv) : this.rgb;
    }

    public Color(String rrggbb) {
        this((int)Convert.toLong(rrggbb, 16));
    }

    public Color brighter() {
        if (this.bright == null) {
            this.bright = isGray ? Palette.SystemPalette.getColor(this.gray + fadeStep) : new Color(this.min(this.red + 96, 255), this.min(this.green + 96, 255), this.min(this.blue + 96, 255));
        }
        return this.bright;
    }

    public Color brighter(int step) {
        if (isGray) {
            return Palette.SystemPalette.getColor(this.gray + step);
        }
        return new Color(this.min(this.red + step, 255), this.min(this.green + step, 255), this.min(this.blue + step, 255));
    }

    public Color darker() {
        if (this.dark == null) {
            this.dark = isGray ? Palette.SystemPalette.getColor(this.gray - fadeStep) : new Color(this.max(this.red - 96, 0), this.max(this.green - 96, 0), this.max(this.blue - 96, 0));
        }
        return this.dark;
    }

    public Color darker(int step) {
        if (isGray) {
            return Palette.SystemPalette.getColor(this.gray - step);
        }
        return new Color(this.max(this.red - step, 0), this.max(this.green - step, 0), this.max(this.blue - step, 0));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Color) {
            return ((Color)obj).equ == this.equ;
        }
        return false;
    }

    public int getAlpha() {
        return ((this.red << 5) + (this.green << 6) + (this.blue << 2)) / 100;
    }

    public int getBlue() {
        return this.blue;
    }

    public static Color getColor(int rgb) {
        return Color.getColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static Color getColor(int red, int green, int blue) {
        int key = isGray ? ((red << 5) + (green << 6) + (blue << 2)) / 100 >> colorDiv : red << 16 | green << 8 | blue;
        Color c = null;
        try {
            c = (Color)htColors.get(key);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (c == null) {
            c = new Color();
            c.red = red;
            c.green = green;
            c.blue = blue;
            if (isGray) {
                c.rgb = red << 16 | green << 8 | blue;
                c.equ = c.gray = key;
            } else {
                c.equ = c.rgb = key;
            }
            htColors.put(c, c);
        }
        return c;
    }

    public static Color getColor(String rrggbb) {
        return Color.getColor((int)Convert.toLong(rrggbb, 16));
    }

    public Color getCursorColor() {
        if (this.cursor == null) {
            int maxColors = Settings.maxColors;
            this.cursor = maxColors == 4 ? Palette.SystemPalette.getColor(1) : (this.getAlpha() > 128 ? this.darker(maxColors >= 256 ? 96 : smallerFadeStep) : this.brighter(maxColors >= 256 ? 96 : smallerFadeStep));
        }
        return this.cursor;
    }

    public int getGray() {
        return isGray ? this.gray : this.getAlpha();
    }

    public int getGreen() {
        return this.green;
    }

    public int getRGB() {
        return this.rgb;
    }

    public int getRed() {
        return this.red;
    }

    public Color halfDarker() {
        if (this.hdark == null) {
            this.hdark = isGray ? Palette.SystemPalette.getColor(this.gray - (fadeStep >> 1)) : new Color(this.max(this.red - 48, 0), this.max(this.green - 48, 0), this.max(this.blue - 48, 0));
        }
        return this.hdark;
    }

    public int hashCode() {
        return this.equ;
    }

    public Color lessBrighter() {
        if (this.lbright == null) {
            this.lbright = isGray ? Palette.SystemPalette.getColor(this.gray + smallerFadeStep) : new Color(this.min(this.red + 32, 255), this.min(this.green + 32, 255), this.min(this.blue + 32, 255));
        }
        return this.lbright;
    }

    public Color lessDarker() {
        if (this.ldark == null) {
            this.ldark = isGray ? Palette.SystemPalette.getColor(this.gray - smallerFadeStep) : new Color(this.max(this.red - 32, 0), this.max(this.green - 32, 0), this.max(this.blue - 32, 0));
        }
        return this.ldark;
    }

    private final int max(int i1, int i2) {
        return i1 > i2 ? i1 : i2;
    }

    private final int min(int i1, int i2) {
        return i1 < i2 ? i1 : i2;
    }

    public String toString() {
        return isGray ? Convert.toString(this.gray) : Convert.unsigned2hex(this.rgb, 6);
    }
}

