/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.applet.Applet;
import waba.applet.JavaBridge;
import waba.applet.UserFont;
import waba.fx.Color;
import waba.fx.Coord;
import waba.fx.Font;
import waba.fx.ISurface;
import waba.fx.Image;
import waba.fx.NativeMethods4JDK;
import waba.fx.Palette;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.MainWindow;
import waba.ui.Window;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;
import waba.util.IntHashtable;
import waba.util.IntVector;

public class Graphics {
    public Font lastFont;
    protected int drawOp;
    protected ISurface surface;
    public static final byte R3D_EDIT = 1;
    public static final byte R3D_LOWERED = 2;
    public static final byte R3D_RAISED = 3;
    public static final byte R3D_CHECK = 4;
    public static final byte R3D_SHADED = 5;
    public static final byte ARROW_UP = 1;
    public static final byte ARROW_DOWN = 2;
    public static final byte ARROW_LEFT = 3;
    public static final byte ARROW_RIGHT = 4;
    public static final int DRAW_PAINT = 0;
    public static final int DRAW_ERASE = 1;
    public static final int DRAW_MASK = 2;
    public static final int DRAW_INVERT = 3;
    public static final int DRAW_OVERLAY = 4;
    public static final int DRAW_PAINT_INVERSE = 5;
    public static final int DRAW_SPRITE = 6;
    public static final int DRAW_REPLACE_COLOR = 7;
    public static final int DRAW_SWAP_COLORS = 8;
    protected static int[] currentPalette;
    protected static Palette ScreenPalette;
    private int MaxScreenX = Settings.screenWidth;
    private int MaxScreenY = Settings.screenHeight;
    private int TRANSX;
    private int TRANSY;
    private int CLIPX1;
    private int CLIPY1;
    private int CLIPX2 = this.MaxScreenX;
    private int CLIPY2 = this.MaxScreenY;
    private int maxX = this.MaxScreenX;
    private int maxY = this.MaxScreenY;
    private Font font;
    private static UserFont.CharBits charBits;
    private static int[] ands8Mask;
    private int[][] pixels;
    private int foreColor = Color.BLACK.getRGB();
    private int backColor = Color.BRIGHT.getRGB();
    private static int badParamCount;
    private boolean isntImage;
    static Color lastColor;
    static int lastColorValue;
    private static final int RANGE = 4000;
    private static boolean moreThan4;
    private static Hashtable htVistaColors;

    static {
        int[] nArray = Settings.maxColors >= 256 ? NativeMethods4JDK.getDefault256Palette() : (currentPalette = Settings.maxColors == 16 ? Palette.default16PaletteDev2Scr : Palette.default4PaletteDev2Scr);
        ScreenPalette = Settings.maxColors >= 256 ? new Palette(NativeMethods4JDK.getDefault256Palette()) : (Settings.maxColors == 16 ? new Palette(Palette.default16PaletteScr2Dev) : new Palette(Palette.default4PaletteScr2Dev));
        charBits = new UserFont.CharBits();
        ands8Mask = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        badParamCount = 0;
        moreThan4 = Settings.maxColors > 4;
        htVistaColors = new Hashtable(83);
    }

    public Graphics(ISurface surface) {
        this.surface = surface;
        this.isntImage = surface instanceof Image ^ true;
        if (Settings.maxColors > 256) {
            ScreenPalette = null;
        }
        this.pixels = this.getPixels(surface);
        this.font = MainWindow.defaultFont;
        if (!this.isntImage) {
            this.maxX = this.CLIPX2 = ((Image)surface).width;
            this.maxY = this.CLIPY2 = ((Image)surface).height;
        }
    }

    protected static void _applyPalette(int[] palrgb, int startIndex, int endIndex) {
        IntHashtable ht = new IntHashtable(300);
        int i = startIndex;
        while (i <= endIndex) {
            ht.put(currentPalette[i], palrgb[i]);
            ++i;
        }
        Graphics g = MainWindow.getMainWindow().createGraphics();
        int width = g.pixels[0].length;
        int height = g.pixels.length;
        int j = 0;
        while (j < height) {
            int i2 = 0;
            while (i2 < width) {
                int newPt;
                int oldPt = g.getPixelNOCT(i2, j);
                try {
                    newPt = ht.get(oldPt);
                }
                catch (ElementNotFoundError elementNotFoundError) {
                    newPt = IntHashtable.INVALID;
                }
                if (newPt != IntHashtable.INVALID) {
                    g.setPixelNOCT(i2, j, newPt);
                }
                ++i2;
            }
            ++j;
        }
        Vm.copyArray(palrgb, startIndex, currentPalette, startIndex, endIndex - startIndex + 1);
        if (Settings.maxColors <= 256) {
            ScreenPalette = new Palette(currentPalette);
        }
    }

    public static void applyPalette(Palette pal, int startIndex, int endIndex) {
        if (Settings.isColor) {
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (endIndex < 0) {
                endIndex = pal.size() - 1;
            }
            Graphics._applyPalette(pal.toRGBArray(startIndex, endIndex), startIndex, endIndex);
        }
    }

    private void arcPiePointDrawAndFill(int xc, int yc, int rx, int ry, float startAngle, float endAngle, int c, int c2, boolean fill, boolean pie, int[] startAnglePoint) {
        int index;
        boolean checkClipY;
        int[] xPoints = null;
        int[] yPoints = null;
        int nPoints = 0;
        int lastSize = 0;
        float lastPPD = 0.0f;
        int size = 0;
        int oldX = 0;
        int oldY = 0;
        boolean checkClipX = xc + rx + this.TRANSX > this.CLIPX2 || xc - rx + this.TRANSX < this.CLIPX1;
        boolean bl = checkClipY = yc + ry + this.TRANSY > this.CLIPY2 || yc - ry + this.TRANSY < this.CLIPY1;
        if (rx < 0 || ry < 0) {
            return;
        }
        if ((double)startAngle < 0.1 && (double)endAngle > 359.9) {
            if (fill) {
                this.ellipseDrawAndFill(xc, yc, rx, ry, c2, true);
            }
            this.ellipseDrawAndFill(xc, yc, rx, ry, c, false);
            return;
        }
        int t1 = rx * rx;
        int t2 = t1 << 1;
        int t3 = t2 << 1;
        int t4 = ry * ry;
        int t5 = t4 << 1;
        int t6 = t5 << 1;
        int t7 = rx * t5;
        int t8 = t7 << 1;
        int t9 = 0;
        int d1 = t2 - t7 + (t4 >> 1);
        int d2 = (t1 >> 1) - t8 + t5;
        int x = rx;
        int y = 0;
        while (d2 < 0) {
            ++y;
            t9 += t3;
            if (d1 < 0) {
                d1 += t9 + t2;
                d2 += t9;
            } else {
                --x;
                d1 += t9 + t2 - (t8 -= t6);
                d2 += t9 + t5 - t8;
            }
            ++size;
        }
        do {
            --x;
            t8 -= t6;
            if (d2 < 0) {
                ++y;
                d2 += (t9 += t3) + t5 - t8;
            } else {
                d2 += t5 - t8;
            }
            ++size;
        } while (x >= 0);
        int nq = size;
        float ppd = (float)(size *= 4) / 360.0f;
        if (nPoints < (size += 2)) {
            xPoints = new int[size];
            yPoints = new int[size];
            if (xPoints == null || yPoints == null) {
                return;
            }
        }
        t2 = t1 << 1;
        t3 = t2 << 1;
        t8 = t7 << 1;
        t9 = 0;
        d1 = t2 - t7 + (t4 >> 1);
        d2 = (t1 >> 1) - t8 + t5;
        x = rx;
        y = 0;
        int i = 0;
        while (d2 < 0) {
            index = nq * 0 + i;
            xPoints[index] = checkClipX ? this.doClipX(xc + x) : xc + x;
            yPoints[index] = checkClipY ? this.doClipY(yc - y) : yc - y;
            index = nq * 2 - i - 1;
            xPoints[index] = checkClipX ? this.doClipX(xc - x) : xc - x;
            yPoints[index] = checkClipY ? this.doClipY(yc - y) : yc - y;
            index = nq * 2 + i;
            xPoints[index] = checkClipX ? this.doClipX(xc - x) : xc - x;
            yPoints[index] = checkClipY ? this.doClipY(yc + y) : yc + y;
            index = nq * 4 - i - 1;
            xPoints[index] = checkClipX ? this.doClipX(xc + x) : xc + x;
            yPoints[index] = checkClipY ? this.doClipY(yc + y) : yc + y;
            ++i;
            ++y;
            t9 += t3;
            if (d1 < 0) {
                d1 += t9 + t2;
                d2 += t9;
                continue;
            }
            --x;
            d1 += t9 + t2 - (t8 -= t6);
            d2 += t9 + t5 - t8;
        }
        do {
            index = nq * 0 + i;
            xPoints[index] = checkClipX ? this.doClipX(xc + x) : xc + x;
            yPoints[index] = checkClipY ? this.doClipY(yc - y) : yc - y;
            index = nq * 2 - i - 1;
            xPoints[index] = checkClipX ? this.doClipX(xc - x) : xc - x;
            yPoints[index] = checkClipY ? this.doClipY(yc - y) : yc - y;
            index = nq * 2 + i;
            xPoints[index] = checkClipX ? this.doClipX(xc - x) : xc - x;
            yPoints[index] = checkClipY ? this.doClipY(yc + y) : yc + y;
            index = nq * 4 - i - 1;
            xPoints[index] = checkClipX ? this.doClipX(xc + x) : xc + x;
            yPoints[index] = checkClipY ? this.doClipY(yc + y) : yc + y;
            ++i;
            --x;
            t8 -= t6;
            if (d2 < 0) {
                ++y;
                d2 += (t9 += t3) + t5 - t8;
                continue;
            }
            d2 += t5 - t8;
        } while (x >= 0);
        lastPPD = ppd;
        lastSize = size;
        int startIndex = (int)(ppd * startAngle);
        int endIndex = (int)(ppd * endAngle);
        if (startAnglePoint != null) {
            startAnglePoint[0] = xPoints[startIndex];
            startAnglePoint[1] = yPoints[startIndex];
            return;
        }
        if (endIndex == lastSize - 2) {
            --endIndex;
        }
        ++endIndex;
        if (pie) {
            oldX = xPoints[endIndex];
            oldY = yPoints[endIndex];
            xPoints[endIndex] = xc;
            yPoints[endIndex] = yc;
            ++endIndex;
        }
        int n = endIndex - startIndex;
        int[] newX = new int[n + 1];
        int[] newY = new int[n + 1];
        Vm.copyArray(xPoints, startIndex, newX, 0, n);
        Vm.copyArray(yPoints, startIndex, newY, 0, n);
        if (fill) {
            this.fillPolygon(newX, newY, n, c2);
        }
        this.drawPolygon(newX, newY, n, c, pie);
        if (pie) {
            xPoints[endIndex - 1] = oldX;
            yPoints[endIndex - 1] = oldY;
        }
    }

    private void badParam(String s) {
        if (badParamCount == 0) {
            Vm.warning("A bad parameter was found when calling a Graphics routine. Please debug your application to find the bug. If you don't do it, next time you run your program in the device, the VM will probably CRASH.\n");
        }
        if (badParamCount++ < 10) {
            try {
                throw new Exception("Bad parameter in " + s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearClip() {
        this.setClip(0, 0, this.maxX, this.maxY);
    }

    public void clearScreen() {
        int y = 0;
        while (y < this.maxY) {
            int w = this.maxX;
            if (this.isntImage) {
                JavaBridge.GraphicsLine(this.surface, 0, y, w - 1, y, this.backColor);
            }
            int[] pix = this.pixels[y];
            while (--w >= 0) {
                pix[w] = this.backColor;
            }
            ++y;
        }
    }

    public boolean clip(Rect r) {
        int[] xywh = new int[]{r.x, r.y, r.width, r.height};
        if (this.translateAndClip(xywh)) {
            r.x = xywh[0] - this.TRANSX;
            r.y = xywh[1] - this.TRANSY;
            r.width = xywh[2];
            r.height = xywh[3];
            return true;
        }
        return false;
    }

    public boolean collisionDetect(ISurface surface, int x1, int y1, Image img, int x2, int y2) {
        int[][] pixels1 = this.getPixels(surface);
        int[][] pixels2 = this.getPixels(img);
        Rect rect1 = new Rect(x1, y1, pixels1[0].length, pixels1.length);
        Rect rect2 = new Rect(x2, y2, pixels2[0].length, pixels2.length);
        if (!(surface instanceof Image)) {
            rect1.width -= rect1.x;
            rect1.height -= rect1.y;
        }
        if (!this.intersects(rect1, rect2)) {
            return false;
        }
        Rect rect = this.intersection(rect1, rect2);
        int w = rect.width;
        int h = rect.height;
        x1 = rect.x - rect1.x;
        y1 = rect.y - rect1.y;
        x2 = rect.x - rect2.x;
        y2 = rect.y - rect2.y;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (pixels1[y1 + j][x1 + i] != this.backColor && pixels2[y2 + j][x2 + i] != this.backColor) {
                    return true;
                }
                ++i;
            }
            ++j;
        }
        return false;
    }

    public static void compute3dColors(boolean enabled, Color backColor, Color foreColor, Color[] fourColors) {
        if (fourColors[0] != backColor) {
            fourColors[0] = backColor;
            fourColors[1] = backColor.lessBrighter();
            if (fourColors[0].equ == fourColors[1].equ) {
                fourColors[1] = fourColors[0].lessDarker();
            }
            fourColors[0] = moreThan4 ? fourColors[0].halfDarker() : fourColors[0].darker();
        }
        if (fourColors[3] != foreColor) {
            fourColors[2] = foreColor.lessBrighter();
            fourColors[3] = foreColor;
            if (moreThan4 && !enabled) {
                fourColors[3] = fourColors[2];
                fourColors[2] = fourColors[2].lessBrighter();
            }
            if (enabled && !Settings.isColor && Settings.uiStyle == 1) {
                fourColors[2] = Color.BLACK;
            }
        }
    }

    public void copyImageRect(Image src, int x, int y, int width, int height, int drawOp, Color backColor, boolean doClip) {
        int[][] srcPixels;
        int transpPixel = Graphics.getPalColor(Color.getColor(src.transparentPixel));
        if (backColor != null && drawOp != 0 && (transpPixel != lastColorValue || backColor != lastColor)) {
            lastColor = backColor;
            transpPixel = lastColorValue = Graphics.getPalColor(backColor);
        }
        if (transpPixel < 0) {
            transpPixel = lastColorValue;
        }
        if ((srcPixels = this.getPixels(src)) != null) {
            this.drawBitmap(srcPixels, x, y, width, height, 0, 0, drawOp, transpPixel, this.foreColor, doClip);
        }
    }

    public void copyRect(ISurface surface, int x, int y, int width, int height, int dstX, int dstY) {
        int[][] srcPixels = this.getPixels(surface);
        if (srcPixels != null) {
            this.drawBitmap(srcPixels, x, y, width, height, dstX, dstY, this.drawOp, this.backColor, this.foreColor, true);
        }
    }

    public void copyScreen(ISurface src, int ySrc, int yDst, int height) {
        int[][] srcPixels;
        if (ySrc < 0 || yDst < 0 || ySrc + height > this.MaxScreenY || yDst + height > this.MaxScreenY) {
            this.badParam("copyScreen(" + src + ',' + ySrc + ',' + yDst + ',' + height + ")");
        }
        if ((srcPixels = this.getPixels(src)) != null) {
            if (srcPixels[0].length != this.MaxScreenX || this.pixels[0].length != this.MaxScreenX) {
                this.badParam("copyScreen surfaces must have the screen width (" + srcPixels[0].length + " or " + this.pixels[0].length + ")!");
            }
            while (height-- > 0) {
                this.drawScanLine(srcPixels[ySrc++], 0, 0, yDst++, this.MaxScreenX);
            }
        }
    }

    private int doClipX(int x) {
        return x + this.TRANSX < this.CLIPX1 ? this.CLIPX1 - this.TRANSX : (x + this.TRANSX >= this.CLIPX2 ? this.CLIPX2 - this.TRANSX : x);
    }

    private int doClipY(int y) {
        return y + this.TRANSY < this.CLIPY1 ? this.CLIPY1 - this.TRANSY : (y + this.TRANSY >= this.CLIPY2 ? this.CLIPY2 - this.TRANSY : y);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw3dRect(int x, int y, int width, int height, byte type, boolean yMirror, boolean simple, Color[] fourColors) {
        if (type == 5) {
            boolean menu = simple;
            this.drawLine(menu ? 0 : 1, 0, menu ? width - 1 : width - 3, 0);
            this.drawLine(0, 1, 0, height - 3);
            this.drawLine(width - 2, 1, width - 2, height - 3);
            this.drawLine(width - 1, menu ? 1 : 2, width - 1, height - 3);
            this.drawLine(1, height - 2, width - 2, height - 2);
            this.drawLine(2, height - 1, width - 3, height - 1);
            return;
        }
        switch (Settings.uiStyle) {
            case 0: {
                switch (type) {
                    case 1: {
                        this.drawHighLightFrame(x, y, width, height, fourColors[2], fourColors[1], yMirror);
                        if (simple) return;
                        this.drawHighLightFrame(x + 1, y + 1, width - 2, height - 2, fourColors[3], fourColors[0], yMirror);
                        return;
                    }
                    case 2: {
                        this.drawHighLightFrame(x, y, width, height, fourColors[3], fourColors[0], yMirror);
                        if (simple) return;
                        this.drawHighLightFrame(x + 1, y + 1, width - 2, height - 2, fourColors[2], fourColors[1], yMirror);
                        return;
                    }
                    case 3: {
                        this.drawHighLightFrame(x, y, width, height, fourColors[0], fourColors[3], yMirror);
                        if (simple) return;
                        this.drawHighLightFrame(x + 1, y + 1, width - 2, height - 2, fourColors[1], fourColors[2], yMirror);
                        return;
                    }
                    case 4: {
                        this.drawHighLightFrame(x, y, width, height, fourColors[2], fourColors[1], yMirror);
                        if (simple) return;
                        this.drawHighLightFrame(x + 1, y + 1, width - 2, height - 2, fourColors[3], fourColors[0], yMirror);
                        return;
                    }
                }
                return;
            }
            case 1: {
                this.setForeColor(fourColors[2]);
                switch (type) {
                    case 4: {
                        this.drawRect(x, y, width, height);
                        return;
                    }
                    case 1: {
                        int h = height - 1;
                        this.drawDots(x, y + h, x + width - 1, y + h);
                        return;
                    }
                    case 2: {
                        this.setBackColor(fourColors[1]);
                        if (simple) {
                            this.fillRect(x, y, width, height);
                        } else {
                            this.fillHatchedRect(x, y, width, height, true, true);
                        }
                    }
                    case 3: {
                        if (simple) {
                            this.drawRect(x, y, width, height);
                            return;
                        }
                        this.drawHatchedRect(x, y, width, height, true, true);
                        return;
                    }
                }
                return;
            }
            case 2: {
                this.setForeColor(fourColors[2]);
                switch (type) {
                    case 4: {
                        this.drawRect(x, y, width, height);
                        return;
                    }
                    case 1: {
                        this.drawRect(x, y, x + width - 1, y + height);
                        return;
                    }
                    case 2: {
                        this.setBackColor(fourColors[1]);
                        this.fillRect(x, y, width, height);
                    }
                    case 3: {
                        this.drawRect(x, y, width, height);
                        return;
                    }
                }
                return;
            }
            case 3: {
                this.setForeColor(fourColors[2]);
                switch (type) {
                    case 4: {
                        this.setForeColor(fourColors[0]);
                        this.drawRect(x, y, width, height);
                        return;
                    }
                    case 1: {
                        this.drawRect(x, y, x + width - 1, y + height);
                        return;
                    }
                    case 3: {
                        this.drawVistaRect(x, y, width, height, fourColors[1], fourColors[1], fourColors[2], fourColors[3]);
                        return;
                    }
                    case 2: {
                        this.drawVistaRect(x, y, width, height, fourColors[2], fourColors[1], fourColors[1], fourColors[3]);
                        return;
                    }
                }
                return;
            }
        }
    }

    public void drawArc(int xc, int yc, int r, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, r, r, startAngle, endAngle, this.foreColor, this.foreColor, false, false);
    }

    public void drawArrow(int x, int y, int h, byte type, boolean pressed, boolean enabled, Color fore) {
        this.setForeColor(enabled ? fore : fore.getCursorColor());
        if (pressed) {
            ++x;
            ++y;
        }
        int step = 1;
        if (type == 4 || type == 3) {
            if (type == 3) {
                x += h - 1;
                step = -1;
            }
            --h;
            while (h >= 0) {
                this.drawLine(x, y, x, y + (h << 1));
                x += step;
                ++y;
                --h;
            }
        } else {
            if (type == 1) {
                y += h - 1;
                step = -1;
            }
            --h;
            while (h >= 0) {
                this.drawLine(x, y, x + (h << 1), y);
                y += step;
                ++x;
                --h;
            }
        }
    }

    private void drawBitmap(int[][] pixels, int x, int y, int width, int height, int dstX, int dstY, int drawOp, int backColor, int foreColor, boolean doClip) {
        try {
            int i;
            int bmpW = pixels[0].length;
            int bmpH = pixels.length;
            dstX += this.TRANSX;
            dstY += this.TRANSY;
            if (!doClip) {
                if (x <= -width || x >= bmpW || y <= -height || y >= bmpH) {
                    return;
                }
            } else {
                if (x < 0) {
                    width += x;
                    dstX -= x;
                    x = 0;
                }
                if (width > (i = bmpW - x)) {
                    width = i;
                }
                if (y < 0) {
                    height += y;
                    dstY -= y;
                    y = 0;
                }
                if (height > (i = bmpH - y)) {
                    height = i;
                }
                if (dstX < this.CLIPX1) {
                    i = this.CLIPX1 - dstX;
                    dstX = this.CLIPX1;
                    x += i;
                    width -= i;
                }
                if (dstX + width > this.CLIPX2) {
                    width = this.CLIPX2 - dstX;
                }
                if (dstY < this.CLIPY1) {
                    i = this.CLIPY1 - dstY;
                    dstY = this.CLIPY1;
                    y += i;
                    height -= i;
                }
                if (dstY + height > this.CLIPY2) {
                    height = this.CLIPY2 - dstY;
                }
                if (width <= 0 || height <= 0) {
                    return;
                }
            }
            if (drawOp == 0) {
                int j = 0;
                while (j < height) {
                    this.drawScanLine(pixels[y + j], x, dstX, dstY + j, width);
                    ++j;
                }
            } else if (drawOp == 1 || drawOp == 2 || drawOp == 3 || drawOp == 4 || drawOp == 5) {
                int sub = Settings.maxColors - 1;
                boolean usePalette = sub <= 255;
                int j = 0;
                while (j < height) {
                    int[] pix = pixels[y + j];
                    i = 0;
                    while (i < width) {
                        int screenPt = this.getPixelNOCT(dstX + i, dstY + j);
                        int bmpPt = pix[x + i];
                        if (usePalette) {
                            screenPt = sub - Color.getColor(screenPt).getAlpha();
                            if (sub >= 255) {
                                bmpPt = sub - Color.getColor(bmpPt).getAlpha();
                            }
                        }
                        switch (drawOp) {
                            case 1: {
                                screenPt &= bmpPt;
                                break;
                            }
                            case 2: {
                                screenPt &= ~bmpPt;
                                break;
                            }
                            case 3: {
                                screenPt ^= bmpPt;
                                break;
                            }
                            case 4: {
                                screenPt |= bmpPt;
                                break;
                            }
                            case 5: {
                                screenPt = ~bmpPt;
                                break;
                            }
                        }
                        if (usePalette) {
                            screenPt = Palette.SystemPalette.getColor((int)screenPt).rgb;
                        }
                        this.setPixelNOCT(dstX + i, dstY + j, screenPt);
                        ++i;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < height) {
                    int[] pix = pixels[y + j];
                    i = 0;
                    while (i < width) {
                        int screenPt = this.getPixelNOCT(dstX + i, dstY + j);
                        int bmpPt = pix[x + i];
                        switch (drawOp) {
                            case 6: {
                                if (bmpPt == backColor) break;
                                screenPt = bmpPt;
                                break;
                            }
                            case 7: {
                                if (bmpPt == backColor) break;
                                screenPt = foreColor;
                                break;
                            }
                            case 8: {
                                if (bmpPt == backColor) {
                                    screenPt = foreColor;
                                    break;
                                }
                                if (bmpPt != foreColor) break;
                                screenPt = backColor;
                                break;
                            }
                        }
                        this.setPixelNOCT(dstX + i, dstY + j, screenPt);
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            Vm.warning("Exception in drawBitmap\ndrawBitmap(" + x + ',' + y + ',' + width + ',' + height + " -> " + dstX + ',' + dstY + ',' + doClip + ")\n" + "clip: " + this.CLIPX1 + "," + this.CLIPY1 + "," + this.CLIPX2 + "," + this.CLIPY2 + " - trans: " + this.TRANSX + "," + this.TRANSY);
            e.printStackTrace();
        }
    }

    public void drawCircle(int xc, int yc, int r) {
        this.ellipseDrawAndFill(xc, yc, r, r, this.foreColor, false);
    }

    public void drawCursor(int x, int y, int w, int h) {
        int[] xywh = new int[]{x, y, w, h};
        if (this.translateAndClip(xywh)) {
            x = xywh[0];
            y = xywh[1];
            w = xywh[2];
            h = xywh[3];
            int x2 = x + w;
            int xx = x;
            while (xx < x2) {
                this.invVLineNOCT(xx, y, h);
                ++xx;
            }
        }
    }

    public void drawCursorOutline(int x, int y, int width, int height) {
        int[] xywh = new int[]{x, y, width, height};
        if (this.translateAndClip(xywh)) {
            x = xywh[0];
            y = xywh[1];
            width = xywh[2];
            height = xywh[3];
            int h = height - 1;
            int i = 0;
            while (true) {
                int yy = i + y;
                if (i == 0 || i == h) {
                    int k = 0;
                    while (k < width) {
                        this.invPixelNOCT(x + k, yy);
                        ++k;
                    }
                    if (i == h) {
                        break;
                    }
                } else {
                    this.invPixelNOCT(x, yy);
                    this.invPixelNOCT(x + width - 1, yy);
                }
                ++i;
            }
        }
    }

    public void drawDots(int Ax, int Ay, int Bx, int By) {
        this.drawDottedLine(Ax, Ay, Bx, By, this.foreColor, this.backColor);
    }

    public void drawDottedCursor(int x, int y, int width, int height) {
        y += this.TRANSY;
        int x2 = (x += this.TRANSX) + width - 1;
        int h = height - 1;
        if (width <= 0 || height <= 0) {
            return;
        }
        int i = 0;
        while (i <= h) {
            int yy = i + y;
            if (i == 0 || i == h) {
                if (this.CLIPY1 <= yy && yy < this.CLIPY2) {
                    int j = x;
                    while (j < x2) {
                        if (this.CLIPX1 <= j && j < this.CLIPX2) {
                            this.invPixelNOCT(j, yy);
                        }
                        j += 2;
                    }
                }
            } else if ((i & 1) != 0 && this.CLIPY1 <= yy && yy < this.CLIPY2) {
                if (this.CLIPX1 <= x && x < this.CLIPX2) {
                    this.invPixelNOCT(x, yy);
                }
                if (this.CLIPX1 <= x2 && x2 < this.CLIPX2) {
                    this.invPixelNOCT(x2, yy);
                }
            }
            ++i;
        }
    }

    private void drawDottedLine(int Ax, int Ay, int Bx, int By, int c1, int c2) {
        boolean on = true;
        int dX = Math.abs(Bx - Ax);
        int dY = Math.abs(By - Ay);
        int CurrentX = Ax;
        int CurrentY = Ay;
        int Xincr = Ax > Bx ? -1 : 1;
        int Yincr = Ay > By ? -1 : 1;
        if (dX >= dY) {
            int dPr = dY << 1;
            int dPru = dPr - (dX << 1);
            int P = dPr - dX;
            while (dX >= 0) {
                this.setPixel(CurrentX, CurrentY, on ? c1 : c2);
                on ^= true;
                CurrentX += Xincr;
                if (P > 0) {
                    CurrentY += Yincr;
                    P += dPru;
                } else {
                    P += dPr;
                }
                --dX;
            }
        } else {
            int dPr = dX << 1;
            int dPru = dPr - (dY << 1);
            int P = dPr - dY;
            while (dY >= 0) {
                this.setPixel(CurrentX, CurrentY, on ? c1 : c2);
                on ^= true;
                CurrentY += Yincr;
                if (P > 0) {
                    CurrentX += Xincr;
                    P += dPru;
                } else {
                    P += dPr;
                }
                --dY;
            }
        }
    }

    public void drawDottedRect(int x, int y, int w, int h) {
        int c1 = this.foreColor;
        int c2 = this.backColor;
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        if (w <= 0 || h <= 0) {
            return;
        }
        this.drawDottedLine(x, y, x2, y, c1, c2);
        this.drawDottedLine(x, y, x, y2, c1, c2);
        this.drawDottedLine(x2, y, x2, y2, c1, c2);
        this.drawDottedLine(x, y2, x2, y2, c1, c2);
    }

    public void drawEllipse(int xc, int yc, int rx, int ry) {
        this.ellipseDrawAndFill(xc, yc, rx, ry, this.foreColor, false);
    }

    public void drawEllipticalArc(int xc, int yc, int rx, int ry, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, rx, ry, startAngle, endAngle, this.foreColor, 0, false, false);
    }

    public void drawEllipticalPie(int xc, int yc, int rx, int ry, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, rx, ry, startAngle, endAngle, this.foreColor, 0, false, true);
    }

    private void drawHLine(int x, int y, int w, int color) {
        if (this.CLIPY1 <= (y += this.TRANSY) && y < this.CLIPY2 && this.CLIPX1 <= (x += this.TRANSX) + w && x < this.CLIPX2) {
            if (x < this.CLIPX1) {
                w -= this.CLIPX1 - x;
                x = this.CLIPX1;
            }
            if (x + w > this.CLIPX2) {
                w = this.CLIPX2 - x;
            }
            if (x < 0 || y < 0 || w < 0) {
                this.badParam("drawHLine(" + x + ',' + y + ',' + w + ')');
            }
            if (this.isntImage) {
                JavaBridge.GraphicsLine(this.surface, x, y, x + w - 1, y, color);
            }
            int[] pix = this.pixels[y];
            while (w-- > 0) {
                pix[x++] = color;
            }
        }
    }

    private void drawHLineNOCT(int x, int y, int w, int color) {
        if (x < 0 || y < 0 || w < 0) {
            this.badParam("drawHLineNOCT(" + x + ',' + y + ',' + w + ')');
        }
        if (this.isntImage) {
            JavaBridge.GraphicsLine(this.surface, x, y, x + w - 1, y, color);
        }
        int[] pix = this.pixels[y];
        while (w-- > 0) {
            pix[x++] = color;
        }
    }

    public void drawHatchedRect(int x, int y, int width, int height, boolean top, boolean bottom) {
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        if (top && bottom) {
            this.drawLine(x, y + 2, x, y2 - 2, this.foreColor);
            this.drawLine(x + 2, y2, x2 - 2, y2, this.foreColor);
            this.drawLine(x2, y + 2, x2, y2 - 2, this.foreColor);
            this.drawLine(x + 2, y, x2 - 2, y, this.foreColor);
            this.setPixel(x + 1, y + 1, this.foreColor);
            this.setPixel(x2 - 1, y + 1, this.foreColor);
            this.setPixel(x + 1, y2 - 1, this.foreColor);
            this.setPixel(x2 - 1, y2 - 1, this.foreColor);
        } else if (top && !bottom) {
            this.drawLine(x, y + 2, x, y2, this.foreColor);
            this.drawLine(x, y2, x2, y2, this.foreColor);
            this.drawLine(x2, y + 2, x2, y2, this.foreColor);
            this.drawLine(x + 2, y, x2 - 2, y, this.foreColor);
            this.setPixel(x + 1, y + 1, this.foreColor);
            this.setPixel(x2 - 1, y + 1, this.foreColor);
        } else if (!top && bottom) {
            this.drawLine(x, y, x, y2 - 2, this.foreColor);
            this.drawLine(x + 2, y2, x2 - 2, y2, this.foreColor);
            this.drawLine(x2, y, x2, y2 - 2, this.foreColor);
            this.drawLine(x, y, x2, y, this.foreColor);
            this.setPixel(x + 1, y2 - 1, this.foreColor);
            this.setPixel(x2 - 1, y2 - 1, this.foreColor);
        }
    }

    public void drawHighLightFrame(int x, int y, int w, int h, Color topLeft, Color bottomRight, boolean yMirror) {
        int c;
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        if (topLeft != null) {
            c = topLeft.red << 16 | topLeft.green << 8 | topLeft.blue;
            this.drawLine(x, y, x, y2, c);
            if (!yMirror) {
                this.drawLine(x, y, x2, y, c);
            } else {
                this.drawLine(x, y2, x2, y2, c);
            }
        }
        if (bottomRight != null) {
            c = bottomRight.red << 16 | bottomRight.green << 8 | bottomRight.blue;
            this.drawLine(x2, y2, x2, y, c);
            if (!yMirror) {
                this.drawLine(x2, y2, x, y2, c);
            } else {
                this.drawLine(x2, y, x, y, c);
            }
        }
    }

    public void drawImage(Image image, int x, int y) {
        int w = image.width;
        int h = image.height;
        if (x > 50000) {
            if (x >= 106000 && x <= 114000) {
                x -= 110000;
            } else if (x >= 126000 && x <= 134000) {
                x = Settings.screenWidth - w + x - 130000;
            } else if (x >= 116000 && x <= 124000) {
                x = (Settings.screenWidth - w >> 1) + x - 120000;
            }
        }
        if (y > 50000) {
            if (y >= 136000 && y <= 144000) {
                y -= 140000;
            } else if (y >= 146000 && y <= 154000) {
                y = Settings.screenHeight - h + y - 150000;
            } else if (y >= 116000 && y <= 124000) {
                y = (Settings.screenHeight - h >> 1) + y - 120000;
            }
        }
        this.copyRect(image, 0, 0, w, h, x, y);
    }

    public void drawImage(Image image, int x, int y, int drawOp, Color backColor, boolean doClip) {
        int[][] srcPixels;
        int transpPixel = Graphics.getPalColor(Color.getColor(image.transparentPixel));
        if (backColor != null && drawOp != 0 && (transpPixel != lastColorValue || backColor != lastColor)) {
            lastColor = backColor;
            transpPixel = lastColorValue = Graphics.getPalColor(backColor);
        }
        if (transpPixel < 0) {
            transpPixel = lastColorValue;
        }
        if ((srcPixels = this.getPixels(image)) != null) {
            this.drawBitmap(srcPixels, 0, 0, image.width, image.height, x, y, drawOp, transpPixel, this.foreColor, doClip);
        }
    }

    public void drawLine(int Ax, int Ay, int Bx, int By) {
        this.drawLine(Ax, Ay, Bx, By, this.foreColor);
    }

    private void drawLine(int Ax, int Ay, int Bx, int By, int c) {
        int dX = Math.abs(Bx - Ax);
        int dY = Math.abs(By - Ay);
        int CurrentX = Ax;
        int CurrentY = Ay;
        if (dX == 0 && dY == 0) {
            this.setPixel(Ax, Ay, c);
        } else if (dY == 0) {
            this.drawHLine(Math.min(Ax, Bx), Math.min(Ay, By), dX + 1, c);
        } else if (dX == 0) {
            this.drawVLine(Math.min(Ax, Bx), Math.min(Ay, By), dY + 1, c);
        } else {
            int Xincr = Ax > Bx ? -1 : 1;
            int Yincr = Ay > By ? -1 : 1;
            if (dX >= dY) {
                int dPr = dY << 1;
                int dPru = dPr - (dX << 1);
                int P = dPr - dX;
                while (dX >= 0) {
                    this.setPixel(CurrentX, CurrentY, c);
                    CurrentX += Xincr;
                    if (P > 0) {
                        CurrentY += Yincr;
                        P += dPru;
                    } else {
                        P += dPr;
                    }
                    --dX;
                }
            } else {
                int dPr = dX << 1;
                int dPru = dPr - (dY << 1);
                int P = dPr - dY;
                while (dY >= 0) {
                    this.setPixel(CurrentX, CurrentY, c);
                    CurrentY += Yincr;
                    if (P > 0) {
                        CurrentX += Xincr;
                        P += dPru;
                    } else {
                        P += dPr;
                    }
                    --dY;
                }
            }
        }
    }

    public void drawPie(int xc, int yc, int r, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, r, r, startAngle, endAngle, this.foreColor, this.foreColor, false, true);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > xPoints.length || nPoints > yPoints.length) {
            Vm.warning("array index out of range: " + nPoints);
        } else {
            this.drawPolygon(xPoints, yPoints, nPoints, this.foreColor, true);
        }
    }

    private void drawPolygon(int[] xPoints, int[] yPoints, int nPoints, int c, boolean close) {
        if (nPoints < 2) {
            return;
        }
        if (xPoints == null || yPoints == null) {
            this.badParam("drawPolygon(" + xPoints + ',' + yPoints + ')');
        }
        int i = 1;
        while (i < nPoints) {
            this.drawLine(xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i], c);
            ++i;
        }
        if (close && (xPoints[0] != xPoints[--nPoints] || yPoints[0] != yPoints[nPoints])) {
            this.drawLine(xPoints[0], yPoints[0], xPoints[nPoints], yPoints[nPoints], c);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > xPoints.length || nPoints > yPoints.length) {
            Vm.warning("array index out of range: " + nPoints);
        } else {
            this.drawPolygon(xPoints, yPoints, nPoints, this.foreColor, false);
        }
    }

    public void drawRect(int x, int y, int w, int h) {
        this.drawHLine(x, y, w, this.foreColor);
        this.drawHLine(x, y + h - 1, w, this.foreColor);
        this.drawVLine(x, y, h, this.foreColor);
        this.drawVLine(x + w - 1, y, h, this.foreColor);
    }

    public void drawRoundRect(int x, int y, int width, int height, int r) {
        if (r > width >> 1 || r > height >> 1) {
            r = Math.min(width >> 1, height >> 1);
        }
        int w = width - (r << 1);
        int h = height - (r << 1);
        int x1 = x + r;
        int y1 = y + r;
        int x2 = x + width - r - 1;
        int y2 = y + height - r - 1;
        int dec = 3 - (r << 1);
        int c = this.foreColor;
        this.drawHLine(x + r, y, w, c);
        this.drawHLine(x + r, y + height - 1, w, c);
        this.drawVLine(x, y + r, h, c);
        this.drawVLine(x + width - 1, y + r, h, c);
        int xx = 0;
        int yy = r;
        while (xx <= yy) {
            this.setPixel(x2 + xx, y2 + yy, c);
            this.setPixel(x2 + xx, y1 - yy, c);
            this.setPixel(x1 - xx, y2 + yy, c);
            this.setPixel(x1 - xx, y1 - yy, c);
            this.setPixel(x2 + yy, y2 + xx, c);
            this.setPixel(x2 + yy, y1 - xx, c);
            this.setPixel(x1 - yy, y2 + xx, c);
            this.setPixel(x1 - yy, y1 - xx, c);
            if (dec >= 0) {
                dec += -4 * yy-- + 4;
            }
            dec += 4 * xx + 6;
            ++xx;
        }
    }

    private synchronized void drawScanLine(int[] pixels, int x, int dstX, int dstY, int width) {
        if (pixels == null || x < 0 || dstX < 0 || dstY < 0 || width <= 0) {
            this.badParam("drawScanLine(" + pixels + ',' + x + ',' + dstX + ',' + dstY + ',' + width + ')');
        }
        if (!this.isntImage) {
            Vm.copyArray(pixels, x, this.pixels[dstY], dstX, width);
        } else {
            int lastColor = pixels[x];
            int lastI = 0;
            int i = 1;
            while (i < width) {
                if (pixels[x + i] != lastColor) {
                    this.drawHLineNOCT(dstX + lastI, dstY, i - lastI, lastColor);
                    lastI = i;
                    lastColor = pixels[x + i];
                }
                ++i;
            }
            this.drawHLineNOCT(dstX + lastI, dstY, i - lastI, lastColor);
        }
    }

    public void drawText(String text, int x, int y) {
        int height;
        int chrCount;
        if (text == null || (chrCount = text.length()) == 0) {
            return;
        }
        int[] ands8 = ands8Mask;
        UserFont font = JavaBridge.getFont(this.font);
        UserFont.CharBits bits = charBits.setFrom(font);
        int h = height = (int)font.fRectHeight;
        int chrStart = 0;
        while (chrCount-- > 0) {
            char ch;
            if ((ch = text.charAt(chrStart++)) == '\r' || ch == '\n') continue;
            font.setCharBits(ch, bits);
            if (bits.width == 0) {
                x += font.maxWidth >> 1;
                continue;
            }
            int rowWIB = bits.rowWIB;
            byte[] bitmapTable = bits.charBitmapTable;
            int width = bits.width;
            int start = bits.offset >> 3;
            int startBit = bits.offset & 7;
            h = height;
            while (h-- > 0) {
                int current = start;
                int currentBit = startBit;
                int w = width;
                while (w-- > 0) {
                    if ((bitmapTable[current] & ands8[currentBit]) != 0) {
                        this.setPixel(x, y, this.foreColor);
                    }
                    if (++currentBit == 8) {
                        currentBit = 0;
                        ++current;
                    }
                    ++x;
                }
                x -= width;
                ++y;
                start += rowWIB;
            }
            x += width;
            y -= height;
        }
    }

    public void drawText(char[] chars, int chrStart, int chrCount, int x, int y) {
        this.drawText(new String(chars, chrStart, chrCount), x, y);
    }

    private void drawVLine(int x, int y, int h, int color) {
        if (this.CLIPX1 <= (x += this.TRANSX) && x < this.CLIPX2 && this.CLIPY1 <= (y += this.TRANSY) + h && y < this.CLIPY2) {
            if (y < this.CLIPY1) {
                h -= this.CLIPY1 - y;
                y = this.CLIPY1;
            }
            if (y + h > this.CLIPY2) {
                h = this.CLIPY2 - y;
            }
            if (x < 0 || y < 0 || h < 0) {
                this.badParam("drawVLine(" + x + ',' + y + ',' + h + ')');
            }
            if (this.isntImage) {
                JavaBridge.GraphicsLine(this.surface, x, y, x, y + h - 1, color);
            }
            while (h-- > 0) {
                this.pixels[y++][x] = color;
            }
        }
    }

    public void drawVistaRect(int x, int y, int width, int height, Color top, Color right, Color bottom, Color left) {
        int x1 = x + 1;
        int y1 = y + 1;
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        this.setForeColor(top);
        this.drawLine(x1, y, x2 - 1, y);
        this.setForeColor(right);
        this.drawLine(x2, y1, x2, y2 - 1);
        this.setForeColor(bottom);
        this.drawLine(x1, y2, x2 - 1, y2);
        this.setForeColor(left);
        this.drawLine(x, y1, x, y2 - 1);
    }

    /*
     * Unable to fully structure code
     */
    private void ellipseDrawAndFill(int xc, int yc, int rx, int ry, int c, boolean fill) {
        t1 = rx * rx;
        t2 = t1 << 1;
        t3 = t2 << 1;
        t4 = ry * ry;
        t5 = t4 << 1;
        t6 = t5 << 1;
        t7 = rx * t5;
        t8 = t7 << 1;
        t9 = 0;
        d1 = t2 - t7 + (t4 >> 1);
        d2 = (t1 >> 1) - t8 + t5;
        x = rx;
        y = 0;
        if (rx >= 0 && ry >= 0) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            if (fill) {
                this.quadLine(xc, yc, x, y, c);
            } else {
                this.quadPixel(xc, yc, x, y, c);
            }
            ++y;
            t9 += t3;
            if (d1 < 0) {
                d1 += t9 + t2;
                d2 += t9;
                continue;
            }
            --x;
            d1 += t9 + t2 - (t8 -= t6);
            d2 += t9 + t5 - t8;
lbl29:
            // 3 sources

            ** while (d2 < 0)
        }
lbl30:
        // 1 sources

        do {
            if (fill) {
                this.quadLine(xc, yc, x, y, c);
            } else {
                this.quadPixel(xc, yc, x, y, c);
            }
            --x;
            t8 -= t6;
            if (d2 < 0) {
                ++y;
                d2 += (t9 += t3) + t5 - t8;
                continue;
            }
            d2 += t5 - t8;
        } while (x >= 0);
    }

    public void eraseRect(int x, int y, int w, int h) {
        int[] xywh = new int[]{x, y, w, h};
        if (this.translateAndClip(xywh)) {
            x = xywh[0];
            y = xywh[1];
            w = xywh[2];
            h = xywh[3];
            int x2 = x + w;
            int xx = x;
            while (xx < x2) {
                this.eraseVLineNOCT(xx, y, h, this.foreColor, this.backColor);
                ++xx;
            }
        }
    }

    private void eraseVLineNOCT(int x, int y, int h, int cfrom, int cto) {
        if (x < 0 || y < 0 || h < 0) {
            this.badParam("eraseVLineNOCT(" + x + ',' + y + ',' + h + ')');
        }
        while (h-- > 0) {
            if (this.pixels[y][x] == cfrom) {
                this.setPixelNOCT(x, y, cto);
            }
            ++y;
        }
    }

    public void fill3dRect(int x, int y, int width, int height, Color back, boolean invert, boolean rotate) {
        Color[] vistaColors = Graphics.getVistaColors(back);
        int dim = rotate ? width : height;
        int y0 = rotate ? x : y;
        float incY = (float)dim / 10.0f;
        int lineH = (int)(incY + 1.0f);
        float lineY = 0.0f;
        int hh = rotate ? x + dim : y + dim;
        int c = 0;
        while (lineY < (float)dim) {
            this.setBackColor(vistaColors[invert ? 10 - c : c]);
            int yy = y0 + (int)lineY;
            int k = hh - yy;
            if (!rotate) {
                this.fillRect(x, yy, width, k < lineH ? k : lineH);
            } else {
                this.fillRect(yy, y, k < lineH ? k : lineH, height);
            }
            ++c;
            lineY += incY;
        }
    }

    public void fillCircle(int xc, int yc, int r) {
        this.ellipseDrawAndFill(xc, yc, r, r, this.backColor, true);
    }

    public void fillEllipse(int xc, int yc, int rx, int ry) {
        this.ellipseDrawAndFill(xc, yc, rx, ry, this.backColor, true);
    }

    public void fillEllipticalPie(int xc, int yc, int rx, int ry, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, rx, ry, startAngle, endAngle, this.foreColor, this.backColor, true, true);
    }

    public void fillHatchedRect(int x, int y, int width, int height, boolean top, boolean bottom) {
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        if (top && bottom) {
            this.fillRect(x, y + 2, width, height - 4);
            this.drawLine(x + 2, y, x2 - 2, y, this.backColor);
            this.drawLine(x + 1, y + 1, x2 - 1, y + 1, this.backColor);
            this.drawLine(x + 1, y2 - 1, x2 - 1, y2 - 1, this.backColor);
            this.drawLine(x + 2, y2, x2 - 2, y2, this.backColor);
        } else if (top && !bottom) {
            this.drawLine(x + 2, y, x2 - 2, y, this.backColor);
            this.drawLine(x + 1, y + 1, x2 - 1, y + 1, this.backColor);
            this.fillRect(x, y + 2, width, height - 2);
        } else if (!top && bottom) {
            this.fillRect(x, y, width, height - 2);
            this.drawLine(x + 1, y2 - 1, x2 - 1, y2 - 1, this.backColor);
            this.drawLine(x + 2, y2, x2 - 2, y2, this.backColor);
        }
    }

    public void fillPie(int xc, int yc, int r, float startAngle, float endAngle) {
        this.preArcPiePointDrawAndFill(xc, yc, r, r, startAngle, endAngle, this.foreColor, this.backColor, true, true);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > xPoints.length || nPoints > yPoints.length) {
            Vm.warning("array index out of range: " + nPoints);
        } else {
            this.fillPolygon(xPoints, yPoints, nPoints, this.backColor);
        }
    }

    private void fillPolygon(int[] xPoints, int[] yPoints, int nPoints, int c) {
        if (xPoints == null || yPoints == null || nPoints <= 0) {
            this.badParam("fillPolygon(" + xPoints + ',' + yPoints + ',' + nPoints + ')');
        }
        IntVector ints = new IntVector(10);
        if (nPoints < 2) {
            return;
        }
        int miny = yPoints[0];
        int maxy = yPoints[0];
        int i = 1;
        while (i < nPoints) {
            if (yPoints[i] < miny) {
                miny = yPoints[i];
            }
            if (yPoints[i] > maxy) {
                maxy = yPoints[i];
            }
            ++i;
        }
        int y = miny;
        while (y <= maxy) {
            ints.removeAllElements();
            int i2 = 0;
            while (i2 < nPoints) {
                block17: {
                    int x2;
                    int x1;
                    int y2;
                    int y1;
                    block16: {
                        int ind2;
                        int ind1;
                        block15: {
                            if (i2 == 0) {
                                ind1 = nPoints - 1;
                                ind2 = 0;
                            } else {
                                ind1 = i2 - 1;
                                ind2 = i2;
                            }
                            y1 = yPoints[ind1];
                            y2 = yPoints[ind2];
                            if (y1 >= y2) break block15;
                            x1 = xPoints[ind1];
                            x2 = xPoints[ind2];
                            break block16;
                        }
                        if (y1 <= y2) break block17;
                        y2 = yPoints[ind1];
                        y1 = yPoints[ind2];
                        x2 = xPoints[ind1];
                        x1 = xPoints[ind2];
                    }
                    if (y1 <= y && y < y2 || y == maxy && y1 < y && y <= y2) {
                        ints.addElement((y - y1) * (x2 - x1) / (y2 - y1) + x1);
                    }
                }
                ++i2;
            }
            int n = ints.size();
            if (n > 0) {
                ints.qsort();
                int i3 = 0;
                while (i3 < n) {
                    this.drawHLine(ints.items[i3], y, ints.items[i3 + 1] - ints.items[i3] + 1, c);
                    i3 += 2;
                }
            }
            ++y;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void fillRect(int x, int y, int w, int h) {
        block1: {
            if (h <= 10000 && h >= 0 && w >= 0) ** GOTO lbl6
            this.badParam("fillRect(" + x + ',' + y + ',' + w + ',' + h + ')');
            break block1;
lbl-1000:
            // 1 sources

            {
                this.drawHLine(x, y++, w, this.backColor);
                --h;
lbl6:
                // 2 sources

                ** while (h > 0)
            }
        }
    }

    public void fillRoundRect(int x, int y, int width, int height, int r) {
        if (r > width >> 1 || r > height >> 1) {
            r = Math.min(width >> 1, height >> 1);
        }
        int x1 = x + r;
        int y1 = y + r;
        int x2 = x + width - r - 1;
        int y2 = y + height - r - 1;
        int dec = 3 - (r << 1);
        int c = this.backColor;
        height -= r << 1;
        y += r;
        while (height-- > 0) {
            this.drawHLine(x, y++, width, c);
        }
        int xx = 0;
        int yy = r;
        while (xx <= yy) {
            this.drawLine(x1 - xx, y1 - yy, x2 + xx, y1 - yy, c);
            this.drawLine(x1 - xx, y2 + yy, x2 + xx, y2 + yy, c);
            this.drawLine(x1 - yy, y1 - xx, x2 + yy, y1 - xx, c);
            this.drawLine(x1 - yy, y2 + xx, x2 + yy, y2 + xx, c);
            if (dec >= 0) {
                dec += -4 * yy-- + 4;
            }
            dec += 4 * xx + 6;
            ++xx;
        }
    }

    public void free() {
    }

    public Coord getAnglePoint(int xc, int yc, int rx, int ry, float angle) {
        int[] twoInts = new int[2];
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        this.arcPiePointDrawAndFill(xc, yc, rx, ry, angle, angle, 0, 0, false, false, twoInts);
        return new Coord(twoInts[0], twoInts[1]);
    }

    public Rect getClip(Rect r) {
        r.x = this.CLIPX1 - this.TRANSX;
        r.y = this.CLIPY1 - this.TRANSY;
        r.width = this.CLIPX2 - this.CLIPX1;
        r.height = this.CLIPY2 - this.CLIPY1;
        return r;
    }

    public Font getFont() {
        return this.lastFont;
    }

    private static int getPalColor(int r, int g, int b) {
        return Graphics.getPalColor(Color.getColor(r, g, b));
    }

    private static int getPalColor(Color c) {
        return ScreenPalette == null ? c.rgb : Graphics.ScreenPalette.getColor((int)Graphics.ScreenPalette.getColorIndex((Color)c)).rgb;
    }

    public int getPixel(int x, int y) {
        if (this.CLIPX1 <= (x += this.TRANSX) && x < this.CLIPX2 && this.CLIPY1 <= (y += this.TRANSY) && y < this.CLIPY2) {
            return this.pixels[y][x];
        }
        return -1;
    }

    private int getPixelNOCT(int x, int y) {
        if (x < 0 || y < 0) {
            this.badParam("getPixelNOCT(" + x + ',' + y + ')');
        }
        return this.pixels[y][x];
    }

    private int[][] getPixels(ISurface surface) {
        if (surface == null) {
            this.badParam("getPixels(null)");
            return null;
        }
        if (surface instanceof Image) {
            return ((Image)surface).pixels;
        }
        if (!(surface instanceof Applet) && surface instanceof Window && Applet.mainG == null) {
            return new int[Settings.screenHeight][Settings.screenWidth];
        }
        return Applet.mainG.pixels;
    }

    public Coord getTranslation() {
        return new Coord(this.TRANSX, this.TRANSY);
    }

    public static Color[] getVistaColors(Color c) {
        Color[] vistaColors = null;
        try {
            vistaColors = (Color[])htVistaColors.get(c);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (vistaColors == null) {
            int step = Settings.isHighColor ? 8 : 5;
            vistaColors = new Color[11];
            htVistaColors.put(c, vistaColors);
            int p = 0;
            while (p <= 10) {
                vistaColors[p] = c;
                c = c.darker(p == 4 ? step + step : step);
                ++p;
            }
        }
        return vistaColors;
    }

    private Rect intersection(Rect r1, Rect r2) {
        int x1 = Math.max(r1.x, r2.x);
        int x2 = Math.min(r1.x + r1.width, r2.x + r2.width);
        int y1 = Math.max(r1.y, r2.y);
        int y2 = Math.min(r1.y + r1.height, r2.y + r2.height);
        return new Rect(x1, y1, x2 - x1, y2 - y1);
    }

    private boolean intersects(Rect r1, Rect r2) {
        return (r1.x + r1.width <= r2.x || r1.y + r1.height <= r2.y || r1.x >= r2.x + r2.width || r1.y >= r2.y + r2.height) ^ true;
    }

    private boolean intersectsClipRect(int x1, int y1, int x2, int y2) {
        return (x2 <= this.CLIPX1 || y2 <= this.CLIPY1 || x1 >= this.CLIPX2 || y1 >= this.CLIPY2) ^ true;
    }

    private void invPixelNOCT(int x, int y) {
        if (x < 0 || y < 0) {
            this.badParam("invPixelNOCT(" + x + ',' + y + ')');
        }
        this.setPixelNOCT(x, y, this.pixels[y][x] ^ 0xFFFFFF);
    }

    private void invVLineNOCT(int x, int y, int h) {
        if (x < 0 || y < 0 || h < 0) {
            this.badParam("invVLineNOCT(" + x + ',' + y + ',' + h + ')');
        }
        while (h-- > 0) {
            this.setPixelNOCT(x, y, this.pixels[y][x] ^ 0xFFFFFF);
            ++y;
        }
    }

    private void preArcPiePointDrawAndFill(int xc, int yc, int rx, int ry, float startAngle, float endAngle, int c, int c2, boolean fill, boolean pie) {
        while (startAngle <= -360.0f) {
            startAngle += 360.0f;
        }
        while (endAngle <= -360.0f) {
            endAngle += 360.0f;
        }
        while (startAngle > 360.0f) {
            startAngle -= 360.0f;
        }
        while (endAngle > 360.0f) {
            endAngle -= 360.0f;
        }
        if (startAngle == endAngle) {
            return;
        }
        if (startAngle > endAngle) {
            startAngle -= 360.0f;
        }
        if (startAngle >= 0.0f && endAngle <= 0.0f) {
            endAngle += 360.0f;
        }
        if (startAngle >= 0.0f && endAngle >= 0.0f) {
            this.arcPiePointDrawAndFill(xc, yc, rx, ry, startAngle, endAngle, c, c2, fill, pie, null);
        } else if (startAngle <= 0.0f && endAngle >= 0.0f) {
            this.arcPiePointDrawAndFill(xc, yc, rx, ry, startAngle += 360.0f, 360.0f, c, c2, fill, pie, null);
            this.arcPiePointDrawAndFill(xc, yc, rx, ry, 0.0f, endAngle, c, c2, fill, pie, null);
        } else {
            this.badParam("preArcPiePointDrawAndFill(" + xc + ',' + yc + ',' + rx + ',' + ry + ',' + startAngle + ',' + endAngle + ')');
        }
    }

    private void quadLine(int xc, int yc, int x, int y, int c) {
        int w = x + x + 1;
        this.drawHLine(xc - x, yc - y, w, c);
        this.drawHLine(xc - x, yc + y, w, c);
    }

    private void quadPixel(int xc, int yc, int x, int y, int c) {
        this.setPixel(xc + x, yc + y, c);
        this.setPixel(xc + x, yc - y, c);
        this.setPixel(xc - x, yc + y, c);
        this.setPixel(xc - x, yc - y, c);
    }

    public void setBackColor(int r, int g, int b) {
        this.backColor = Graphics.getPalColor(r, g, b);
    }

    public void setBackColor(Color c) {
        this.backColor = Graphics.getPalColor(c);
    }

    public void setClip(int x, int y, int w, int h) {
        int clipX1 = x + this.TRANSX;
        int clipY1 = y + this.TRANSY;
        int clipX2 = clipX1 + w;
        int clipY2 = clipY1 + h;
        if (clipX1 < 0) {
            clipX1 = 0;
        }
        if (clipY1 < 0) {
            clipY1 = 0;
        }
        if (clipX1 > this.maxX) {
            clipX1 = this.maxX;
        }
        if (clipY1 > this.maxY) {
            clipY1 = this.maxY;
        }
        if (clipX2 < 0) {
            clipX2 = 0;
        }
        if (clipY2 < 0) {
            clipY2 = 0;
        }
        if (clipX2 > this.maxX) {
            clipX2 = this.maxX;
        }
        if (clipY2 > this.maxY) {
            clipY2 = this.maxY;
        }
        this.CLIPX1 = clipX1;
        this.CLIPY1 = clipY1;
        this.CLIPX2 = clipX2;
        this.CLIPY2 = clipY2;
    }

    public void setClip(Rect r) {
        this.setClip(r.x, r.y, r.width, r.height);
    }

    public void setColors(Color c) {
        this.setBackColor(c);
        this.setForeColor(c);
    }

    public void setDrawOp(int drawOp) {
        this.drawOp = drawOp;
    }

    public void setFont(Font font) {
        if (font == null) {
            this.badParam("setFont(null)");
        }
        this.lastFont = this.font = font;
    }

    public void setForeColor(int r, int g, int b) {
        this.foreColor = Graphics.getPalColor(r, g, b);
    }

    public void setForeColor(Color c) {
        this.foreColor = Graphics.getPalColor(c);
    }

    public void setPixel(int x, int y) {
        this.setPixel(x, y, this.foreColor);
    }

    private void setPixel(int x, int y, int color) {
        if (this.CLIPX1 <= (x += this.TRANSX) && x < this.CLIPX2 && this.CLIPY1 <= (y += this.TRANSY) && y < this.CLIPY2) {
            if (x < 0 || y < 0) {
                this.badParam("setPixel(" + x + ',' + y + ')');
            }
            if (this.isntImage) {
                JavaBridge.GraphicsLine(this.surface, x, y, x, y, color);
            }
            this.pixels[y][x] = color;
        }
    }

    private void setPixelNOCT(int x, int y, int color) {
        if (x < 0 || y < 0) {
            this.badParam("setPixelNOCT(" + x + ',' + y + ')');
        }
        if (this.isntImage) {
            JavaBridge.GraphicsLine(this.surface, x, y, x, y, color);
        }
        this.pixels[y][x] = color;
    }

    public String toString() {
        Rect r = new Rect();
        this.getClip(r);
        return String.valueOf(super.toString()) + ", Clip:" + r + ", translation from origin: " + this.getTranslation();
    }

    public void translate(int dx, int dy) {
        this.TRANSX += dx;
        this.TRANSY += dy;
    }

    private boolean translateAndClip(int[] xywh) {
        int x = xywh[0];
        int y = xywh[1];
        int width = xywh[2];
        int height = xywh[3];
        if (!this.intersectsClipRect(x += this.TRANSX, y += this.TRANSY, x + width, y + height)) {
            return false;
        }
        if (x < this.CLIPX1) {
            width -= this.CLIPX1 - x;
            x = this.CLIPX1;
        }
        if (y < this.CLIPY1) {
            height -= this.CLIPY1 - y;
            y = this.CLIPY1;
        }
        if (x + width > this.CLIPX2) {
            width = this.CLIPX2 - x;
        }
        if (y + height > this.CLIPY2) {
            height = this.CLIPY2 - y;
        }
        if (width <= 0 || height <= 0) {
            return false;
        }
        xywh[0] = x;
        xywh[1] = y;
        xywh[2] = width;
        xywh[3] = height;
        return true;
    }

    public void translateTo(int x, int y) {
        Coord c = this.getTranslation();
        if (c.x != 0 || c.y != 0) {
            this.translate(-c.x, -c.y);
        }
        if (x != 0 || y != 0) {
            this.translate(x, y);
        }
    }
}

