/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Color;
import waba.fx.NativeMethods4JDK;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.util.ElementNotFoundError;
import waba.util.IntHashtable;

public final class Palette {
    public static final int[] default16PaletteScr2Dev;
    public static final int[] default16PaletteDev2Scr;
    public static final int[] default4PaletteScr2Dev;
    public static final int[] default4PaletteDev2Scr;
    private Color[] colors;
    private IntHashtable ihMatchedColors;
    private int maxIndex;
    public static final Palette SystemPalette;

    static {
        int[] nArray = new int[16];
        nArray[0] = 0xFFFFFF;
        nArray[1] = 0xEEEEEE;
        nArray[2] = 0xDDDDDD;
        nArray[3] = 0xCCCCCC;
        nArray[4] = 0xBBBBBB;
        nArray[5] = 0xAAAAAA;
        nArray[6] = 0x999999;
        nArray[7] = 0x888888;
        nArray[8] = 0x777777;
        nArray[9] = 0x666666;
        nArray[10] = 0x555555;
        nArray[11] = 0x444444;
        nArray[12] = 0x333333;
        nArray[13] = 0x222222;
        nArray[14] = 0x111111;
        default16PaletteScr2Dev = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 0x111111;
        nArray2[2] = 0x222222;
        nArray2[3] = 0x333333;
        nArray2[4] = 0x444444;
        nArray2[5] = 0x555555;
        nArray2[6] = 0x666666;
        nArray2[7] = 0x777777;
        nArray2[8] = 0x888888;
        nArray2[9] = 0x999999;
        nArray2[10] = 0xAAAAAA;
        nArray2[11] = 0xBBBBBB;
        nArray2[12] = 0xCCCCCC;
        nArray2[13] = 0xDDDDDD;
        nArray2[14] = 0xEEEEEE;
        nArray2[15] = 0xFFFFFF;
        default16PaletteDev2Scr = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 0xFFFFFF;
        nArray3[1] = 0xBFBFBF;
        nArray3[2] = 0x7F7F7F;
        default4PaletteScr2Dev = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 0x7F7F7F;
        nArray4[2] = 0xBFBFBF;
        nArray4[3] = 0xFFFFFF;
        default4PaletteDev2Scr = nArray4;
        SystemPalette = new Palette();
    }

    public Palette() {
        this(Settings.maxColors);
    }

    public Palette(int maxColors) {
        this.setColors(maxColors == 16 ? default16PaletteDev2Scr : (maxColors == 4 ? default4PaletteDev2Scr : NativeMethods4JDK.paletteGetCurrentPalette(this)));
        this.maxIndex = this.colors.length - 1;
    }

    public Palette(int[] colorRGBs) {
        this.setColors(colorRGBs);
        this.maxIndex = this.colors.length - 1;
    }

    public Palette(Color[] colors) {
        if (colors == null || colors.length > 256) {
            this.setColors(NativeMethods4JDK.paletteGetCurrentPalette(this));
        } else {
            this.colors = colors;
        }
        this.maxIndex = this.colors.length - 1;
    }

    public int find(Color color) {
        int rgb = color.rgb;
        int n = this.colors.length;
        int i = 0;
        while (i < n) {
            if (this.colors[i].rgb == rgb) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findNearest(Color color) {
        int nc = 0;
        int sdist = 16581376;
        int r = color.red;
        int g = color.green;
        int b = color.blue;
        int n = this.colors.length;
        int i = 0;
        while (i < n) {
            Color c = this.colors[i];
            int dist = (r - c.red) * (r - c.red) + (g - c.green) * (g - c.green) + (b - c.blue) * (b - c.blue);
            if (dist < sdist) {
                nc = i;
                sdist = dist;
            }
            ++i;
        }
        return nc;
    }

    public Color getColor(int index) {
        return this.colors[index < 0 ? 0 : (index > this.maxIndex ? this.maxIndex : index)];
    }

    public int getColorIndex(Color color) {
        int b;
        if (this.ihMatchedColors == null) {
            this.ihMatchedColors = new IntHashtable(this.colors.length * 3 / 2);
        }
        int key = color.equ;
        try {
            b = this.ihMatchedColors.get(key);
        }
        catch (ElementNotFoundError elementNotFoundError) {
            b = IntHashtable.INVALID;
        }
        if (b == IntHashtable.INVALID) {
            if (Settings.isColor) {
                b = this.find(color);
                if (b == -1) {
                    b = this.findNearest(color);
                }
            } else {
                b = Settings.maxColors - 1 - color.equ;
            }
            this.ihMatchedColors.put(key, b);
        }
        return b;
    }

    public Color[] getColors() {
        Color[] cs = new Color[this.colors.length];
        Vm.copyArray(this.colors, 0, cs, 0, this.colors.length);
        return cs;
    }

    public static int[] getDeviceRGBs() {
        return Settings.maxColors >= 256 ? SystemPalette.toRGBArray(-1, -1) : (Settings.maxColors == 16 ? default16PaletteScr2Dev : default4PaletteScr2Dev);
    }

    public void setColor(int index, Color color) {
        if (index <= this.maxIndex) {
            if (this.ihMatchedColors != null) {
                try {
                    this.ihMatchedColors.remove(this.colors[index].equ);
                }
                catch (ElementNotFoundError elementNotFoundError) {}
            }
            this.colors[index] = color;
        }
    }

    private void setColors(int[] colorRGBs) {
        this.colors = new Color[colorRGBs.length];
        int n = this.colors.length;
        int i = 0;
        while (i < n) {
            this.colors[i] = Color.getColor(colorRGBs[i]);
            ++i;
        }
    }

    public void setColors(Color[] aColor, int toIndex) {
        if (this.ihMatchedColors != null) {
            int i = 0;
            while (i < aColor.length) {
                try {
                    this.ihMatchedColors.remove(this.colors[toIndex + i].equ);
                }
                catch (ElementNotFoundError elementNotFoundError) {}
                ++i;
            }
        }
        Vm.copyArray(aColor, 0, this.colors, toIndex, aColor.length);
    }

    public int size() {
        return this.colors.length;
    }

    public int[] toRGBArray(int startIndex, int endIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex < 0) {
            endIndex = this.maxIndex;
        }
        if (endIndex < startIndex) {
            return null;
        }
        int[] ai = new int[endIndex - startIndex + 1];
        int i = startIndex;
        int j = 0;
        while (i <= endIndex) {
            ai[j] = this.colors[i].rgb;
            ++i;
            ++j;
        }
        return ai;
    }
}

