/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Coord;
import waba.sys.Convert;

public class Rect {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rect() {
    }

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect(Coord topleft, Coord bottomright) {
        this.set(topleft.x, topleft.y, bottomright.x - topleft.x + 1, bottomright.y - topleft.y + 1);
    }

    public boolean contains(int xx, int yy) {
        return this.x <= xx && xx < this.x + this.width && this.y <= yy && yy < this.y + this.height;
    }

    public boolean equals(Object other) {
        if (other instanceof Rect) {
            Rect r = (Rect)other;
            return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return this.x << 24 | this.y << 16 | this.width << 8 | this.height;
    }

    public Rect intersectWith(Rect r) {
        int x1 = Math.max(this.x, r.x);
        int x2 = Math.min(this.x + this.width, r.x + r.width);
        int y1 = Math.max(this.y, r.y);
        int y2 = Math.min(this.y + this.height, r.y + r.height);
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        return this;
    }

    public boolean intersects(Rect r) {
        return (r.x + r.width <= this.x || r.y + r.height <= this.y || r.x >= this.x + this.width || r.y >= this.y + this.height) ^ true;
    }

    public Rect modifiedBy(int deltaX, int deltaY, int deltaW, int deltaH) {
        return new Rect(this.x + deltaX, this.y + deltaY, this.width + deltaW, this.height + deltaH);
    }

    public void modify(int deltaX, int deltaY, int deltaW, int deltaH) {
        this.x += deltaX;
        this.y += deltaY;
        this.width += deltaW;
        this.height += deltaH;
    }

    public void set(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void set(Rect r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public String toString() {
        return String.valueOf(Convert.toString(this.x)) + ',' + this.y + ',' + this.width + ',' + this.height;
    }

    public void translate(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public Rect unionWith(Rect r) {
        int x1 = Math.min(this.x, r.x);
        int x2 = Math.max(this.x + this.width, r.x + r.width);
        int y1 = Math.min(this.y, r.y);
        int y2 = Math.max(this.y + this.height, r.y + r.height);
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
        return this;
    }

    public int x2() {
        return this.x + this.width - 1;
    }

    public int y2() {
        return this.y + this.height - 1;
    }
}

