/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.IOError;
import waba.io.NativeMethods4JDK;
import waba.io.Stream;
import waba.sys.Settings;

public class Catalog
extends Stream {
    Object bag;
    int hvRecordPos;
    int hvRecordHandle;
    int hvRecordPtr;
    int hvRecordOffset;
    int hvRecordLength;
    boolean hvRecordChanged;
    boolean hvDoBackup;
    String name;
    public static final int READ_ONLY = 1;
    public static final int WRITE_ONLY = 2;
    public static final int READ_WRITE = 3;
    public static final int CREATE = 4;
    public static final int CREATE_EMPTY = 5;
    public static final int DB_ATTR_READ_ONLY = 2;
    public static final int DB_ATTR_APPINFODIRTY = 4;
    public static final int DB_ATTR_BACKUP = 8;
    public static final int DB_ATTR_OK_TO_INSTALL_NEWER = 16;
    public static final int DB_ATTR_RESET_AFTER_INSTALL = 32;
    public static final int DB_ATTR_COPY_PREVENTION = 64;
    public static final int DB_ATTR_STREAM = 128;
    public static final byte REC_RELEASE = -1;
    public static final byte REC_ATTR_DELETE = -128;
    public static final byte REC_ATTR_DIRTY = 64;
    public static final byte REC_ATTR_SECRET = 16;

    public Catalog() {
        NativeMethods4JDK.catalogCreate(this);
    }

    public Catalog(String name, int mode) {
        this.name = name;
        NativeMethods4JDK.catalogCreate(this, name, mode);
    }

    public int addRecord(int size) throws IOError {
        int ret = NativeMethods4JDK.catalogAddRecord(this, size);
        if (ret == -1 && Settings.useExceptions) {
            throw new IOError("addRecord failed for " + size + this.getReason());
        }
        return ret;
    }

    public int addRecord(int size, int pos) throws IOError {
        int ret = NativeMethods4JDK.catalogAddRecord(this, size, pos);
        if (ret == -1 && Settings.useExceptions) {
            throw new IOError("addRecord failed for " + size + "," + pos + this.getReason());
        }
        return ret;
    }

    public boolean close() {
        return NativeMethods4JDK.catalogClose(this);
    }

    public boolean delete() throws IOError {
        boolean ok = NativeMethods4JDK.catalogDelete(this);
        if (!ok && Settings.useExceptions) {
            throw new IOError("delete failed" + this.getReason());
        }
        return ok;
    }

    public boolean deleteRecord() throws IOError {
        boolean ok = NativeMethods4JDK.catalogDeleteRecord(this);
        if (!ok && Settings.useExceptions) {
            throw new IOError("deleteRecord failed" + this.getReason());
        }
        return ok;
    }

    public void finalize() {
    }

    public int getAttributes() {
        return NativeMethods4JDK.catalogGetAttributes(this);
    }

    public String getName() {
        return this.name;
    }

    private String getReason() {
        return !this.isOpen() ? ". Reason: the Catalog is closed" : ". Possible reasons: there are two instances of the same catalog, and one instance is blocking the other, or the record is not positioned (if applicable to this method).";
    }

    public byte getRecordAttributes(int recordPos) {
        return NativeMethods4JDK.catalogGetRecordAttributes(this, recordPos);
    }

    public int getRecordCount() {
        return NativeMethods4JDK.catalogGetRecordCount(this);
    }

    public int getRecordOffset() {
        return this.hvRecordOffset;
    }

    public int getRecordPos() {
        return NativeMethods4JDK.catalogGetRecordPos(this);
    }

    public int getRecordSize() throws IOError {
        int ret = NativeMethods4JDK.catalogGetRecordSize(this);
        if (ret == -1 && Settings.useExceptions) {
            throw new IOError("getRecordSize failed" + this.getReason());
        }
        return ret;
    }

    public int inspectRecord(byte[] buf, int recPosition) throws IOError {
        int ret = NativeMethods4JDK.catalogInspectRecord(this, buf, recPosition);
        if (ret == -1 && Settings.useExceptions) {
            throw new IOError("getRecordSize failed" + this.getReason());
        }
        return ret;
    }

    public boolean isOpen() {
        return NativeMethods4JDK.catalogIsOpen(this);
    }

    public static String[] listCatalogs() {
        return Catalog.listCatalogs(0, 0);
    }

    public static String[] listCatalogs(int creatorId, int type) {
        return NativeMethods4JDK.catalogListCatalogs(creatorId, type);
    }

    public int readBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.catalogReadBytes(this, buf, start, count);
    }

    public boolean rename(String newName) throws IOError {
        boolean ok = NativeMethods4JDK.catalogRename(this, newName);
        if (ok) {
            this.name = newName;
        } else if (Settings.useExceptions) {
            throw new IOError("rename to " + newName + " failed" + this.getReason());
        }
        return ok;
    }

    public boolean resizeRecord(int size) throws IOError {
        boolean ok = NativeMethods4JDK.catalogResizeRecord(this, size);
        if (!ok && Settings.useExceptions) {
            throw new IOError("resizeRecord failed for " + size + this.getReason());
        }
        return ok;
    }

    public void setAttributes(int i) {
        NativeMethods4JDK.catalogSetAttributes(this, i);
    }

    public void setRecordAttributes(int recordPos, byte attr) {
        NativeMethods4JDK.catalogSetRecordAttributes(this, recordPos, attr);
    }

    public boolean setRecordOffset(int ofs) {
        if (ofs == this.hvRecordOffset) {
            return true;
        }
        this.hvRecordOffset = 0;
        return this.skipBytes(ofs) == ofs;
    }

    public boolean setRecordPos(int pos) throws IOError {
        boolean ok = NativeMethods4JDK.catalogSetRecordPos(this, pos);
        if (!ok && Settings.useExceptions) {
            throw new IOError("Set record pos failed for " + pos + this.getReason());
        }
        return ok;
    }

    public int skipBytes(int count) {
        return NativeMethods4JDK.catalogSkipBytes(this, count);
    }

    public int writeBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.catalogWriteBytes(this, buf, start, count);
    }
}

