/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import waba.applet.JavaBridge;
import waba.io.ByteArrayStream;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.File;
import waba.io.SerialPort;
import waba.io.Socket;
import waba.sys.Convert;
import waba.sys.Time;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;
import waba.util.Vector;

public final class NativeMethods4JDK {
    private static String portDEFAULT;
    private static String portIRCOMM;
    private static String portSIR;
    private static String portUSB;
    public static int readTries;
    static Hashtable _sockets;
    static Hashtable _dbHash;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    static {
        readTries = 10;
        _sockets = new Hashtable(10);
        _dbHash = new Hashtable(10);
    }

    static int _readWriteBytes(Catalog obj, byte[] buf, int start, int count, boolean isRead) {
        byte[] rec = null;
        try {
            CatalogBag cb = NativeMethods4JDK.getCB(obj);
            if (cb._recordPos == -1 || start < 0 || count < 0 || count > buf.length) {
                return -1;
            }
            if (cb._mode == 1 && !isRead || cb._mode == 2 && isRead) {
                JavaBridge.print("Invalid operation at catalog for this mode");
                return -1;
            }
            if (cb._recordPos >= cb._records.size()) {
                JavaBridge.print("Record not correctly added. RecordPos: " + cb._recordPos + " but RecordCount: " + cb._records.size());
                return -1;
            }
            rec = (byte[])cb._records.items[cb._recordPos];
            if (obj.hvRecordOffset < 0 || obj.hvRecordOffset + count > rec.length) {
                return -1;
            }
            if (isRead) {
                System.arraycopy(rec, obj.hvRecordOffset, buf, start, count);
            } else {
                System.arraycopy(buf, start, rec, obj.hvRecordOffset, count);
                if (cb._attrs != null) {
                    NativeMethods4JDK.catalogSetRecordAttributes(obj, cb._recordPos, (byte)(NativeMethods4JDK.catalogGetRecordAttributes(obj, cb._recordPos) | 0x40));
                }
                ++cb.modificationNumber;
            }
            obj.hvRecordOffset += count;
        }
        catch (Exception ee) {
            System.out.println("Exception " + ee + " in _readWriteBytes: rec.length: " + (rec == null ? "null" : String.valueOf(rec.length)) + ", buf.length: " + buf.length + ", start: " + start + ", count: " + count + ", isRead? " + isRead);
            count = -1;
        }
        return count;
    }

    static int catalogAddRecord(Catalog obj, int size) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen) {
            return -1;
        }
        cb._recordPos = cb._records.size();
        cb._records.addElement(new byte[size]);
        cb._attrs.addElement(new Byte(64));
        obj.hvRecordOffset = 0;
        ++cb.modificationNumber;
        return cb._recordPos;
    }

    static int catalogAddRecord(Catalog obj, int size, int pos) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen || size < 0) {
            return -1;
        }
        if (pos > cb._records.size()) {
            JavaBridge.print("Trying to add a record at an invalid position (" + pos + " > db size + 1).");
            pos = cb._records.size();
        }
        try {
            cb._records.insertElementAt(new byte[size], pos);
            cb._attrs.insertElementAt(new Byte(64), pos);
            ++cb.modificationNumber;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
        cb._recordPos = pos;
        obj.hvRecordOffset = 0;
        return cb._recordPos;
    }

    static boolean catalogClose(Catalog obj) {
        return NativeMethods4JDK.catalogClose(NativeMethods4JDK.getCB(obj));
    }

    static boolean catalogClose(CatalogBag cb) {
        boolean ret = true;
        if (!cb._isOpen) {
            return false;
        }
        if (!(cb.deleted || cb.modificationNumber == cb.originalModificationNumber && cb.modificationNumber != 0)) {
            ret = NativeMethods4JDK.writeCB(cb);
        }
        cb._isOpen = false;
        cb._recordPos = -1;
        return ret;
    }

    static void catalogCreate(Catalog obj) {
        obj.bag = NativeMethods4JDK.createCB();
        NativeMethods4JDK.getCB(obj).doSetDate();
    }

    static void catalogCreate(Catalog obj, String name, int mode) {
        obj.bag = NativeMethods4JDK.createCB();
        CatalogBag cb = (CatalogBag)obj.bag;
        String[] st = Convert.tokenizeString(name, '.');
        if (st == null || st.length < 3) {
            JavaBridge.print("Invalid catalog name: " + name + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
            return;
        }
        cb._name = st.length == 3 ? st[0] : name.substring(0, name.length() - 10);
        cb._creator = st[st.length - 2];
        cb._type = st[st.length - 1];
        cb._mode = mode;
        byte[] bytes = JavaBridge.readBytes(NativeMethods4JDK.getFileName(cb));
        if (bytes == null) {
            if (mode != 4 && mode != 5) {
                return;
            }
            cb.doSetDate();
        } else {
            try {
                if (mode == 5) {
                    NativeMethods4JDK.removeCatalogFromDisk(cb);
                    cb.deleted = false;
                } else {
                    cb._records = cb.fromPDB(bytes, cb._creator, cb._type, cb._attrs);
                }
            }
            catch (Exception e) {
                JavaBridge.print("EXCEPTION OCCURED WITH '" + name + "' DATABASE");
                e.printStackTrace();
                return;
            }
        }
        _dbHash.put(NativeMethods4JDK.getHashName(cb), obj);
        cb._isOpen = true;
    }

    static boolean catalogDelete(Catalog obj) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen) {
            return false;
        }
        try {
            _dbHash.remove(NativeMethods4JDK.getHashName(cb));
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        cb._records.removeAllElements();
        cb._attrs.removeAllElements();
        cb._isOpen = false;
        cb._recordPos = -1;
        try {
            if (NativeMethods4JDK.removeCatalogFromDisk(cb) != null) {
                return true;
            }
            NativeMethods4JDK.writeCB(cb);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean catalogDeleteRecord(Catalog obj) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (cb._recordPos == -1) {
            return false;
        }
        cb._records.removeElementAt(cb._recordPos);
        cb._attrs.removeElementAt(cb._recordPos);
        cb._recordPos = -1;
        ++cb.modificationNumber;
        return true;
    }

    static int catalogGetAttributes(Catalog obj) {
        return NativeMethods4JDK.getCB((Catalog)obj).attributes;
    }

    static byte catalogGetRecordAttributes(Catalog obj, int recordPos) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (recordPos < 0 || cb._attrs == null || recordPos >= cb._attrs.size()) {
            return 0;
        }
        Byte b = (Byte)cb._attrs.items[recordPos];
        return b;
    }

    static int catalogGetRecordCount(Catalog obj) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen) {
            return -1;
        }
        return cb._records.size();
    }

    static int catalogGetRecordPos(Catalog obj) {
        return NativeMethods4JDK.getCB((Catalog)obj)._recordPos;
    }

    static int catalogGetRecordSize(Catalog obj) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (cb._recordPos == -1) {
            return -1;
        }
        byte[] rec = (byte[])cb._records.items[cb._recordPos];
        return rec.length;
    }

    static int catalogInspectRecord(Catalog obj, byte[] buf, int recPosition) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        byte[] rec = (byte[])cb._records.items[recPosition];
        int count = Math.min(buf.length, rec.length);
        System.arraycopy(rec, 0, buf, 0, count);
        return count;
    }

    static boolean catalogIsOpen(Catalog obj) {
        return NativeMethods4JDK.getCB((Catalog)obj)._isOpen;
    }

    static String[] catalogListCatalogs(int creatorIdWild, int typeWild) {
        String path;
        java.io.File f;
        String[] s;
        boolean includeVersion;
        boolean bl = includeVersion = creatorIdWild == -1;
        if (includeVersion) {
            creatorIdWild = 0;
        }
        Vector v = new Vector(_dbHash.getKeys().toObjectArray());
        if (creatorIdWild != 0 || typeWild != 0) {
            int i = v.size() - 1;
            while (i >= 0) {
                byte[] b = v.items[i].toString().getBytes();
                int l = b.length;
                int crtrI = NativeMethods4JDK.makeInt(b[l - 9], b[l - 8], b[l - 7], b[l - 6]);
                int typeI = NativeMethods4JDK.makeInt(b[l - 4], b[l - 3], b[l - 2], b[l - 1]);
                if (creatorIdWild != 0 && creatorIdWild != crtrI || typeWild != 0 && typeWild != typeI) {
                    v.removeElementAt(i);
                } else if (includeVersion) {
                    CatalogBag cb = null;
                    try {
                        cb = NativeMethods4JDK.getCB((Catalog)_dbHash.get(v.items[i]));
                    }
                    catch (ElementNotFoundError elementNotFoundError) {}
                    v.items[i] = String.valueOf(String.valueOf(v.items[i])) + "#" + cb.version;
                }
                --i;
            }
        }
        if ((s = (f = new java.io.File(path = JavaBridge.getDataPath() != null ? JavaBridge.getDataPath() : ".")).list()) != null) {
            byte[] buf = new byte[68];
            int i = 0;
            while (i < s.length) {
                if (v.indexOf(s[i]) == -1 && (s[i].toLowerCase().endsWith("prc") || s[i].toLowerCase().endsWith("pdb"))) {
                    try {
                        FileInputStream fis = new FileInputStream(new java.io.File(path, s[i]));
                        int readLength = fis.read(buf);
                        if (buf.length != readLength) {
                            throw new IOException("asked for " + buf.length + " bytes but read " + readLength);
                        }
                        int typeI = NativeMethods4JDK.makeInt(buf[60], buf[61], buf[62], buf[63]);
                        int crtrI = NativeMethods4JDK.makeInt(buf[64], buf[65], buf[66], buf[67]);
                        if (!(creatorIdWild != 0 && creatorIdWild != crtrI || typeWild != 0 && typeWild != typeI)) {
                            String type = "" + (char)buf[60] + (char)buf[61] + (char)buf[62] + (char)buf[63];
                            String crtr = "" + (char)buf[64] + (char)buf[65] + (char)buf[66] + (char)buf[67];
                            String version = String.valueOf(buf[34] << 8 | buf[35]);
                            String fullName = String.valueOf(s[i].substring(0, s[i].indexOf(46))) + '.' + crtr + '.' + type;
                            if (includeVersion) {
                                fullName = String.valueOf(fullName) + "#" + version;
                            }
                            if (v.indexOf(fullName) == -1) {
                                v.addElement(fullName);
                            }
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (IOException e) {
                        System.out.println("Error in Catalog.listCatalogs while reading " + s[i]);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return (String[])v.toObjectArray();
    }

    static int catalogReadBytes(Catalog obj, byte[] buf, int start, int count) {
        return NativeMethods4JDK._readWriteBytes(obj, buf, start, count, true);
    }

    static boolean catalogRename(Catalog obj, String newName) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen) {
            return false;
        }
        String[] st = Convert.tokenizeString(newName, '.');
        if (st == null || st.length < 3) {
            JavaBridge.print("Invalid catalog name: " + newName + ". It must be in the form MyCatalog.CRTR.TYPE (see documentation)");
            return false;
        }
        String path = NativeMethods4JDK.removeCatalogFromDisk(cb);
        cb._name = st.length == 3 ? st[0] : newName.substring(0, newName.length() - 10);
        cb._creator = st[st.length - 2];
        cb._type = st[st.length - 1];
        cb.deleted = false;
        ++cb.modificationNumber;
        _dbHash.put(NativeMethods4JDK.getHashName(cb), obj);
        if (path != null && path.length() > 0) {
            JavaBridge.htOpenedAt.put(NativeMethods4JDK.getFileName(cb), path);
        }
        return true;
    }

    static boolean catalogResizeRecord(Catalog obj, int size) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (cb._recordPos == -1) {
            return false;
        }
        byte[] oldRec = (byte[])cb._records.items[cb._recordPos];
        byte[] newRec = new byte[size];
        int copyLen = oldRec.length < newRec.length ? oldRec.length : newRec.length;
        System.arraycopy(oldRec, 0, newRec, 0, copyLen);
        cb._records.items[cb._recordPos] = newRec;
        ++cb.modificationNumber;
        return true;
    }

    static void catalogSetAttributes(Catalog obj, int attributes) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        cb.attributes = (short)attributes;
        ++cb.modificationNumber;
    }

    static void catalogSetRecordAttributes(Catalog obj, int recordPos, byte attr) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (recordPos < 0 || cb._attrs == null || recordPos >= cb._attrs.size()) {
            JavaBridge.print("could not change record attributes");
            return;
        }
        cb._attrs.items[recordPos] = new Byte(attr);
        ++cb.modificationNumber;
    }

    static boolean catalogSetRecordPos(Catalog obj, int pos) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (!cb._isOpen || pos < 0 || pos >= cb._records.size()) {
            if (!cb._isOpen && pos >= 0) {
                JavaBridge.print("Catalog is closed, can't setRecordPos(" + pos + ")");
            }
            cb._recordPos = -1;
            return false;
        }
        if (cb._attrs != null && ((Byte)cb._attrs.items[pos] & 0xFFFFFF80) != 0) {
            JavaBridge.print("You cannot setRecordPos in a deleted record");
            return false;
        }
        cb._recordPos = pos;
        obj.hvRecordOffset = 0;
        return true;
    }

    static int catalogSkipBytes(Catalog obj, int count) {
        CatalogBag cb = NativeMethods4JDK.getCB(obj);
        if (cb._recordPos == -1) {
            return -1;
        }
        byte[] rec = (byte[])cb._records.items[cb._recordPos];
        int off = obj.hvRecordOffset + count;
        if (off < 0 || off > rec.length) {
            return -1;
        }
        obj.hvRecordOffset += count;
        return count;
    }

    static int catalogWriteBytes(Catalog obj, byte[] buf, int start, int count) {
        return NativeMethods4JDK._readWriteBytes(obj, buf, start, count, false);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static CatalogBag createCB() {
        return new CatalogBag();
    }

    static boolean fileClose(File obj) {
        try {
            NativeMethods4JDK.getRaf(obj).close();
        }
        catch (Exception exception) {}
        obj.jraf = null;
        return true;
    }

    static void fileCreate(File obj, String path, int mode, int slot) {
        block2: {
            obj.jfile = new java.io.File(path);
            if (mode == 0) break block2;
            String rafMode = mode == 1 ? "r" : (mode == 2 ? "w" : (mode == 3 ? (NativeMethods4JDK.getFile(obj).exists() ? "rw" : "r") : "rw"));
            try {
                obj.jraf = new RandomAccessFile(path, rafMode);
            }
            catch (Exception exception) {
                obj.jraf = null;
            }
        }
    }

    static boolean fileCreateDir(File obj) {
        return NativeMethods4JDK.getFile(obj).mkdir();
    }

    static boolean fileDelete(File obj) {
        NativeMethods4JDK.fileClose(obj);
        return NativeMethods4JDK.getFile(obj).delete();
    }

    static boolean fileExists(File obj) {
        return NativeMethods4JDK.getFile(obj).exists();
    }

    static int fileGetAttributes(File obj) {
        return 0;
    }

    static int fileGetSize(File obj) {
        return (int)NativeMethods4JDK.getFile(obj).length();
    }

    static Time fileGetTime(File obj, byte whichTime) {
        java.io.File lFile = NativeMethods4JDK.getFile(obj);
        Date lDate = new Date(lFile.lastModified());
        return new Time(lDate.getYear(), lDate.getMonth(), lDate.getDay(), lDate.getHours(), lDate.getMinutes(), lDate.getSeconds(), 0);
    }

    static boolean fileIsAvailable() {
        return true;
    }

    static boolean fileIsDir(File obj) {
        return NativeMethods4JDK.getFile(obj).isDirectory();
    }

    static boolean fileIsInserted(int slot) {
        return true;
    }

    static boolean fileIsOpen(File obj) {
        return obj.jraf != null;
    }

    static String[] fileListFiles(File obj) {
        String pathWithSlash;
        String path = obj.path;
        String[] files = NativeMethods4JDK.getFile(obj).list();
        String string = pathWithSlash = (path = path.replace('\\', '/')).endsWith("/") ? path : String.valueOf(path) + '/';
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (new java.io.File(String.valueOf(pathWithSlash) + files[i]).isDirectory()) {
                    int n = i;
                    files[n] = String.valueOf(files[n]) + '/';
                }
                ++i;
            }
        }
        return files;
    }

    static int fileReadBytes(File obj, byte[] b, int off, int len) {
        try {
            return NativeMethods4JDK.getRaf(obj).read(b, off, len);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    static boolean fileRename(File obj, String path) {
        NativeMethods4JDK.fileClose(obj);
        try {
            return NativeMethods4JDK.getFile(obj).renameTo(new java.io.File(path));
        }
        catch (Exception exception) {
            return false;
        }
    }

    static void fileSetAttributes(File obj, int attr) {
    }

    static boolean fileSetPos(File obj, int pos) {
        try {
            RandomAccessFile raf = NativeMethods4JDK.getRaf(obj);
            if ((long)pos > raf.length()) {
                raf.setLength(pos + 1);
            }
            raf.seek(pos);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static void fileSetSize(File obj, int newSize) {
        try {
            RandomAccessFile raf = NativeMethods4JDK.getRaf(obj);
            raf.setLength(newSize);
            raf.seek(newSize - 1);
        }
        catch (Exception exception) {}
    }

    static void fileSetTime(File obj, byte whichTime, Time time) {
    }

    static int fileWriteBytes(File obj, byte[] b, int off, int len) {
        try {
            NativeMethods4JDK.getRaf(obj).write(b, off, len);
            return len;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    static final CatalogBag getCB(Catalog obj) {
        return (CatalogBag)obj.bag;
    }

    private static java.io.File getFile(File obj) {
        if (obj.jfile == null) {
            obj.jfile = new java.io.File(obj.path);
        }
        return (java.io.File)obj.jfile;
    }

    static String getFileName(CatalogBag cb) {
        return String.valueOf(cb._name) + ".pdb";
    }

    static String getHashName(CatalogBag cb) {
        return String.valueOf(cb._name) + "." + cb._creator + "." + cb._type;
    }

    public static java.net.Socket getNativeSocket(Socket obj) {
        return (java.net.Socket)_sockets.get(obj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPortName(int number) {
        if (portDEFAULT == null) {
            NativeMethods4JDK.initSWserial();
        }
        switch (number) {
            case 0: {
                return portDEFAULT;
            }
            case 4096: {
                return portIRCOMM;
            }
            case 4097: {
                return portSIR;
            }
            case 4098: {
                return portUSB;
            }
        }
        try {
            Object oCommPortIdentifier;
            Method mGetName;
            String portName;
            Class<?> cpi = Class.forName("javax.comm.CommPortIdentifier");
            Method mGetPortIdentifiers = cpi.getMethod("getPortIdentifiers", null);
            Enumeration portIds = (Enumeration)mGetPortIdentifiers.invoke(null, null);
            if (number == 0) {
                if (!portIds.hasMoreElements()) return null;
                Object oCommPortIdentifier2 = portIds.nextElement();
                Method mGetName2 = oCommPortIdentifier2.getClass().getMethod("getName", null);
                return (String)mGetName2.invoke(oCommPortIdentifier2, null);
            }
            do {
                if (portIds.hasMoreElements()) continue;
                return null;
            } while ((portName = (String)(mGetName = (oCommPortIdentifier = portIds.nextElement()).getClass().getMethod("getName", null)).invoke(oCommPortIdentifier, null)).indexOf(number + 48) == -1);
            return portName;
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return null;
    }

    private static RandomAccessFile getRaf(File obj) {
        return (RandomAccessFile)obj.jraf;
    }

    private static void initSWserial() {
        try {
            ResourceBundle swserial = ResourceBundle.getBundle("swserial");
            portDEFAULT = swserial.getString("DEFAULT");
            portIRCOMM = swserial.getString("IRCOMM");
            portSIR = swserial.getString("SIR");
            portUSB = swserial.getString("USB");
        }
        catch (MissingResourceException e) {
            System.out.println("Error: missing resource bundle: " + e.getClassName());
            System.out.println("Using defaults...");
            portDEFAULT = "COM1";
            portIRCOMM = "COM2";
            portSIR = "COM3";
            portUSB = "COM4";
        }
    }

    private static int makeInt(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    static String removeCatalogFromDisk(CatalogBag cb) {
        String name = NativeMethods4JDK.getFileName(cb);
        String path = (String)JavaBridge.htOpenedAt.get(name);
        try {
            if (path == null || path.length() == 0) {
                path = System.getProperty("user.dir");
            }
            if (path == null) {
                path = ".";
            }
            java.io.File f = new java.io.File(path, name);
            JavaBridge.print(String.valueOf(String.valueOf(f)) + " - exists?" + f.exists());
            if (!f.exists()) {
                path = "";
                f = new java.io.File(path, name);
                if (!f.exists() && JavaBridge.getDataPath() != null) {
                    path = JavaBridge.getDataPath();
                    f = new java.io.File(path, name);
                }
                JavaBridge.print(String.valueOf(String.valueOf(f)) + " - exists?" + f.exists());
            }
            cb.deleted = true;
            if (f.delete() || !f.exists()) {
                return path;
            }
            JavaBridge.print("Cannot delete file phisically. Removing logically...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static boolean serialPortClose(SerialPort obj) {
        try {
            Method m = obj.thisSerialPort.getClass().getSuperclass().getMethod("close", null);
            m.invoke(obj.thisSerialPort, null);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            obj.lastError = 65525;
            return false;
        }
    }

    static void serialPortCreate(SerialPort obj, int number, int baudRate, int bits, int parity, int stopBits) {
        try {
            Class<?> cpi = Class.forName("javax.comm.CommPortIdentifier");
            String portName = NativeMethods4JDK.getPortName(number);
            System.out.println("Port found: " + portName);
            Method mGetPortIdentifier = cpi.getMethod("getPortIdentifier", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = NativeMethods4JDK.class$("java.lang.String")));
            Object portId = mGetPortIdentifier.invoke(null, portName);
            Method mOpen = portId.getClass().getMethod("open", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = NativeMethods4JDK.class$("java.lang.String")), Integer.TYPE);
            Object port = mOpen.invoke(portId, "SuperWaba", new Integer(1000));
            Class<?> cSerialPort = port.getClass().getSuperclass();
            Method mSetSerialPortParams = cSerialPort.getMethod("setSerialPortParams", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            String[] parities = new String[]{"PARITY_NONE", "PARITY_EVEN", "PARITY_ODD"};
            Field parityField = cSerialPort.getField(parities[parity]);
            mSetSerialPortParams.invoke(port, new Integer(baudRate), new Integer(bits), new Integer(stopBits), new Integer(parityField.getInt(port)));
            Method mEnableReceiveTimeout = cSerialPort.getMethod("enableReceiveTimeout", Integer.TYPE);
            mEnableReceiveTimeout.invoke(port, new Integer(100));
            Method mGetInputStream = cSerialPort.getMethod("getInputStream", null);
            obj.thisInputStream = mGetInputStream.invoke(port, null);
            Method mGetOutputStream = cSerialPort.getMethod("getOutputStream", null);
            obj.thisOutputStream = mGetOutputStream.invoke(port, null);
            obj.thisSerialPort = port;
        }
        catch (InvocationTargetException ule) {
            ule.printStackTrace();
            System.out.println("Exception thrown when creating SerialPort: " + ule.getMessage());
            System.out.println("The probable cause of this message is that the port is in use (You must kill HotSync)\nor that the win32com.dll is not accessible in your path. Please add '/SuperwabaSDK/bin/tools/commapi' to your path or add '-Djava.library.path=/SuperwabaSDK/bin/tools/commapi' to your java.exe command");
            obj.thisSerialPort = null;
            obj.lastError = 65525;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("Cannot find javax.comm.CommPortIdentifier. You must add the /SuperwabaSDK/bin/tools/commapi/comm.jar file to your classpath. If you're not using Windows, then you must download the respective Comm api at http://java.sun.com/products/javacomm");
            obj.thisSerialPort = null;
            obj.lastError = 65525;
        }
        catch (Throwable t) {
            System.out.println("Exception occured when creating serial port: " + t.toString());
            t.printStackTrace();
            obj.thisSerialPort = null;
            obj.lastError = 771;
        }
    }

    static boolean serialPortIsOpen(SerialPort obj) {
        return obj.thisSerialPort != null;
    }

    static int serialPortReadBytes(SerialPort obj, byte[] buf, int start, int count) {
        try {
            Integer i;
            int read;
            int tries = readTries;
            Method m = obj.thisInputStream.getClass().getSuperclass().getMethod("read", array$B != null ? array$B : (array$B = NativeMethods4JDK.class$("[B")), Integer.TYPE, Integer.TYPE);
            int total = count;
            while ((read = (i = (Integer)m.invoke(obj.thisInputStream, buf, new Integer(start), new Integer(count))).intValue()) > 0) {
                start += read;
                if ((count -= read) > 0 && tries-- > 0) continue;
            }
            return total;
        }
        catch (Throwable t) {
            t.printStackTrace();
            obj.lastError = 778;
            return -1;
        }
    }

    static int serialPortReadCheck(SerialPort obj) {
        try {
            Method m = obj.thisInputStream.getClass().getSuperclass().getMethod("available", null);
            Integer i = (Integer)m.invoke(obj.thisInputStream, null);
            return i;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    static boolean serialPortSetFlowControl(SerialPort obj, boolean on) {
        try {
            Field fRTSCTS_IN = obj.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_RTSCTS_IN");
            Field fRTSCTS_OUT = obj.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_RTSCTS_OUT");
            Field fNONE = obj.thisSerialPort.getClass().getSuperclass().getField("FLOWCONTROL_NONE");
            Method m = obj.thisSerialPort.getClass().getSuperclass().getMethod("setFlowControlMode", Integer.TYPE);
            m.invoke(obj.thisSerialPort, on ? new Integer(fRTSCTS_IN.getInt(obj.thisSerialPort) | fRTSCTS_OUT.getInt(obj.thisSerialPort)) : new Integer(fNONE.getInt(obj.thisSerialPort)));
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            obj.lastError = 778;
            return false;
        }
    }

    static boolean serialPortSetReadTimeout(SerialPort obj, int millis) {
        try {
            Method mEnableReceiveTimeout = obj.thisSerialPort.getClass().getSuperclass().getMethod("enableReceiveTimeout", Integer.TYPE);
            mEnableReceiveTimeout.invoke(obj.thisSerialPort, new Integer(millis));
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            obj.lastError = 778;
            return false;
        }
    }

    static int serialPortWriteBytes(SerialPort obj, byte[] buf, int start, int count) {
        try {
            Method m = obj.thisOutputStream.getClass().getSuperclass().getMethod("write", array$B != null ? array$B : (array$B = NativeMethods4JDK.class$("[B")), Integer.TYPE, Integer.TYPE);
            m.invoke(obj.thisOutputStream, buf, new Integer(start), new Integer(count));
            return count;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    static boolean socketClose(Socket obj) {
        if (!obj._isOpen) {
            return false;
        }
        obj._isOpen = false;
        boolean pass = true;
        try {
            ((java.net.Socket)obj._socket).close();
            _sockets.remove(obj);
        }
        catch (Exception exception) {
            pass = false;
        }
        return pass;
    }

    static void socketCreate(Socket obj, String host, int port, int timeout, boolean noLinger) {
        block4: {
            obj._isOpen = false;
            try {
                obj._socket = new java.net.Socket(host, port);
                ((java.net.Socket)obj._socket).setSoTimeout(timeout);
                obj._in = ((java.net.Socket)obj._socket).getInputStream();
                obj._out = ((java.net.Socket)obj._socket).getOutputStream();
                obj._isOpen = true;
                _sockets.put(obj, obj._socket);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (obj._isOpen || obj._socket == null) break block4;
            try {
                ((java.net.Socket)obj._socket).close();
            }
            catch (Exception exception) {}
        }
    }

    static boolean socketDisconnect() {
        return true;
    }

    static boolean socketIsOpen(Socket obj) {
        return obj._isOpen;
    }

    static int socketReadBytes(Socket obj, byte[] buf, int start, int count) {
        if (!obj._isOpen) {
            return -1;
        }
        int nread = -1;
        try {
            nread = ((InputStream)obj._in).read(buf, start, count);
        }
        catch (InterruptedIOException interruptedIOException) {
            return 0;
        }
        catch (SocketException socketException) {
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nread;
    }

    static boolean socketSetReadTimeout(Socket obj, int millis) {
        if (millis < 0) {
            return false;
        }
        if (millis == 0) {
            millis = 1;
        }
        try {
            ((java.net.Socket)obj._socket).setSoTimeout(millis);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static int socketWriteBytes(Socket obj, byte[] buf, int start, int count) {
        if (!obj._isOpen) {
            return -1;
        }
        int nwrite = -1;
        try {
            ((OutputStream)obj._out).write(buf, start, count);
            nwrite = count;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nwrite;
    }

    static boolean writeCB(CatalogBag cb) {
        try {
            OutputStream os = JavaBridge.openOutputStream(NativeMethods4JDK.getFileName(cb));
            if (os != null) {
                cb.toPDB(os, cb._records, cb._creator, cb._name, cb._type, cb._attrs);
            } else {
                JavaBridge.print("could not write " + NativeMethods4JDK.getFileName(cb));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static class CatalogBag {
        boolean _isOpen;
        String _name;
        int _mode;
        Vector _records = new Vector(50);
        Vector _attrs = new Vector();
        int _recordPos;
        String _creator;
        String _type;
        int originalModificationNumber;
        boolean deleted;
        public boolean closeOnFinalize = true;
        byte[] appInfoBlock;
        byte[] sortInfoBlock;
        int creationDate;
        int modificationDate;
        int lastBackupDate;
        int modificationNumber;
        short attributes = (short)8;
        short version = 1;
        int appInfoOffset;
        int sortInfoOffset;
        int uniqueIDSeed;
        int nextRecordListID;

        private void doSetDate() {
            long timeX = this.getNow();
            this.modificationDate = this.creationDate = (int)timeX;
            this.lastBackupDate = (int)(timeX -= 31536000L);
        }

        protected void finalize() throws Throwable {
            try {
                if (this._isOpen && !this.deleted && this.closeOnFinalize) {
                    JavaBridge.print("Catalog " + this._name + " being closed by GC...");
                    NativeMethods4JDK.catalogClose(this);
                }
            }
            catch (Exception exception) {}
        }

        public Vector fromPDB(byte[] all, String creatorId, String typeId, Vector _attrs) throws Exception {
            int len;
            DataStream is = new DataStream(new ByteArrayStream(all));
            if (all.length == 0) {
                throw new Exception("Invalid File with 0 length!");
            }
            byte[] name = new byte[32];
            byte[] type = new byte[4];
            byte[] creator = new byte[4];
            is.readBytes(name);
            this.attributes = is.readShort();
            this.version = is.readShort();
            this.creationDate = is.readInt();
            this.modificationDate = is.readInt();
            this.lastBackupDate = is.readInt();
            this.modificationNumber = is.readInt();
            this.appInfoOffset = is.readInt();
            this.sortInfoOffset = is.readInt();
            is.readBytes(type);
            is.readBytes(creator);
            this.uniqueIDSeed = is.readInt();
            this.originalModificationNumber = this.modificationNumber;
            if (!creatorId.equals(new String(creator)) || !typeId.equals(new String(type))) {
                if (all.length >= 8 && new String(all, 0, 8).trim().equalsIgnoreCase("<HTML>")) {
                    return new Vector();
                }
                throw new Exception("Error: invalid pdb file! creatorId '" + creatorId + "' != '" + new String(creator) + "' and/or typeId '" + typeId + "' != '" + new String(type) + "' \n" + new String(all, 0, Math.min(all.length, 1024)));
            }
            this.nextRecordListID = is.readInt();
            if (this.nextRecordListID != 0) {
                throw new Exception("Invalid database file! SuperWaba does not support multiple record or resource lists in a Database!!!");
            }
            int numRecords = is.readUnsignedShort();
            int[] recOffsets = new int[numRecords + 1];
            byte[] recUniqueID = new byte[3];
            if (_attrs != null) {
                _attrs.removeAllElements();
            }
            int i = 0;
            while (i < numRecords) {
                recOffsets[i] = is.readInt();
                byte recAttributes = is.readByte();
                is.readBytes(recUniqueID);
                if (_attrs != null) {
                    _attrs.addElement(new Byte(recAttributes));
                }
                ++i;
            }
            recOffsets[numRecords] = all.length;
            int offset = 80 + numRecords * 8;
            int offset2 = recOffsets[0];
            int toSkip = 2 - (offset - offset2);
            is.skip(toSkip);
            if (this.appInfoOffset > 0) {
                len = this.sortInfoOffset > 0 ? this.sortInfoOffset - offset : recOffsets[0] - offset;
                this.appInfoBlock = new byte[len];
                is.readBytes(this.appInfoBlock);
                offset += len;
            }
            if (this.sortInfoOffset > 0) {
                len = recOffsets[0] - offset;
                this.sortInfoBlock = new byte[len];
                is.readBytes(this.sortInfoBlock);
                offset += len;
            }
            Vector v = new Vector(numRecords);
            int size = 0;
            int i2 = 0;
            while (i2 < numRecords) {
                size = recOffsets[i2 + 1] - recOffsets[i2];
                if (size <= 0) {
                    throw new Exception("Invalid record " + i2 + "! Size <= 0 (" + size + ")");
                }
                byte[] bytes = new byte[size];
                is.readBytes(bytes);
                v.addElement(bytes);
                ++i2;
            }
            is.close();
            return v;
        }

        public static CatalogBag getCatalogBag(Catalog cat) {
            return (CatalogBag)cat.bag;
        }

        private long getNow() {
            long timeX = new Date().getTime() / 1000L;
            return timeX += 2082844800L;
        }

        public void toPDB(OutputStream outStream, Vector records, String creatorId, String dbName, String typeId, Vector _attrs) throws Exception {
            byte[] name = new byte[32];
            byte[] type = typeId.getBytes();
            byte[] creator = creatorId.getBytes();
            int slash = -1;
            slash = dbName.lastIndexOf(92);
            if (slash != -1 || (slash = dbName.lastIndexOf(47)) != -1) {
                dbName = dbName.substring(slash + 1);
            }
            if (dbName.length() > 31) {
                dbName = dbName.substring(0, 31);
            }
            byte[] bn = dbName.getBytes();
            int i = 0;
            while (i < name.length) {
                name[i] = i < bn.length ? bn[i] : (byte)0;
                ++i;
            }
            int numRecords = records.size();
            ByteArrayStream bas = new ByteArrayStream(8192);
            DataStream os = new DataStream(bas);
            int offset = 80 + numRecords * 8;
            if (this.appInfoBlock != null) {
                this.appInfoOffset = offset;
                offset += this.appInfoBlock.length;
            }
            if (this.sortInfoBlock != null) {
                this.sortInfoOffset = offset;
                offset += this.sortInfoBlock.length;
            }
            this.modificationDate = (int)this.getNow();
            os.writeBytes(name);
            os.writeShort(this.attributes);
            os.writeShort(this.version);
            os.writeInt(this.creationDate);
            os.writeInt(this.modificationDate);
            os.writeInt(this.lastBackupDate);
            os.writeInt(this.modificationNumber);
            os.writeInt(this.appInfoOffset);
            os.writeInt(this.sortInfoOffset);
            os.writeBytes(type);
            os.writeBytes(creator);
            os.writeInt(this.uniqueIDSeed);
            int nextRecordListID = 0;
            os.writeInt(nextRecordListID);
            os.writeShort(numRecords);
            byte[] recUniqueID = new byte[3];
            int i2 = 0;
            while (i2 < numRecords) {
                os.writeInt(offset);
                if (_attrs == null || i2 >= _attrs.size()) {
                    os.writeByte(0);
                } else {
                    os.writeByte((int)((Byte)_attrs.items[i2] & 0xFFFFFFDF));
                }
                os.writeBytes(recUniqueID);
                int recSize = ((byte[])records.items[i2]).length;
                if (recSize > 65520) {
                    JavaBridge.print("CAUTION! RECORD " + i2 + " HAS A SIZE GREATER THAN 65520 AND WILL BE REJECTED BY PALM OS!");
                }
                offset += recSize;
                ++i2;
            }
            os.writeShort(0);
            if (this.appInfoBlock != null) {
                os.writeBytes(this.appInfoBlock);
            }
            outStream.write(bas.getBuffer(), 0, bas.count());
            int i3 = 0;
            while (i3 < numRecords) {
                outStream.write((byte[])records.items[i3]);
                records.items[i3] = null;
                ++i3;
            }
            outStream.close();
        }
    }
}

