/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Catalog;
import waba.io.IOError;
import waba.io.Stream;

public class ResizeRecord
extends Stream {
    private Catalog cat;
    private int initialSize;
    private int written;
    private int size;

    public ResizeRecord(Catalog cat, int initialSize) {
        this.cat = cat;
        this.initialSize = initialSize;
    }

    public boolean close() {
        return this.cat.close();
    }

    public void endRecord() throws IOError {
        if (this.written > 0) {
            if (this.written != this.size) {
                this.cat.resizeRecord(this.written);
            }
        } else {
            this.cat.deleteRecord();
        }
        this.size = 0;
    }

    public Stream getStream() {
        return this.cat;
    }

    public boolean isOpen() {
        return this.cat.isOpen();
    }

    public int readBytes(byte[] buf, int start, int count) {
        return this.cat.readBytes(buf, start, count);
    }

    public boolean restartRecord(int pos) throws IOError {
        if (pos < 0 || pos >= this.cat.getRecordCount()) {
            return this.startRecord();
        }
        this.written = 0;
        this.size = this.initialSize;
        if (this.cat.setRecordPos(pos)) {
            this.size = this.cat.getRecordSize();
            return true;
        }
        return false;
    }

    public boolean startRecord() throws IOError {
        boolean ok = this.cat.addRecord(this.initialSize) != -1;
        this.written = 0;
        this.size = this.initialSize;
        return ok;
    }

    public boolean startRecord(int pos) throws IOError {
        boolean ok = pos >= this.cat.getRecordCount() ? this.cat.addRecord(this.initialSize) != -1 : this.cat.addRecord(this.initialSize, pos) != -1;
        this.written = 0;
        this.size = this.initialSize;
        return ok;
    }

    public int writeBytes(byte[] buf, int start, int count) {
        if (this.size == 0) {
            return this.cat.writeBytes(buf, start, count);
        }
        if (count - start <= 0) {
            return 0;
        }
        int total = this.written + (count - start);
        while (total > this.size) {
            if (this.size == 65520) {
                return -1;
            }
            this.size += this.initialSize;
            if (this.size > 65520) {
                this.size = 65520;
            }
            try {
                if (this.cat.resizeRecord(this.size)) continue;
                return -1;
            }
            catch (IOError iOError) {
                return -1;
            }
        }
        int n = this.cat.writeBytes(buf, start, count);
        if (n >= 0) {
            this.written += n;
        }
        return n;
    }
}

