/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.NativeMethods4JDK;
import waba.io.Stream;
import waba.sys.Convert;

public class SerialPort
extends Stream {
    public int lastError;
    Object thisSerialPort;
    Object thisInputStream;
    Object thisOutputStream;
    boolean hvIsNewSerialMgr;
    boolean hvIsDirectHardware;
    public boolean stopWriteCheckOnTimeout = true;
    public int writeTimeout = 6000;
    public String lastErrorStr;
    public static final int DEFAULT = 0;
    public static final int IRCOMM = 4096;
    public static final int SIR = 4097;
    public static final int USB = 4098;
    public static final int BLUETOOTH = 4099;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_EVEN = 1;
    public static final int PARITY_ODD = 2;

    public SerialPort(int number, int baudRate) {
        this(number, baudRate, 8, false, 1);
    }

    public SerialPort(int number, int baudRate, int bits, int parity, int stopBits) {
        NativeMethods4JDK.serialPortCreate(this, number, baudRate, bits, parity, stopBits);
    }

    public SerialPort(int number, int baudRate, int bits, boolean parity, int stopBits) {
        NativeMethods4JDK.serialPortCreate(this, number, baudRate, bits, parity ? 1 : 0, stopBits);
    }

    public boolean close() {
        return NativeMethods4JDK.serialPortClose(this);
    }

    public void finalize() {
    }

    public String getStatus() {
        if (this.lastError == 0) {
            return "Ok";
        }
        if (this.lastError == -10000) {
            return "Error code: " + this.lastErrorStr;
        }
        return Convert.unsigned2hex(this.lastError, 8);
    }

    public boolean isOpen() {
        return NativeMethods4JDK.serialPortIsOpen(this);
    }

    public int readBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.serialPortReadBytes(this, buf, start, count);
    }

    public int readCheck() {
        return NativeMethods4JDK.serialPortReadCheck(this);
    }

    public boolean setFlowControl(boolean on) {
        return NativeMethods4JDK.serialPortSetFlowControl(this, on);
    }

    public boolean setReadTimeout(int millis) {
        return NativeMethods4JDK.serialPortSetReadTimeout(this, millis);
    }

    public int writeBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.serialPortWriteBytes(this, buf, start, count);
    }
}

