/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.NativeMethods4JDK;
import waba.io.Stream;
import waba.sys.Convert;

public class Socket
extends Stream {
    public int lastError;
    public boolean refreshBeforeEachRead;
    boolean _isOpen;
    Object _socket;
    Object _in;
    Object _out;
    public String lastErrorStr;
    private static byte[] rlbuf = new byte[1];
    private static int firstChar;
    private static StringBuffer rlsb;

    static {
        rlsb = new StringBuffer(100);
    }

    protected Socket() {
    }

    public Socket(String host, int port) {
        this(host, port, 1500, false);
    }

    public Socket(String host, int port, int timeout) {
        NativeMethods4JDK.socketCreate(this, host, port, timeout, false);
    }

    public Socket(String host, int port, int timeout, boolean noLingerOrDirectTCP) {
        NativeMethods4JDK.socketCreate(this, host, port, timeout, noLingerOrDirectTCP);
    }

    public boolean close() {
        return NativeMethods4JDK.socketClose(this);
    }

    public static boolean disconnect() {
        return NativeMethods4JDK.socketDisconnect();
    }

    public void finalize() {
    }

    public String getStatus() {
        if (this.lastError == 0) {
            return "Ok";
        }
        if (this.lastError == -10000) {
            return "Error code: " + this.lastErrorStr;
        }
        return Convert.unsigned2hex(this.lastError, 8);
    }

    public boolean isOpen() {
        return NativeMethods4JDK.socketIsOpen(this);
    }

    public int readBytes(byte[] buf) {
        return NativeMethods4JDK.socketReadBytes(this, buf, 0, buf.length);
    }

    public int readBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.socketReadBytes(this, buf, start, count);
    }

    public String readLine() {
        int r;
        byte[] buf = rlbuf;
        StringBuffer sb = rlsb;
        sb.setLength(0);
        if (firstChar > 0) {
            sb.append((char)firstChar);
            firstChar = 0;
        }
        while ((r = this.readBytes(buf, 0, 1)) == 1) {
            char c = (char)(buf[0] & 0xFF);
            if (c == '\n' || c == '\r') {
                r = this.readBytes(buf, 0, 1);
                if (r != 1 || (c = (char)(buf[0] & 0xFF)) == '\n') break;
                firstChar = c;
                break;
            }
            sb.append(c);
        }
        return sb.length() > 0 || r == 1 ? sb.toString() : null;
    }

    public boolean setReadTimeout(int millis) {
        return NativeMethods4JDK.socketSetReadTimeout(this, millis);
    }

    public int writeBytes(String s) {
        byte[] buf = s.getBytes();
        return NativeMethods4JDK.socketWriteBytes(this, buf, 0, buf.length);
    }

    public int writeBytes(byte[] buf) {
        return NativeMethods4JDK.socketWriteBytes(this, buf, 0, buf.length);
    }

    public int writeBytes(byte[] buf, int start, int count) {
        return NativeMethods4JDK.socketWriteBytes(this, buf, start, count);
    }
}

