/*
 * Decompiled with CFR 0.152.
 */
package waba.sys;

import waba.sys.Convert;
import waba.sys.NativeMethods4JDK;
import waba.sys.Settings;
import waba.util.Date;

public final class Time {
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int millis;
    private static StringBuffer sb = new StringBuffer(20);

    public Time() {
        NativeMethods4JDK.timeCreate(this);
    }

    public Time(int year, int month, int day, int hour, int minute, int second, int millis) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millis = millis;
    }

    public Time(long t) {
        this.second = (int)(t % 100L);
        this.minute = (int)((t /= 100L) % 100L);
        this.hour = (int)((t /= 100L) % 100L);
        this.day = (int)((t /= 100L) % 100L);
        this.month = (int)((t /= 100L) % 100L);
        this.year = (int)(t /= 100L);
    }

    public Time(String iso8601) {
        char[] chars = iso8601.toCharArray();
        this.year = Convert.toInt(new String(chars, 0, 4));
        this.month = Convert.toInt(new String(chars, 4, 2));
        this.day = Convert.toInt(new String(chars, 6, 2));
        this.hour = Convert.toInt(new String(chars, 9, 2));
        this.minute = Convert.toInt(new String(chars, 12, 2));
        this.second = Convert.toInt(new String(chars, 15, 2));
    }

    public boolean equals(Object o) {
        if (o instanceof Time) {
            Time t = (Time)o;
            return this.year == t.year && this.month == t.month && this.day == t.day && this.hour == t.hour && this.minute == t.minute && this.second == t.second && this.millis == t.millis;
        }
        return o == this;
    }

    public long getTimeLong() {
        int i = this.hour * 10000 + this.minute * 100 + this.second;
        return (long)this.year * 10000000000L + (long)this.month * 100000000L + (long)(this.day * 1000000) + (long)i;
    }

    public String toIso8601() {
        StringBuffer sb = Time.sb;
        sb.setLength(0);
        sb.append(new Date(this).getDateInt());
        sb.append('T');
        if (this.hour < 10) {
            sb.append('0');
        }
        sb.append(this.hour);
        sb.append(':');
        if (this.minute < 10) {
            sb.append('0');
        }
        sb.append(this.minute);
        sb.append(':');
        if (this.second < 10) {
            sb.append('0');
        }
        sb.append(this.second);
        return sb.toString();
    }

    public String toString() {
        boolean useAmPm = Settings.is24Hour ^ true;
        StringBuffer sb = Time.sb;
        sb.setLength(0);
        if (useAmPm) {
            if (this.hour == 0 || this.hour == 12) {
                sb.append("12");
            } else {
                int h;
                int n = h = this.hour < 12 ? this.hour : this.hour - 12;
                if (h < 10) {
                    sb.append('0');
                }
                sb.append(h);
            }
        } else {
            if (this.hour < 10) {
                sb.append('0');
            }
            sb.append(this.hour);
        }
        sb.append(Settings.timeSeparator);
        if (this.minute < 10) {
            sb.append('0');
        }
        sb.append(this.minute);
        sb.append(Settings.timeSeparator);
        if (this.second < 10) {
            sb.append('0');
        }
        sb.append(this.second);
        if (useAmPm) {
            sb.append(this.hour >= 12 ? " PM" : " AM");
        }
        return sb.toString();
    }
}

