/*
 * Decompiled with CFR 0.152.
 */
package waba.sys;

import waba.sys.CharacterConverter;
import waba.sys.Vm;

public class UTF8CharacterConverter
extends CharacterConverter {
    public char[] bytes2chars(byte[] bytes, int start, int length) {
        int end = start + length;
        int tgtOfs = 0;
        char[] chars = new char[length];
        while (start < end) {
            int c;
            int c0;
            if ((c0 = bytes[start++] & 0xFF) < 128) {
                chars[tgtOfs++] = (char)c0;
                continue;
            }
            if (start >= end) {
                chars[tgtOfs++] = 63;
                break;
            }
            if (((c = bytes[start++] & 0xFF ^ 0x80) & 0xC0) != 0) {
                --start;
                chars[tgtOfs++] = 63;
                continue;
            }
            int r = c0 << 6 | c;
            if ((c0 & 0xE0) == 192) {
                chars[tgtOfs++] = (char)(r & 0x7FF);
                continue;
            }
            if (start >= end) {
                chars[tgtOfs++] = 63;
                break;
            }
            if (((c = bytes[start++] & 0xFF ^ 0x80) & 0xC0) != 0) {
                --start;
                chars[tgtOfs++] = 63;
                continue;
            }
            chars[tgtOfs++] = (char)(r << 6 | c);
        }
        if (chars.length > tgtOfs) {
            char[] temp = new char[tgtOfs];
            Vm.copyArray(chars, 0, temp, 0, tgtOfs);
            chars = temp;
        }
        return chars;
    }

    public byte[] chars2bytes(char[] chars, int start, int length) {
        int tgtOfs = 0;
        int end = start + length;
        byte[] bytes = new byte[Math.min(65500, length + length + length)];
        while (start < end) {
            char r;
            if ((r = chars[start++]) < '\u0080') {
                bytes[tgtOfs++] = (byte)r;
                continue;
            }
            if (r < '\u0800') {
                bytes[tgtOfs++] = (byte)(0xC0 | r >> 6);
                bytes[tgtOfs++] = (byte)(0x80 | r & 0x3F);
                continue;
            }
            bytes[tgtOfs++] = (byte)(0xE0 | r >> 12);
            bytes[tgtOfs++] = (byte)(0x80 | r >> 6 & 0x3F);
            bytes[tgtOfs++] = (byte)(0x80 | r & 0x3F);
        }
        if (bytes.length > tgtOfs) {
            byte[] temp = new byte[tgtOfs];
            Vm.copyArray(bytes, 0, temp, 0, tgtOfs);
            bytes = temp;
        }
        return bytes;
    }
}

