/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Graphics;
import waba.fx.Sound;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Label;
import waba.ui.PushButtonGroup;
import waba.ui.UIColors;
import waba.ui.Window;

public class Calculator
extends Window {
    private Edit edOper1;
    private Edit edOper2;
    private Edit edOrig;
    private Label lTotal;
    private PushButtonGroup pbgPaste;
    private PushButtonGroup pbgAction;
    private PushButtonGroup pbgOper;
    private PushButtonGroup numericPad;
    private String answer;
    private KeyEvent ke = new KeyEvent();
    public int decimalPlaces = 4;

    public Calculator() {
        super("Calculator", (byte)1);
        this.highResPrepared = true;
        float factor = (float)this.fmH / 11.0f;
        int ww = factor == 1.0f ? 120 : (int)(factor * 110.0f);
        int hh = factor == 1.0f ? 130 : (int)(factor * 120.0f);
        this.setRect(120000, 120000, ww, hh);
    }

    public void clear(boolean requestFocusOnOper1) {
        if (requestFocusOnOper1) {
            this.setFocus(this.edOper1);
        }
        this.clear();
        this.answer = null;
    }

    public String getAnswer() {
        return this.answer;
    }

    private boolean isOk(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                int key = ((KeyEvent)event).key;
                if (key != 76007) return;
                Sound.beep();
                this.unpop();
                return;
            }
            case 302: {
                if (!(event.target instanceof Edit)) return;
                this.validate((Edit)event.target);
                return;
            }
            case 300: {
                String s;
                if (event.target == this.pbgPaste && this.pbgPaste.getSelected() != -1) {
                    String string = this.answer = this.pbgPaste.getSelected() == 0 ? this.edOper1.getText() : this.lTotal.getText();
                    if (this.edOrig != null) {
                        this.edOrig.setText(this.answer);
                    }
                    this.unpop();
                    return;
                }
                if (event.target == this.pbgAction && this.pbgAction.getSelected() != -1) {
                    switch (this.pbgAction.getSelected()) {
                        case 0: {
                            this.edOper1.setText(this.lTotal.getText());
                            this.edOper2.setText("");
                            this.lTotal.setText("");
                            return;
                        }
                        case 1: {
                            this.clear(true);
                            return;
                        }
                        case 2: {
                            this.unpop();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (event.target == this.pbgOper && this.validate(this.edOper1) && this.validate(this.edOper2)) {
                    double oper1 = Convert.toDouble(this.edOper1.getText());
                    double oper2 = Convert.toDouble(this.edOper2.getText());
                    double result = 0.0;
                    switch (this.pbgOper.getSelected()) {
                        case 0: {
                            result = oper1 + oper2;
                            break;
                        }
                        case 1: {
                            result = oper1 - oper2;
                            break;
                        }
                        case 2: {
                            result = oper1 * oper2;
                            break;
                        }
                        case 3: {
                            result = oper1 / oper2;
                            break;
                        }
                        case 4: {
                            result = Math.pow(oper1, oper2);
                            break;
                        }
                    }
                    this.lTotal.setText(Convert.toString(result, this.decimalPlaces));
                    return;
                }
                if (event.target != this.numericPad || !(this.getFocus() instanceof Edit) || (s = this.numericPad.getSelectedCaption()) == null) return;
                this.ke.key = s.charAt(0);
                this.ke.target = this.getFocus();
                this.getFocus().onEvent(this.ke);
                return;
            }
        }
    }

    public void onPopup() {
        this.clear(false);
        Control c = Window.topMost.getFocus();
        if (c instanceof Edit) {
            this.edOrig = (Edit)c;
            String s = this.edOrig.getText();
            if (s.length() > 0 && "+-0123456789".indexOf(s.charAt(0)) != -1) {
                this.edOper1.setText(s);
            }
        } else {
            this.edOrig = null;
        }
    }

    public void onStart() {
        if (Settings.isColor) {
            this.setBackColor(UIColors.calculatorBack);
        }
        String[] opers = new String[]{" + ", " - ", " * ", " / ", " ^ "};
        String[] pastes = new String[]{"Paste Op 1", "Paste Total"};
        String[] actions = new String[]{"Reuse", "Clear", "Cancel"};
        this.edOper1 = new Edit("999999999,99");
        this.add(this.edOper1, 110002, 140002);
        this.edOper1.setMode((byte)2);
        this.edOper1.setKeyboard((byte)0);
        int extra = Settings.screenWidth >= 240 ? 2 : 0;
        this.edOper2 = new Edit("999999999,99");
        this.add(this.edOper2, 180000, 190002);
        this.edOper2.setMode((byte)2);
        this.edOper2.setKeyboard((byte)0);
        this.pbgOper = new PushButtonGroup(opers, false, -1, -1, 4, 0, false, 1);
        this.add(this.pbgOper);
        this.pbgOper.setRect(180000, 190004, 100000, 100002);
        this.pbgPaste = new PushButtonGroup(pastes, false, -1, 2, 14, 2, true, 1);
        this.add(this.pbgPaste, 110002, 149998);
        this.pbgAction = new PushButtonGroup(actions, false, -1, 2, 12 + extra * 5, 3, true, 1);
        this.add(this.pbgAction, 129998, 149998);
        this.lTotal = new Label("");
        this.add(this.lTotal);
        this.lTotal.setRect(110002, 180000, 160000 - this.pbgAction.getPreferredWidth() - 4, 100000);
        if (!Settings.keypadOnly) {
            String[] numerics = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ".", "-"};
            this.numericPad = new PushButtonGroup(numerics, false, -1, -1, 10 + extra * 3, 4, true, 1);
            this.add(this.numericPad);
            this.numericPad.setRect(129998, 140002, 100000, 100012);
            this.numericPad.setFocusLess(true);
        }
        if (Settings.isColor) {
            this.pbgOper.setBackColor(UIColors.calculatorFore);
            if (!Settings.keypadOnly) {
                this.numericPad.setBackColor(UIColors.calculatorFore);
            }
            this.pbgPaste.setBackColor(UIColors.calculatorAction);
            this.pbgAction.setBackColor(UIColors.calculatorAction);
        }
        this.numericPad.clearValueInt = -1;
        this.pbgOper.clearValueInt = -1;
        this.pbgAction.clearValueInt = -1;
        this.pbgPaste.clearValueInt = -1;
        this.clear(false);
    }

    public void onUnpop() {
        this.setFocus(this);
    }

    public void postPopup() {
        String text1 = this.edOper1.getText();
        this.setFocus(text1.length() > 0 && Convert.toDouble(text1) != 0.0 ? this.edOper2 : this.edOper1);
    }

    protected void postUnpop() {
        if (this.answer != null) {
            this.postPressedEvent();
        }
    }

    private boolean validate(Edit ed) {
        if (this != Window.topMost) {
            return true;
        }
        String s = ed.getText();
        boolean ok = this.isOk(s);
        String msgErr = null;
        if (ed == this.edOper1 || ed == this.edOper2) {
            String f = "";
            if (ok && ((f = Convert.toString(s, this.decimalPlaces)).length() <= 0 || f.equals("0"))) {
                msgErr = "err: " + s;
            } else if (this.isOk(f)) {
                s = f;
            }
        }
        if (msgErr != null) {
            Sound.beep();
            ed.setText(msgErr);
            Graphics gg = ed.createGraphics();
            ed.onPaint(gg);
            gg.free();
            Vm.sleep(1500);
        }
        if (this.isOk(s)) {
            ed.setText(s);
        }
        return msgErr == null;
    }
}

