/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.PenEvent;
import waba.ui.UIColors;

public class Check
extends Control {
    private String text;
    private boolean checked;
    private Color cbColor;
    private Color cfColor;
    private Color[] fourColors = new Color[4];
    private int textW;

    public Check(String text) {
        this.text = text;
        this.textW = this.fm.getTextWidth(text);
    }

    public void clear() {
        this.setChecked(this.clearValueInt == 1);
    }

    public boolean getChecked() {
        return this.checked;
    }

    public int getPreferredHeight() {
        if (this.fmH == 11) {
            return Control.uiCE ? this.fmH + 2 : this.fmH;
        }
        return this.fm.ascent;
    }

    public int getPreferredWidth() {
        return this.textW + this.getPreferredHeight() + 2;
    }

    public String getText() {
        return this.text;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.cbColor = UIColors.sameColors ? this.backColor : this.getBackColor().brighter();
        this.cfColor = this.getForeColor();
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        if (event.target != this) {
            return;
        }
        switch (event.type) {
            case 101: {
                this.checked ^= true;
                this.repaintNow();
                this.postEvent(new ControlEvent(300, this));
                break;
            }
            case 200: {
                this.checked ^= true;
                this.repaint();
                PenEvent pe = (PenEvent)event;
                if (pe.x < 0 || pe.x >= this.width || pe.y < 0 || pe.y >= this.height) break;
                this.postEvent(new ControlEvent(300, this));
                break;
            }
        }
    }

    protected void onFontChanged() {
        this.textW = this.fm.getTextWidth(this.text);
    }

    public void onPaint(Graphics g) {
        int wh = this.height;
        g.setBackColor(this.backColor);
        g.fillRect(0, 0, this.width, this.height);
        if (Control.uiVista && this.enabled) {
            g.fill3dRect(0, 0, wh, wh, this.cbColor, true, false);
        } else {
            g.setBackColor(this.cbColor);
            g.fillRect(0, 0, wh, wh);
        }
        g.draw3dRect(0, 0, wh, wh, (byte)4, false, false, this.fourColors);
        g.setForeColor(this.cfColor);
        if (this.checked) {
            Check.paintCheck(g, this.fmH, this.height);
        }
        int yy = this.height - this.fmH >> 1;
        int xx = this.width - this.textW;
        g.setBackColor(this.backColor);
        g.drawText(this.text, xx, yy);
    }

    public static void paintCheck(Graphics g, int fmH, int height) {
        int wh = height;
        int m = (wh >> 1) - 1;
        if (fmH >= 22) {
            --m;
        }
        int yy = m;
        int xx = Control.uiPalm ? 2 : 3;
        wh -= xx;
        int i = xx;
        while (i < wh) {
            g.drawLine(xx, yy, xx, yy + 2);
            ++xx;
            yy = i < m ? ++yy : --yy;
            ++i;
        }
    }

    public void setChecked(boolean checked) {
        if (this.checked != checked) {
            this.checked = checked;
            this.repaint();
        }
    }

    public void setText(String text) {
        this.text = text;
        this.textW = this.fm.getTextWidth(text);
        this.repaint();
    }
}

