/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.UIColors;
import waba.ui.Window;
import waba.util.Vector;

public class Container
extends Control {
    protected Control children;
    protected Control tail;
    private byte borderStyle = 0;
    private Color[] fourColors = new Color[4];
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_LOWERED = 2;
    public static final byte BORDER_RAISED = 3;
    public static final byte BORDER_SIMPLE = 5;
    protected Window parentWindow;
    protected int lastX = -999999;
    protected int lastY;
    protected int lastW;
    protected int lastH;
    private int numChildren;
    protected boolean started;
    boolean finishedStart;
    public Vector tabOrder = new Vector();

    public Container() {
        this.foreColor = UIColors.controlsFore;
        this.backColor = UIColors.controlsBack;
        this.asContainer = this;
    }

    public void add(Control control) {
        if (control.parent != null) {
            control.parent.remove(control);
        }
        control.next = null;
        if (this.children == null) {
            this.children = control;
        } else {
            this.tail.next = control;
        }
        control.prev = this.tail;
        this.tail = control;
        control.parent = this;
        if (control.backColor == null) {
            control.backColor = this.backColor;
        }
        if (control.foreColor == null) {
            control.foreColor = this.foreColor;
        }
        ++this.numChildren;
        if (control.asContainer != null) {
            control.asContainer.parentWindow = this.parentWindow;
        }
        control.onColorsChanged(true);
        if (control.width > 0 && this.finishedStart) {
            control.repaint();
        }
        if (control.asContainer != null && control.asContainer.started) {
            control.asContainer.onAdd();
        }
        if (control.focusTraversable && !control.focusLess) {
            this.tabOrder.addElement(control);
        }
    }

    public void add(Control control, int x, int y) {
        this.add(control);
        control.setRect(x, y, 100000, 100000, null);
    }

    public void add(Control control, int x, int y, Control relative) {
        this.add(control);
        control.setRect(x, y, 100000, 100000, relative);
    }

    public void broadcastEvent(Event e) {
        this.onEvent(e);
        Control child = this.children;
        while (child != null) {
            child.onEvent(e);
            if (child.asContainer != null) {
                child.asContainer.broadcastEvent(e);
            }
            child = child.next;
        }
    }

    public void clear() {
        Control child = this.children;
        while (child != null) {
            if (child.focusTraversable) {
                child.clear();
            }
            child = child.next;
        }
    }

    public Control findChild(int x, int y) {
        Container container = this;
        while (true) {
            Control child = container.tail;
            while (!(child == null || child.contains(x, y) && child.visible)) {
                child = child.prev;
            }
            if (child == null) {
                return container;
            }
            if (child.asContainer == null) {
                return child;
            }
            x -= child.x;
            y -= child.y;
            container = child.asContainer;
        }
    }

    public Control[] getChildren() {
        if (this.numChildren == 0) {
            return null;
        }
        Control[] ac = new Control[this.numChildren];
        Control child = this.tail;
        int i = 0;
        while (child != null) {
            ac[i] = child;
            ++i;
            child = child.prev;
        }
        return ac;
    }

    public Rect getClientRect() {
        Rect r = new Rect();
        this.getClientRect(r);
        return r;
    }

    public void getClientRect(Rect r) {
        int gap = this.borderStyle == 0 ? 0 : (this.borderStyle == 5 ? 1 : 2);
        r.set(gap, gap, this.width - gap - gap, this.height - gap - gap);
    }

    protected void onAdd() {
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (this.borderStyle != 0 && this.borderStyle != 5) {
            Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
        }
    }

    public void onPaint(Graphics g) {
        if (this.parent != null && (this.backColor != this.parent.backColor || this.parent.asWindow != null)) {
            g.setBackColor(this.backColor);
            g.fillRect(0, 0, this.width, this.height);
        }
        switch (this.borderStyle) {
            case 5: {
                g.setForeColor(this.getForeColor());
                g.drawRect(0, 0, this.width, this.height);
                break;
            }
            default: {
                g.draw3dRect(0, 0, this.width, this.height, this.borderStyle, false, false, this.fourColors);
            }
            case 0: 
        }
    }

    protected void onRemove() {
    }

    protected void onStart() {
    }

    public void paintChildren(Graphics g, int x, int y, int width, int height) {
        Control child = this.children;
        int xx2 = x + width - 1;
        int yy2 = y + height - 1;
        while (child != null) {
            int cy2;
            int y1;
            int cy1;
            int y2;
            int cx2;
            int x1;
            int cx1;
            int x2;
            if (child.visible && (x2 = xx2) >= (cx1 = child.x) && (x1 = x) <= (cx2 = child.x2) && (y2 = yy2) >= (cy1 = child.y) && (y1 = y) <= (cy2 = child.y2)) {
                if (x1 < cx1) {
                    x1 = cx1;
                }
                if (y1 < cy1) {
                    y1 = cy1;
                }
                if (x2 > cx2) {
                    x2 = cx2;
                }
                if (y2 > cy2) {
                    y2 = cy2;
                }
                g.setClip(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
                g.translate(cx1, cy1);
                if (child.font != g.lastFont) {
                    g.setFont(child.font);
                }
                child.onPaint(g);
                if (child.asContainer != null) {
                    child.asContainer.paintChildren(g, x1 - cx1, y1 - cy1, x2 - x1 + 1, y2 - y1 + 1);
                }
                g.translate(-cx1, -cy1);
            }
            child = child.next;
        }
        g.clearClip();
    }

    public void remove(Control control) {
        if (control.parent != this) {
            return;
        }
        if (this.asWindow != null && this.asWindow.highlighted == control) {
            this.asWindow.highlighted = null;
        }
        Control prev = control.prev;
        Control next = control.next;
        if (prev == null) {
            this.children = next;
        } else {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        if (this.tail == control) {
            this.tail = prev;
        }
        control.next = null;
        control.prev = null;
        --this.numChildren;
        control.repaint();
        this.repaint();
        control.parent = null;
        if (this.getParentWindow().getFocus() == control) {
            this.requestFocus();
        }
        if (control.asContainer != null) {
            control.asContainer.onRemove();
        }
        if (control.focusTraversable && !control.focusLess) {
            this.tabOrder.removeElement(control);
        }
    }

    public void setBorderStyle(byte border) {
        this.borderStyle = border;
        this.onColorsChanged(false);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (this.foreDis == null) {
                this.backDis = this.backColor.darker();
                this.foreDis = this.foreColor.brighter();
            }
            this.onColorsChanged(false);
            Control child = this.children;
            while (child != null) {
                child.setEnabled(enabled);
                child = child.next;
            }
            this.repaint();
        }
    }

    public void setHighlighting() {
        Control.isHighlighting = true;
    }

    public void swapToTopmostWindow() {
        Window.getTopMost().swap(this);
    }
}

