/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Convert;
import waba.ui.Control;

public class Label
extends Control {
    protected String text;
    public int align;
    private static final String[] emptyStringArray = new String[]{""};
    protected String[] lines = emptyStringArray;
    protected int[] linesW;
    private int linesPerPage;
    private int currentLine;
    private boolean invert;
    private boolean is3d;
    private int hh;
    private Color fColor;
    private Color dColor;
    public static int commonVGap;

    public Label(String text) {
        this(text, 110000);
    }

    public Label(String text, int align) {
        this.align = align;
        this.setText(text);
        this.clearValueStr = null;
        this.focusTraversable = false;
    }

    public boolean canScroll(boolean down) {
        if (this.lines.length > this.linesPerPage) {
            if (down) {
                return this.currentLine + this.linesPerPage < this.lines.length;
            }
            return this.currentLine >= this.linesPerPage;
        }
        return false;
    }

    public void clear() {
        if (this.clearValueStr != null) {
            this.setText(this.clearValueStr);
        }
    }

    public int getPreferredHeight() {
        return this.fmH * this.lines.length + (this.invert ? 1 : 0) + commonVGap;
    }

    public int getPreferredWidth() {
        if (this.text.length() == 0) {
            return 160000;
        }
        int w = 0;
        int i = this.lines.length - 1;
        while (i >= 0) {
            w = Math.max(w, this.linesW[i]);
            --i;
        }
        return w + (this.invert ? 2 : 0);
    }

    public String getText() {
        return this.text;
    }

    protected void onBoundsChanged() {
        this.linesPerPage = this.height / this.fmH;
        if (this.linesPerPage < 1) {
            this.linesPerPage = 1;
        }
        this.hh = this.fmH * this.linesPerPage;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.fColor = this.getForeColor();
        if (this.is3d) {
            this.dColor = this.backColor.darker();
        }
    }

    protected void onFontChanged() {
        if (this.linesW == null || this.linesW.length != this.lines.length) {
            this.linesW = new int[this.lines.length];
        }
        int inv = this.invert && this.align == 130000 ? 1 : 0;
        int[] linesW = this.linesW;
        int i = this.lines.length - 1;
        while (i >= 0) {
            linesW[i] = this.fm.getTextWidth(this.lines[i]) + inv;
            --i;
        }
        this.hh = this.fmH * this.linesPerPage;
    }

    public void onPaint(Graphics g) {
        if (this.invert) {
            g.setForeColor(this.backColor);
            g.setBackColor(this.fColor);
        } else {
            g.setForeColor(this.fColor);
            g.setBackColor(this.backColor);
        }
        g.fillRect(0, 0, this.width, this.height);
        if (this.text.length() > 0) {
            int y = this.height - this.hh >> 1;
            int n = Math.min(this.currentLine + this.linesPerPage, this.lines.length);
            int xx = this.invert ? 1 : 0;
            int fmH = this.fmH;
            int[] linesW = this.linesW;
            int i = this.currentLine;
            while (i < n) {
                int x = 0;
                if (this.align != 110000) {
                    if (this.align == 120000) {
                        x = this.width - linesW[i] >> 1;
                    } else if (this.align == 130000) {
                        x = this.width - linesW[i];
                    }
                }
                if (this.is3d) {
                    g.setForeColor(this.dColor);
                    g.drawText(this.lines[i], xx + x + 1, y + 1);
                    g.setForeColor(this.fColor);
                }
                g.drawText(this.lines[i], xx + x, y);
                ++i;
                y += fmH;
            }
        }
    }

    public boolean scroll(boolean down) {
        if (this.lines.length > this.linesPerPage) {
            int lastLine = this.currentLine;
            if (down) {
                if (this.currentLine + this.linesPerPage < this.lines.length) {
                    this.currentLine += this.linesPerPage;
                }
            } else {
                this.currentLine -= this.linesPerPage;
                if (this.currentLine < 0) {
                    this.currentLine = 0;
                }
            }
            if (lastLine != this.currentLine) {
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public void set3d(boolean on) {
        this.is3d = on;
        if (on) {
            this.invert = false;
        }
        if (on && this.dColor == null) {
            this.onColorsChanged(true);
        }
    }

    public void setInvert(boolean on) {
        this.invert = on;
        if (on) {
            this.is3d = false;
        }
    }

    public void setText(String text) {
        this.text = text;
        this.lines = Convert.tokenizeString(text, '|');
        this.currentLine = 0;
        this.onFontChanged();
        this.repaint();
    }
}

