/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PenEvent;
import waba.ui.ScrollBar;
import waba.util.IntVector;
import waba.util.Vector;

public class ListBox
extends Container {
    protected Vector items = new Vector();
    protected int offset;
    protected int selectedIndex = -1;
    protected int itemCount;
    protected int visibleItems;
    protected int btnX;
    protected ScrollBar sbar;
    protected boolean simpleBorder;
    protected int xOffset;
    private Color fColor;
    private Color back0;
    private Color back1;
    private Color[] fourColors = new Color[4];
    private Graphics myg;
    private Color customCursorColor;
    private IntVector ivWidths;
    private int xOffsetMin;
    private Button btnLeft;
    private Button btnRight;
    public int extraHorizScrollButtonHeight = Settings.screenHeight * 2 / 160;
    public static boolean useFullWidthOnSelection;

    public ListBox() {
        this(null);
    }

    public ListBox(Object[] items) {
        this.sbar = new ScrollBar();
        this.sbar.focusTraversable = false;
        super.add(this.sbar);
        this.started = true;
        this.sbar.setLiveScrolling(true);
        if (items != null) {
            this.items = new Vector(items);
            this.itemCount = items.length;
        }
        this.sbar.setMaximum(this.itemCount);
    }

    public void add(Object item) {
        this.items.addElement(item);
        if (this.ivWidths != null) {
            int w = this.fm.getTextWidth(item.toString());
            this.ivWidths.addElement(w);
            this.verifyItemWidth(w);
        }
        ++this.itemCount;
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    public void add(Control control) {
        Vm.warning("add(Control) cannot be used in the ListBox class!");
    }

    public void add(Object[] moreItems) {
        if (this.itemCount == 0) {
            this.items = new Vector(moreItems);
            this.itemCount = moreItems.length;
            if (this.ivWidths != null) {
                this.enableHorizScroll();
            }
        } else {
            int n = moreItems.length;
            this.itemCount += n;
            int i = 0;
            while (i < n) {
                this.items.addElement(moreItems[i]);
                ++i;
            }
            if (this.ivWidths != null) {
                int m = 0;
                int mx = -this.xOffsetMin;
                int i2 = 0;
                while (i2 < n) {
                    int w = this.fm.getTextWidth(moreItems[i2].toString());
                    this.ivWidths.addElement(w);
                    if (w > mx) {
                        m = w;
                    }
                    ++i2;
                }
                this.verifyItemWidth(m);
            }
        }
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    public void clear() {
        this.select(this.clearValueInt);
    }

    protected void drawCursor(Graphics g, int sel, boolean on) {
        if (this.offset <= sel && sel < this.visibleItems + this.offset && sel < this.itemCount) {
            int sw;
            g.setForeColor(this.fColor);
            g.setBackColor(on ? this.back1 : this.back0);
            int dx = 3;
            int dy = 3;
            if (Control.uiPalm || Control.uiFlat) {
                --dy;
            }
            if (this.simpleBorder) {
                --dx;
                --dy;
            }
            g.setClip(dx - 1, dy - (Control.uiCE ? 1 : 0), this.btnX - dx, this.fmH * this.visibleItems + (Control.uiPalm ? 1 : 2));
            dx += this.xOffset;
            dy += (sel - this.offset) * this.fmH;
            if (useFullWidthOnSelection || (sw = this.getItemWidth(sel)) == 0) {
                sw = this.btnX - 4;
            }
            g.fillRect(dx - 1, dy - 1, sw + 2, this.fmH + this.fm.descent);
            this.drawItem(g, sel, ++dx - 1, dy);
        }
    }

    protected void drawItem(Graphics g, int index, int dx, int dy) {
        g.drawText(this.items.items[index].toString(), dx, dy);
    }

    private void enableButtons() {
        if (this.xOffset < this.xOffsetMin) {
            this.xOffset = this.xOffsetMin;
        }
        if (this.btnLeft != null) {
            this.btnLeft.setEnabled(this.enabled && this.xOffset < 0);
            this.btnRight.setEnabled(this.enabled && this.xOffset > this.xOffsetMin);
        }
    }

    public void enableHorizScroll() {
        if (this.itemCount > 0) {
            int n = this.itemCount;
            int m = 0;
            int[] widths = new int[n];
            int i = 0;
            while (i < n) {
                int w = widths[i] = this.fm.getTextWidth(this.items.items[i].toString());
                if (widths[i] > m) {
                    m = w;
                }
                ++i;
            }
            this.ivWidths = new IntVector(widths);
            this.verifyItemWidth(m);
        } else {
            this.ivWidths = new IntVector();
            this.xOffsetMin = 0;
            this.enableButtons();
        }
    }

    protected void find(char c) {
        String s;
        c = Convert.toUpperCase(c);
        int foundIndex = -1;
        int i = this.selectedIndex + 1;
        while (i < this.itemCount) {
            s = this.items.items[i].toString();
            if (s.length() > 0 && Convert.toUpperCase(s.charAt(0)) == c) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex == -1 && this.selectedIndex >= 0) {
            i = 0;
            while (i < this.selectedIndex) {
                s = this.items.items[i].toString();
                if (s.length() > 0 && Convert.toUpperCase(s.charAt(0)) == c) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (foundIndex != -1) {
            this.select(foundIndex);
            this.repaint();
        }
    }

    public Object getItemAt(int i) {
        if (i >= 0 && i < this.itemCount) {
            return this.items.items[i];
        }
        return "";
    }

    protected int getItemWidth(int index) {
        return this.fm.getTextWidth(this.items.items[index].toString());
    }

    public Object[] getItems() {
        return this.items.toObjectArray();
    }

    public int getPreferredHeight() {
        int n = this.itemCount;
        int h = Math.max(this.fmH * n, this.sbar.getPreferredHeight()) + (this.simpleBorder ? 4 : 6);
        return n == 1 ? h - 1 : h;
    }

    public int getPreferredWidth() {
        int extra = (this.simpleBorder ? 4 : 6) + this.sbar.getPreferredWidth();
        int maxWidth = 0;
        int i = this.itemCount - 1;
        while (i >= 0) {
            int w = this.getItemWidth(i);
            if (w > maxWidth) {
                maxWidth = w;
            }
            --i;
        }
        return maxWidth + extra;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        return this.selectedIndex >= 0 ? this.items.items[this.selectedIndex] : "";
    }

    private void horizontalScroll(boolean toLeft) {
        int newOffset;
        int step = this.width >> 1;
        int n = newOffset = toLeft ? Math.min(this.xOffset + step, 0) : Math.max(this.xOffset - step, this.xOffsetMin);
        if (newOffset != this.xOffset) {
            this.xOffset = newOffset;
            this.enableButtons();
            this.repaint();
        }
    }

    public int indexOf(Object name) {
        return this.items.indexOf(name);
    }

    public void insert(Object item, int index) {
        this.items.insertElementAt(item, index);
        if (this.ivWidths != null) {
            int w = this.fm.getTextWidth(item.toString());
            this.ivWidths.insertElementAt(w, index);
            this.verifyItemWidth(w);
        }
        ++this.itemCount;
        this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
        this.sbar.setMaximum(this.itemCount);
    }

    protected void onBoundsChanged() {
        int btnW = this.sbar.getPreferredWidth();
        int m = Control.uiFlat ? 0 : (this.simpleBorder ? 1 : 2);
        int n = 0;
        this.visibleItems = (this.height - m - 2) / this.fmH;
        this.btnX = this.width - m - btnW;
        if (Control.uiPalm) {
            --this.btnX;
            ++m;
        }
        if (this.ivWidths != null) {
            if (this.btnRight == null) {
                int hh = 3 * this.fmH / 11;
                this.btnRight = Button.createArrowButton((byte)4, hh, this.foreColor);
                super.add(this.btnRight);
                this.btnLeft = Button.createArrowButton((byte)3, hh, this.foreColor);
                super.add(this.btnLeft);
                this.btnLeft.focusTraversable = false;
                this.btnRight.focusTraversable = false;
                this.tabOrder.removeElement(this.btnRight);
                this.tabOrder.removeElement(this.btnLeft);
                if (Control.uiPalm) {
                    this.btnRight.setBorder((byte)0);
                    this.btnLeft.setBorder((byte)0);
                }
            }
            n = this.btnRight.getPreferredHeight() + this.extraHorizScrollButtonHeight << 1;
            if (Control.uiFlat) {
                n -= 2;
            }
            this.enableButtons();
        }
        this.sbar.setMaximum(this.itemCount);
        this.sbar.setVisibleItems(this.visibleItems);
        this.sbar.setEnabled(this.visibleItems < this.itemCount);
        this.sbar.setRect(this.btnX, m, btnW, this.height - (m << 1) - n);
        if (Settings.keyboardFocusTraversable) {
            this.sbar.setFocusLess(true);
        }
        if (this.ivWidths != null) {
            n = Control.uiFlat ? 1 : 0;
            this.btnLeft.setRect(180000, 190000 - n, 180000, 100000 + this.extraHorizScrollButtonHeight);
            this.btnRight.setRect(180000, 190000 - n, 180000, 100000 + this.extraHorizScrollButtonHeight);
        }
        this.myg = this.createGraphics();
        if (this.visibleItems >= this.itemCount) {
            this.offset = 0;
        }
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.fColor = this.getForeColor();
        this.back0 = this.getBackColor().brighter();
        Color color = this.customCursorColor != null ? this.customCursorColor : (this.back1 = this.back0.equ != Color.WHITE.equ ? this.backColor : this.back0.getCursorColor());
        if (this.fColor.equ == this.back1.equ) {
            this.fColor = this.foreColor;
        }
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
        if (this.btnRight != null) {
            this.btnRight.setBackForeColors(this.backColor, this.foreColor);
            this.btnLeft.setBackForeColors(this.backColor, this.foreColor);
        }
        if (colorsChanged) {
            this.sbar.setBackForeColors(Control.uiVista ? this.back0 : this.backColor, this.foreColor);
        }
    }

    public void onEvent(Event event) {
        switch (event.type) {
            case 498: {
                if (this.myg != null) {
                    this.myg.free();
                }
                this.myg = this.createGraphics();
                break;
            }
            case 300: {
                if (event.target == this.sbar) {
                    int newOffset = this.sbar.getValue();
                    if (newOffset == this.offset) break;
                    this.offset = newOffset;
                    this.repaint();
                    break;
                }
                if (event.target != this.btnLeft && event.target != this.btnRight) break;
                this.horizontalScroll(event.target == this.btnLeft);
                break;
            }
            case 200: 
            case 203: {
                int newSelection;
                PenEvent pe = (PenEvent)event;
                if (event.target != this || pe.x >= this.btnX || !this.contains(this.x + pe.x, this.y + pe.y) || (newSelection = (pe.y - (this.simpleBorder ? 3 : 4)) / this.fmH + this.offset) == this.selectedIndex || newSelection >= this.itemCount) break;
                if (this.selectedIndex >= 0) {
                    this.drawCursor(this.myg, this.selectedIndex, false);
                }
                this.selectedIndex = newSelection;
                this.drawCursor(this.myg, this.selectedIndex, true);
                break;
            }
            case 100: {
                KeyEvent ke = (KeyEvent)event;
                if (Settings.keyboardFocusTraversable && ke.isActionKey()) {
                    this.postEvent(new ControlEvent(300, this));
                    break;
                }
                if (ke.isPrevKey() || ke.isNextKey()) {
                    if (Settings.keyboardFocusTraversable) {
                        if (ke.isUpKey()) {
                            this.select(this.selectedIndex == 0 ? this.itemCount - 1 : this.selectedIndex - 1);
                            break;
                        }
                        if (ke.isDownKey()) {
                            this.select(this.selectedIndex == this.itemCount - 1 ? 0 : this.selectedIndex + 1);
                            break;
                        }
                        if (ke.key != 75006 && ke.key != 75007) break;
                        this.horizontalScroll(ke.key == 75006);
                        break;
                    }
                    if (ke.key == 75006 || ke.key == 75007) {
                        this.horizontalScroll(ke.key == 75006);
                        break;
                    }
                    this.sbar.onEvent(event);
                    break;
                }
                this.find(Convert.toUpperCase((char)ke.key));
                break;
            }
            case 202: {
                if (event.target != this) break;
                PenEvent pe = (PenEvent)event;
                int newSelection = (pe.y - (this.simpleBorder ? 3 : 4)) / this.fmH + this.offset;
                if (!this.contains(this.x + pe.x, this.y + pe.y) || pe.x >= this.btnX || newSelection >= this.itemCount) break;
                this.postEvent(new ControlEvent(300, this));
                break;
            }
        }
    }

    public void onPaint(Graphics g) {
        if (this.myg == null) {
            this.myg = this.createGraphics();
        }
        g.setBackColor(this.back0);
        g.fillRect(0, 0, this.btnX, this.height);
        g.setForeColor(this.foreColor);
        if (this.simpleBorder && Control.uiCE) {
            g.drawRect(0, 0, this.width, this.height);
        } else {
            g.draw3dRect(0, 0, this.width, this.height, Control.uiPalm ? (byte)5 : 4, false, false, this.fourColors);
        }
        g.setForeColor(this.fColor);
        int dx = 2;
        int dy = 3;
        if (Control.uiPalm || Control.uiFlat) {
            --dy;
        }
        if (this.simpleBorder) {
            --dx;
            --dy;
        }
        g.setClip(dx - 1, dy - (Control.uiCE ? 1 : 0), this.btnX - dx, this.fmH * this.visibleItems + (Control.uiPalm ? 1 : 2));
        dx += this.xOffset;
        int greatestVisibleItemIndex = Math.min(this.itemCount, this.visibleItems + this.offset);
        int incY = this.fmH;
        ++dx;
        int i = this.offset;
        while (i < greatestVisibleItemIndex) {
            this.drawItem(g, i, dx, dy);
            ++i;
            dy += incY;
        }
        if (this.selectedIndex >= 0) {
            this.drawCursor(g, this.selectedIndex, true);
        }
    }

    public void qsort() {
        this.items.qsort();
        this.select(-1);
    }

    public void remove(int itemIndex) {
        if (itemIndex >= 0 && itemIndex < this.itemCount) {
            this.items.removeElementAt(itemIndex);
            --this.itemCount;
            if (this.ivWidths != null) {
                int old = this.ivWidths.items[itemIndex];
                this.ivWidths.removeElementAt(itemIndex);
                if (old == -this.xOffsetMin) {
                    int m = 0;
                    int[] widths = this.ivWidths.items;
                    int n = this.ivWidths.size();
                    int i = 0;
                    while (i < n) {
                        if (widths[i] > m) {
                            m = widths[i];
                        }
                        ++i;
                    }
                    this.verifyItemWidth(m);
                }
            }
            this.sbar.setMaximum(this.itemCount);
            this.sbar.setEnabled(this.enabled && this.visibleItems < this.itemCount);
            if (this.selectedIndex == this.itemCount) {
                this.select(this.selectedIndex - 1);
            }
            if (this.itemCount == 0) {
                this.selectedIndex = -1;
            }
            if (this.itemCount <= this.visibleItems && this.offset != 0) {
                this.offset = 0;
            }
            this.repaint();
        }
    }

    public void remove(Object item) {
        int index;
        if (this.itemCount > 0 && (index = this.items.indexOf(item)) != -1) {
            this.remove(index);
        }
    }

    public void remove(Control control) {
        Vm.warning("remove(Control) cannot be used in the ListBox class!");
    }

    public void removeAll() {
        this.items.removeAllElements();
        this.sbar.setMaximum(0);
        this.itemCount = 0;
        this.offset = 0;
        this.xOffsetMin = 0;
        this.xOffset = 0;
        if (this.ivWidths != null) {
            this.ivWidths.removeAllElements();
            this.enableButtons();
        }
        this.selectedIndex = -1;
        this.repaint();
    }

    public void select(int i) {
        if (i >= 0 && i < this.itemCount && i != this.selectedIndex && this.height != 0) {
            int ma;
            this.offset = i;
            int vi = this.sbar.getVisibleItems();
            if (this.offset + vi > (ma = this.sbar.getMaximum())) {
                this.offset = Math.max(ma - vi, 0);
            }
            this.selectedIndex = i;
            this.sbar.setValue(this.offset);
            this.repaint();
        } else if (i == -1) {
            this.offset = 0;
            this.sbar.setValue(0);
            this.selectedIndex = -1;
            this.repaint();
        }
    }

    public void select(Object name) {
        int idx = this.indexOf(name);
        if (idx != -1) {
            this.select(idx);
        }
    }

    public void selectLast() {
        if (this.itemCount > 0) {
            this.select(this.itemCount - 1);
            this.repaintNow();
        }
    }

    public void setCursorColor(Color color) {
        this.customCursorColor = color;
        this.onColorsChanged(true);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (this.foreDis == null) {
                this.backDis = this.backColor.darker();
                this.foreDis = this.foreColor.brighter();
            }
            this.onColorsChanged(false);
            this.sbar.setEnabled(enabled && this.visibleItems < this.itemCount);
            if (this.btnLeft != null) {
                this.enableButtons();
            }
            this.repaint();
        }
    }

    public void setItemAt(int i, Object s) {
        if (i >= 0 && i < this.itemCount) {
            this.items.items[i] = s;
            if (this.ivWidths != null) {
                this.ivWidths.items[i] = this.fm.getTextWidth(s.toString());
                this.verifyItemWidth(this.ivWidths.items[i]);
            }
            this.repaint();
        }
    }

    public void setSimpleBorder(boolean simpleBorder) {
        this.simpleBorder = simpleBorder;
    }

    public int size() {
        return this.itemCount;
    }

    private void verifyItemWidth(int w) {
        int newxOffsetMin = -Math.max(w - this.width + this.sbar.width + 4, 0);
        if (newxOffsetMin < this.xOffsetMin) {
            this.xOffsetMin = newxOffsetMin;
            this.enableButtons();
        }
    }
}

