/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.sys.Settings;
import waba.sys.Thread;
import waba.sys.Vm;
import waba.ui.Control;
import waba.ui.NativeMethods4JDK;
import waba.ui.Timer;
import waba.ui.Window;
import waba.util.ElementNotFoundError;
import waba.util.Vector;

public class MainWindow
extends Window {
    private Vector vThreads = new Vector(5);
    private Timer timers;
    private int currentRunningThread;
    private int threadCount;
    private int highThreadCount;
    static MainWindow mainWindowInstance;
    static Graphics myg0;
    public static Font defaultFont;
    private Timer startTimer;

    static {
        defaultFont = Font.getFont("SW", false, 9);
    }

    public MainWindow() {
        this(null, 0);
    }

    public MainWindow(String title, byte style) {
        super(title, style);
        this.highResPrepared = true;
        if (Settings.isColor) {
            this.setBackColor(Color.getColor(160, 216, 236));
        }
        mainWindowInstance = this;
        NativeMethods4JDK.mainWindowCreate(this);
        Window.zStack.push(this);
        this.canDrag = false;
        this.x2 = this.width - 1;
        this.y2 = this.height - 1;
        Window.topMost = this;
    }

    public void _onTimerTick() {
        if (this.startTimer != null) {
            Timer t = this.startTimer;
            this.startTimer = null;
            this.removeTimer(t);
            this.repaint();
            this.onStart();
            this.repaint();
            this.started = true;
        }
        int minInterval = 0;
        int now = Vm.getTimeStamp();
        Timer timer = this.timers;
        while (timer != null) {
            int interval;
            int diff = now - timer.lastTick;
            if (diff < 0) {
                diff += 0x40000000;
            }
            if (diff >= timer.millis) {
                Control c = timer.target;
                Window._controlEvent.type = 303;
                Window._controlEvent.target = c;
                timer.triggered = true;
                c.postEvent(Window._controlEvent);
                timer.triggered = false;
                timer.lastTick = now;
                interval = timer.millis;
            } else {
                interval = timer.millis - diff;
            }
            if (interval < minInterval || minInterval == 0) {
                minInterval = interval;
            }
            timer = timer.next;
        }
        NativeMethods4JDK.mainWindowSetTimerInterval(minInterval);
        if (Window.topMost.needsPaint) {
            this._doPaint();
        }
    }

    public void _runThreads() {
        if (this.highThreadCount > 0) {
            int i = 0;
            while (i < this.highThreadCount) {
                ((Thread)this.vThreads.items[i]).run();
                ++i;
            }
        }
        if (this.threadCount - this.highThreadCount > 0) {
            if (this.currentRunningThread >= this.threadCount || this.currentRunningThread < this.highThreadCount) {
                this.currentRunningThread = this.highThreadCount;
            }
            ((Thread)this.vThreads.items[this.currentRunningThread++]).run();
        }
    }

    public void addThread(Thread t, boolean highPriority) {
        if (this.vThreads.indexOf(t) == -1) {
            if (highPriority) {
                this.vThreads.insertElementAt(t, 0);
                ++this.highThreadCount;
                if (this.currentRunningThread > 0) {
                    ++this.currentRunningThread;
                }
            } else {
                this.vThreads.addElement(t);
            }
            this.setThreadCount(this.vThreads.size());
            t.started();
        }
    }

    protected Timer addTimer(Control target, int millis) {
        Timer t = new Timer();
        t.target = target;
        t.millis = millis;
        t.lastTick = Vm.getTimeStamp();
        t.next = this.timers;
        this.timers = t;
        this._onTimerTick();
        return t;
    }

    public final void appEnding() {
        this.killThreads();
        if (this.resetSipToBottom) {
            this.setStatePosition(0, 10002);
        }
        this.onExit();
    }

    public final void appStarting() {
        myg0 = this.createGraphics();
        this.startTimer = this.addTimer(1);
    }

    public final void exit(int exitCode) {
        NativeMethods4JDK.mainWindowExit(exitCode);
    }

    public String getCommandLine() {
        return NativeMethods4JDK.mainWindowGetCommandLine();
    }

    public FontMetrics getFontMetrics(Font font) {
        return font.fm;
    }

    public static MainWindow getMainWindow() {
        return mainWindowInstance;
    }

    public void killThreads() {
        try {
            while (--this.threadCount >= 0) {
                ((Thread)this.vThreads.pop()).stopped();
            }
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        this.highThreadCount = 0;
    }

    public void onExit() {
    }

    public void onStart() {
    }

    public void removeThread(Thread t) {
        int index = this.vThreads.indexOf(t);
        if (index >= 0) {
            this.vThreads.removeElement(t);
            if (index < this.highThreadCount) {
                --this.highThreadCount;
                if (this.currentRunningThread > 0) {
                    --this.currentRunningThread;
                }
            }
            t.stopped();
            this.setThreadCount(this.vThreads.size());
        }
    }

    public boolean removeTimer(Timer timer) {
        if (timer == null) {
            return false;
        }
        Timer t = this.timers;
        Timer prev = null;
        while (t != timer) {
            if (t == null) {
                return false;
            }
            prev = t;
            t = t.next;
        }
        if (prev == null) {
            this.timers = t.next;
        } else {
            prev.next = t.next;
        }
        this._onTimerTick();
        return true;
    }

    public void setRect(int x, int y, int width, int height, Control relative) {
        Vm.warning("The MainWindow bounds is set by the VM and cannot be changed by the user!");
    }

    private void setThreadCount(int count) {
        this.threadCount = count;
        NativeMethods4JDK.mainWindowSetThreadCount(count);
    }
}

