/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Settings;
import waba.ui.Control;

public class ProgressBar
extends Control {
    public int min;
    public int max;
    private int value;
    public String prefix = "";
    public String suffix = "%";
    public Color textColor = Settings.isColor ? Color.RED : Color.WHITE;
    public boolean drawBorder = true;
    private static StringBuffer sb = new StringBuffer();

    public ProgressBar() {
        this(0, 100);
    }

    public ProgressBar(int min, int max) {
        this.min = this.value = min;
        this.max = max;
        if (!Settings.isColor) {
            this.foreColor = Color.BLACK;
            this.backColor = Color.DARK;
        } else {
            this.foreColor = Color.getColor(0, 0, 200);
        }
        this.focusTraversable = false;
    }

    public void clear() {
        this.setValue(this.clearValueInt);
    }

    public int getPreferredHeight() {
        return this.fmH + 2;
    }

    public int getPreferredWidth() {
        return this.parent == null ? Settings.screenWidth : this.parent.getSize().x - 6;
    }

    public int getValue() {
        return this.value;
    }

    public void onPaint(Graphics g) {
        int w;
        int dif = this.max - this.min;
        int n = dif == 0 || this.value == this.max ? this.width : (w = this.value == 0 ? 0 : this.width * (this.value - this.min) / dif);
        if (w > this.width) {
            w = this.width;
        }
        if (w > 0) {
            if (Control.uiVista && this.enabled) {
                g.fill3dRect(0, 0, w, this.height, this.getForeColor(), false, false);
            } else {
                g.setBackColor(this.getForeColor());
                g.fillRect(0, 0, w, this.height);
            }
        }
        g.setBackColor(this.getBackColor());
        int ww = this.width - w;
        if (ww > 0) {
            g.fillRect(w, 0, ww, this.height);
        }
        StringBuffer sb = ProgressBar.sb;
        sb.setLength(0);
        String st = sb.append(this.prefix).append(this.value).append(this.suffix).toString();
        g.setForeColor(this.textColor);
        g.drawText(st, this.width - this.fm.getTextWidth(st) >> 1, (this.height - this.fmH >> 1) - 1);
        if (this.drawBorder) {
            g.drawRect(0, 0, this.width, this.height);
        }
    }

    public void setValue(int n) {
        if (this.value != n) {
            this.value = n;
            this.repaintNow();
        }
    }

    public void setValue(int value, String prefix, String suffix) {
        this.value = value;
        this.prefix = prefix;
        this.suffix = suffix;
        this.repaintNow();
    }
}

