/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Font;
import waba.io.File;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Button;
import waba.ui.Event;
import waba.ui.Label;
import waba.ui.ListBox;
import waba.ui.MainWindow;
import waba.ui.MenuBar;
import waba.ui.MenuItem;
import waba.ui.MessageBox;
import waba.ui.Window;

public class Welcome
extends MainWindow {
    private MenuBar mbar;
    private MenuItem miAudibleGC;
    private MenuItem miDumpMem;
    private MenuItem miCheckLeak;
    private MenuItem miPrintStack;
    private MenuItem miDebug2NVFS;
    private MenuItem miReadNVFS;

    public Welcome() {
        super("Welcome", (byte)4);
        this.setDoubleBuffer(true);
    }

    public void onEvent(Event e) {
        block13: {
            block1 : switch (e.type) {
                case 300: {
                    if (e.target != this.mbar) break;
                    switch (this.mbar.getSelectedMenuItem()) {
                        case 1: {
                            File f = new File("/DebugConsole", 1, 1);
                            if (!f.isOpen()) {
                                new MessageBox("Attention", "File DebugConsole on the|NVFS volume was not found.").popupModal();
                                break block1;
                            }
                            MessageBox mb = null;
                            try {
                                mb = new MessageBox("Wait", "Loading and parsing file...", null);
                                mb.popupModal();
                                mb.unpop();
                                mb = null;
                                new View(f).popupModal();
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                new MessageBox("Error", "Out of memory.").popupModal();
                            }
                            if (mb != null) {
                                mb.unpop();
                                break block1;
                            }
                            break block13;
                        }
                        case 3: {
                            this.exit(0);
                            break block1;
                        }
                        case 104: {
                            MessageBox mb = new MessageBox("Caution", "Are you sure? This is not|a secure feature and at some|times can reset the device|while printing the trace!", new String[]{"Yes", "No"});
                            mb.popupBlockingModal();
                            this.miPrintStack.isChecked = mb.getPressedButtonIndex() == 0;
                            break block1;
                        }
                        case 201: {
                            new MessageBox("About", "SuperWaba Virtual Machine|www.superwaba.com|Copyright (c) 2000-2008|SuperWaba Ltda|Phone: +55 21 2239-6695|Rio de Janeiro - Brazil").popupModal();
                            break block1;
                        }
                    }
                }
            }
        }
    }

    public void onExit() {
        if (this.mbar == null) {
            return;
        }
        Settings.appSettings = !this.miAudibleGC.isChecked && !this.miDumpMem.isChecked && !this.miCheckLeak.isChecked && !this.miPrintStack.isChecked && !this.miDebug2NVFS.isChecked ? null : String.valueOf(this.miAudibleGC.isChecked ? "1" : "0") + (this.miDumpMem.isChecked ? "1" : "0") + (this.miCheckLeak.isChecked ? "1" : "0") + (this.miPrintStack.isChecked ? "1" : "0") + (this.miDebug2NVFS.isChecked ? "1" : "0");
    }

    public void onStart() {
        this.miReadNVFS = new MenuItem("Read NVFS memo");
        MenuItem[] fileMenu = new MenuItem[]{new MenuItem("File"), this.miReadNVFS, new MenuItem(), new MenuItem("Exit")};
        this.miAudibleGC = new MenuItem("Audible GC", false);
        this.miDumpMem = new MenuItem("Dump Memory Stats", false);
        this.miCheckLeak = new MenuItem("Check memory leak", false);
        this.miPrintStack = new MenuItem("Print stack trace", false);
        this.miDebug2NVFS = new MenuItem("Debug to NVFS", false);
        MenuItem[] optionsMenu = new MenuItem[]{new MenuItem("VM"), this.miAudibleGC, this.miDumpMem, this.miCheckLeak, this.miPrintStack, this.miDebug2NVFS};
        MenuItem[] helpMenu = new MenuItem[]{new MenuItem("?"), new MenuItem("About")};
        this.miReadNVFS.isEnabled = this.miDebug2NVFS.isEnabled = Settings.platform.equals("PalmOS/SDL");
        this.mbar = new MenuBar(new MenuItem[][]{fileMenu, optionsMenu, helpMenu});
        this.setMenuBar(this.mbar);
        if (Settings.isColor) {
            this.mbar.setBackForeColors(Color.BLUE, Color.WHITE);
            this.mbar.setCursorColor(Color.getColor(100, 100, 255));
            this.mbar.setBorderStyle((byte)0);
            this.mbar.setPopColors(Color.getColor(0, 120, 255), Color.CYAN, null);
        }
        Label l = new Label("SuperWaba Virtual Machine");
        l.setInvert(true);
        l.setFont(Font.getFont(this.font.name, true, 14));
        this.add(l, 120000, 140020);
        this.add(new Label("Version " + Settings.versionStr + " for " + Settings.platform), 120000, 190003);
        if (Settings.deviceId != null) {
            this.add(new Label("Running on " + Settings.deviceId), 120000, 190003);
        }
        this.add(new Label("Virtual Machine installed and ready"), 120000, 120015);
        this.add(new Label("SuperWaba Ltda"), 120000, 150000);
        if (Settings.appSettings != null) {
            if (Settings.appSettings.length() == 2) {
                Settings.appSettings = String.valueOf(Settings.appSettings) + "000";
            }
            if (Settings.appSettings.length() == 3) {
                Settings.appSettings = String.valueOf(Settings.appSettings) + "00";
            }
            if (Settings.appSettings.length() == 5) {
                this.miAudibleGC.isChecked = Settings.appSettings.charAt(0) == '1';
                this.miDumpMem.isChecked = Settings.appSettings.charAt(1) == '1';
                this.miCheckLeak.isChecked = Settings.appSettings.charAt(2) == '1';
                this.miPrintStack.isChecked = Settings.appSettings.charAt(3) == '1';
                this.miDebug2NVFS.isChecked = Settings.appSettings.charAt(4) == '1';
            }
        }
    }

    class View
    extends Window {
        private Button btnBack;
        private Button btnDelete;

        public View(File f) {
            super("Debug console", (byte)1);
            byte[] buf = new byte[f.getSize()];
            f.readBytes(buf, 0, buf.length);
            f.close();
            Object[] lines = Convert.tokenizeString(new String(buf), '\n');
            this.setBackColor(Color.CYAN);
            this.dontSaveBehind(true);
            this.makeUnmovable();
            this.setRect(120000, 120000, Settings.screenWidth - 6, Settings.screenHeight - 6);
            this.btnBack = new Button("Back");
            this.add(this.btnBack, 130000, 150000);
            this.btnBack.setBackColor(Color.GREEN);
            this.btnDelete = new Button("DELETE");
            this.add(this.btnDelete, 169990, 150000);
            this.btnDelete.setBackColor(Color.RED);
            ListBox lb = new ListBox();
            this.add(lb);
            lb.enableHorizScroll();
            lb.setRect(110000, 140000, 160000, 200000, this.btnBack);
            lb.add(lines);
        }

        public void onEvent(Event e) {
            switch (e.type) {
                case 300: {
                    if (e.target == this.btnBack) {
                        this.unpop();
                        break;
                    }
                    if (e.target != this.btnDelete) break;
                    Vm.debug(Vm.ERASE_DEBUG);
                    this.unpop();
                }
            }
        }
    }
}

