/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Settings;
import waba.util.ElementNotFoundError;
import waba.util.Vector;

public class Hashtable {
    private Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    public int collisions;
    private static final int GET_KEYS = 0;
    private static final int GET_VALUES = 1;
    private static final int GET_BOTH = 2;

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0) {
            initialCapacity = 5;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public Hashtable(String res) {
        this(1023, 0.75f);
        String[] items = Convert.tokenizeString(res, '\n');
        int i = 0;
        while (i < items.length) {
            String s = items[i];
            int eq = s.indexOf(61, 0);
            if (eq >= 0) {
                this.put(s.substring(0, eq).trim(), s.substring(eq + 1).trim());
            }
            ++i;
        }
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public boolean exists(Object key) {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int hash) throws ElementNotFoundError {
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash) {
                return e.value;
            }
            e = e.next;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Key hash not found: " + hash);
        }
        return null;
    }

    public Object get(Object key) throws ElementNotFoundError {
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Key not found: " + key);
        }
        return null;
    }

    public Vector getKeyValuePairs(String separator) {
        return this.getKeysValues(2, separator);
    }

    public Vector getKeys() {
        return this.getKeysValues(0, null);
    }

    private Vector getKeysValues(int getType, String sep) {
        Object[] v = new Object[this.count];
        if (this.table != null) {
            int n = 0;
            int len = this.table.length;
            int i = 0;
            while (i < len) {
                Entry entry = this.table[i];
                while (entry != null) {
                    v[n++] = getType == 0 ? entry.key : (getType == 1 ? entry.value : String.valueOf(String.valueOf(entry.key)) + sep + entry.value);
                    entry = entry.next;
                }
                ++i;
            }
        }
        return new Vector(v);
    }

    public Vector getValues() {
        return this.getKeysValues(1, null);
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        Entry e2 = new Entry();
        e2.hash = hash;
        e2.key = key;
        e2.value = value;
        e2.next = tab[index];
        if (e2.next != null) {
            ++this.collisions;
        }
        tab[index] = e2;
        ++this.count;
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = ((oldCapacity << 1) + oldCapacity >> 1) + 1;
        if (Settings.onDevice) {
            if (oldCapacity == 16382) {
                newCapacity = 20000;
            } else if (newCapacity > 16382) {
                newCapacity = 16382;
            }
        }
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object remove(Object key) throws ElementNotFoundError {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Key not found: " + key);
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private static class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry() {
        }
    }
}

