/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.io.DataStream;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.util.ElementNotFoundError;

public class IntVector {
    public static final int INVALID = Integer.MIN_VALUE;
    public int[] items;
    protected int count;

    public IntVector() {
        this(20);
    }

    public IntVector(int size) {
        this.items = new int[size];
    }

    public IntVector(DataStream in) {
        this.count = in.readUnsignedShort();
        this.items = new int[this.count + 5];
        int i = 0;
        while (i < this.count) {
            this.items[i] = in.readInt();
            ++i;
        }
    }

    public IntVector(int[] items) {
        this.items = items;
        this.count = items.length;
    }

    public void add(int obj) {
        this.addElement(obj);
    }

    public void addElement(int obj) {
        if (this.count < this.items.length) {
            this.items[this.count++] = obj;
        } else {
            this.insertElementAt(obj, this.count);
        }
    }

    public void clear() {
        this.removeAllElements();
    }

    public void del(int index) {
        this.removeElementAt(index);
    }

    public void ensureBit(int index) {
        int newCount = (index >> 5) + 1;
        if (newCount >= this.items.length) {
            if (this.count == 0) {
                this.items = new int[newCount];
            } else {
                int[] newItems = new int[newCount];
                Vm.copyArray(this.items, 0, newItems, 0, this.count);
                this.items = newItems;
            }
        }
        this.count = newCount;
    }

    public int find(int obj) {
        return this.indexOf(obj, 0);
    }

    public int find(int obj, int startIndex) {
        return this.indexOf(obj, startIndex);
    }

    public int getCount() {
        return this.count;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOf(int elem, int index) {
        int n = this.count;
        int i = index;
        while (i < n) {
            if (this.items[i] == elem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insert(int index, int obj) {
        this.insertElementAt(obj, index);
    }

    public void insertElementAt(int obj, int index) {
        if (index < 0 || index > this.count) {
            index = this.count;
        }
        if (this.count == this.items.length) {
            int newSize = this.items.length * 12 / 10 + 1;
            if (Settings.onDevice) {
                if (this.items.length == 16382) {
                    newSize = 20000;
                } else if (newSize > 16382) {
                    newSize = 16382;
                }
            }
            int[] newItems = new int[newSize];
            Vm.copyArray(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        if (index != this.count) {
            Vm.copyArray(this.items, index, this.items, index + 1, this.count - index);
        }
        this.items[index] = obj;
        ++this.count;
    }

    public boolean isBitSet(int index) {
        return (this.items[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public int peek() throws ElementNotFoundError {
        if (this.count > 0) {
            return this.items[this.count - 1];
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Empty stack");
        }
        return Integer.MIN_VALUE;
    }

    public int pop() throws ElementNotFoundError {
        if (this.count > 0) {
            return this.items[--this.count];
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Empty stack");
        }
        return Integer.MIN_VALUE;
    }

    public void pop(int howMany) {
        this.count -= howMany;
        if (this.count < 0) {
            this.count = 0;
        }
    }

    public void push(int obj) {
        this.addElement(obj);
    }

    public void qsort() {
        this.qsort(0, this.count - 1);
    }

    private void qsort(int first, int last) {
        int[] items = this.items;
        int low = first;
        int high = last;
        if (first >= last) {
            return;
        }
        int mid = items[first + last >> 1];
        while (true) {
            if (high >= low && items[low] < mid) {
                ++low;
                continue;
            }
            while (high >= low && items[high] > mid) {
                --high;
            }
            if (low > high) break;
            int temp = items[low];
            items[low++] = items[high];
            items[high--] = temp;
        }
        if (first < high) {
            this.qsort(first, high);
        }
        if (low < last) {
            this.qsort(low, last);
        }
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.count) {
            this.items[i] = 0;
            ++i;
        }
        this.count = 0;
    }

    public void removeElement(int obj) {
        this.removeElementAt(this.indexOf(obj, 0));
    }

    public void removeElementAt(int index) {
        if (index >= 0 && index < this.count) {
            if (index != this.count - 1) {
                Vm.copyArray(this.items, index + 1, this.items, index, this.count - index - 1);
            }
            this.items[this.count - 1] = 0;
            --this.count;
        }
    }

    public void setBit(int index, boolean on) {
        if (on) {
            int n = index >> 5;
            this.items[n] = this.items[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.items[n] = this.items[n] & ~(1 << (index & 0x1F));
        }
    }

    public int size() {
        return this.count;
    }

    public int[] toIntArray() {
        int[] a = new int[this.count];
        Vm.copyArray(this.items, 0, a, 0, this.count);
        return a;
    }

    public void writeTo(DataStream out) {
        out.writeShort(this.count);
        int i = 0;
        while (i < this.count) {
            out.writeInt(this.items[i]);
            ++i;
        }
    }
}

