/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.IOException;
import moio.util.Reader;

public class StringReader
extends Reader {
    private String buf;
    private int pos;
    private int markedPos;
    private int count;

    public StringReader(String string) {
        this.buf = string;
        this.count = string.length();
        this.pos = 0;
        this.markedPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.markedPos = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.count) {
                return this.buf.charAt(this.pos++) & 0xFFFF;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int n3 = Math.min(this.count, this.pos + n2);
            this.buf.getChars(this.pos, n3, cArray, n);
            int n4 = n3 - this.pos;
            this.pos = n3;
            return n4;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.pos = this.markedPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }
    }
}

