/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.AppSettings;
import bt747.model.Controller;
import bt747.model.Model;
import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.waba_view.ui.BT747MessageBox;
import moio.util.HashSet;
import net.sf.bt747.waba.system.WabaFile;
import waba.sys.Settings;

public final class AppController
extends Controller {
    private static String CONFIG_FILE_NAME = System.getProperty("bt747_settings", System.getProperty("user.home").length() != 0 ? System.getProperty("user.home") + System.getProperty("file.separator") + "SettingsBT747.pdb" : (Settings.platform.startsWith("Win32") || Settings.platform.startsWith("Windows") || Settings.platform.startsWith("Mac") || System.getProperty("os.name").startsWith("Mac") ? "SettingsBT747.pdb" : "/My Documents/SettingsBT747.pdb"));
    private Controller c;
    private Model m;
    private HashSet views = new HashSet();

    public AppController(Model model) {
        this.m = model;
        this.c = this;
        this.m.init();
        super.setModel(this.m);
        super.init();
    }

    public final void convertLog(int n) {
        if (this.doConvertLog(n) != 0) {
            this.reportError(this.c.getLastError(), this.c.getLastErrorInfo());
        }
    }

    public final void recoveryErase() {
        BT747MessageBox bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(97), new String[]{Txt.getString(92), Txt.getString(24)});
        bT747MessageBox.popupBlockingModal();
        if (bT747MessageBox.getPressedButtonIndex() == 0) {
            bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(98), new String[]{Txt.getString(24), Txt.getString(93)});
            bT747MessageBox.popupBlockingModal();
            if (bT747MessageBox.getPressedButtonIndex() == 1) {
                this.c.recoveryEraseLog();
            }
        }
    }

    public final void changeLogFormatAndErase(int n) {
        BT747MessageBox bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(95), new String[]{Txt.getString(92), Txt.getString(24)});
        bT747MessageBox.popupBlockingModal();
        if (bT747MessageBox.getPressedButtonIndex() == 0) {
            bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(96), new String[]{Txt.getString(24), Txt.getString(93)});
            bT747MessageBox.popupBlockingModal();
            if (bT747MessageBox.getPressedButtonIndex() == 1) {
                this.c.setLogFormat(n);
                this.c.eraseLog();
            }
        }
    }

    public final void changeLogFormat(int n) {
        BT747MessageBox bT747MessageBox = new BT747MessageBox(true, Txt.getString(20), Txt.getString(94), new String[]{Txt.getString(22), Txt.getString(24)});
        bT747MessageBox.popupBlockingModal();
        if (bT747MessageBox.getPressedButtonIndex() == 0) {
            this.c.setLogFormat(n);
        }
    }

    public final void eraseLogWithDialogs() {
        BT747MessageBox bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(97), new String[]{Txt.getString(92), Txt.getString(24)});
        bT747MessageBox.popupBlockingModal();
        if (bT747MessageBox.getPressedButtonIndex() == 0) {
            bT747MessageBox = new BT747MessageBox(Txt.getString(20), Txt.getString(98), new String[]{Txt.getString(24), Txt.getString(93)});
            bT747MessageBox.popupBlockingModal();
            if (bT747MessageBox.getPressedButtonIndex() == 1) {
                this.c.eraseLog();
            }
        }
    }

    private void reportError(int n, String string) {
        switch (n) {
            case -1: {
                String string2 = Txt.getString(138) + string;
                Generic.debug(string2, null);
                new BT747MessageBox(Txt.getString(136), string2).popupBlockingModal();
                break;
            }
            case -2: {
                new BT747MessageBox(Txt.getString(160), Txt.getString(161)).popupBlockingModal();
                break;
            }
            case -3: {
                new BT747MessageBox(Txt.getString(136), Txt.getString(137) + string).popupBlockingModal();
                break;
            }
        }
    }

    public final void performOperationsAfterGPSConnect() {
        if (this.m.isConnected()) {
            if (this.m.getBooleanOpt(8)) {
                this.c.setLoggingActive(false);
                this.c.setLoggingActive(false);
            }
            super.performOperationsAfterGPSConnect();
            this.saveSettings();
        }
    }

    private static final boolean isWin32LikeDevice() {
        return Settings.platform.startsWith("WindowsCE") || Settings.platform.startsWith("PocketPC") || Settings.platform.startsWith("Win32") && Settings.onDevice;
    }

    public static final void initAppSettings() {
        AppSettings.setDefaultChunkSize(Settings.onDevice ? 220 : 65536);
        AppSettings.setDefaultTraversable(Settings.onDevice && !Settings.platform.startsWith("Palm"));
        if (Settings.platform.startsWith("Palm")) {
            AppSettings.setDefaultBaseDirPath("/Palm");
        } else if (AppController.isWin32LikeDevice()) {
            if (WabaFile.getCardVolumePath() == null) {
                AppSettings.setDefaultBaseDirPath("/EnterYourDir");
            } else {
                AppSettings.setDefaultBaseDirPath(WabaFile.getCardVolumePath());
            }
        } else {
            AppSettings.setDefaultBaseDirPath("/BT747");
        }
        if (bt747.sys.Settings.getAppSettings() == null || bt747.sys.Settings.getAppSettings().length() < 100 || System.getProperty("bt747_settings") != null) {
            bt747.sys.Settings.setAppSettings(new String(new byte[2633]));
            if (AppController.isWin32LikeDevice() || System.getProperty("os.name").startsWith("Mac") || System.getProperty("bt747_settings") != null || System.getProperty("user.home").length() != 0) {
                int n = 0;
                File file = null;
                try {
                    file = new File(new BT747Path(CONFIG_FILE_NAME), 1);
                    n = file.getSize();
                    if (n >= 100) {
                        int n2 = Math.max(2633, n);
                        byte[] byArray = new byte[n2];
                        file.readBytes(byArray, 0, n);
                        bt747.sys.Settings.setAppSettings(new String(byArray));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (JavaLibBridge.toInt(System.getProperty("bt747_Mac_solvelag", System.getProperty("os.name").startsWith("Mac") ? "1" : "0")) == 1) {
            AppSettings.setSolveMacLagProblem(true);
        }
    }

    public final void saveSettings() {
        if (Generic.isDebug()) {
            Generic.debug("Platform " + Settings.platform, null);
            Generic.debug("os.name:" + System.getProperty("os.name"), null);
            Generic.debug("bt747_settings:" + System.getProperty("bt747_settings"), null);
            Generic.debug("Saving config file " + CONFIG_FILE_NAME, null);
            Generic.debug("If true: " + AppController.isWin32LikeDevice(), null);
        }
        if (AppController.isWin32LikeDevice() || System.getProperty("os.name").startsWith("Mac") || System.getProperty("bt747_settings") != null) {
            File file = null;
            BT747Path bT747Path = new BT747Path(CONFIG_FILE_NAME);
            try {
                File file2 = new File(bT747Path.proto(CONFIG_FILE_NAME.substring(0, CONFIG_FILE_NAME.lastIndexOf(47))), 0);
                if (!file2.exists()) {
                    file2.createDir();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                file = new File(bT747Path, 0);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                Generic.debug("Exception config delete", exception);
            }
            try {
                file = new File(bT747Path, 4);
                file.close();
                file = new File(bT747Path, 3);
                file.writeBytes(bt747.sys.Settings.getAppSettings().getBytes(), 0, bt747.sys.Settings.getAppSettings().length());
                file.close();
            }
            catch (Exception exception) {
                Generic.debug("Exception config create", exception);
            }
        }
    }
}

