/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.JavaLibBridge;
import bt747.waba_view.AppController;
import bt747.waba_view.MyCheck;
import waba.ui.Button;
import waba.ui.ComboBox;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.Label;

public final class GPSLogReason
extends Container
implements ModelListener {
    private final AppController c;
    private final Model m;
    private MyCheck chkTimeOnOff;
    private MyCheck chkDistanceOnOff;
    private MyCheck chkSpeedOnOff;
    private Edit edTime;
    private Edit edDistance;
    private Edit edSpeed;
    private Edit edFix;
    private Button btSet;
    private MyCheck chkSBASOnOff;
    private MyCheck chkSBASTestOnOff;
    private ComboBox cbDGPSMode;
    private static final String[] strDatumMode = new String[]{"WGS84", "TOKYO-M", "TOKYO-A"};
    private ComboBox cbDatumMode;

    public GPSLogReason(AppController appController, Model model) {
        this.c = appController;
        this.m = model;
    }

    protected final void onStart() {
        super.onStart();
        this.chkTimeOnOff = new MyCheck(Txt.getString(125));
        this.add((Control)this.chkTimeOnOff, 110000, 140000);
        this.edTime = new Edit();
        this.add((Control)this.edTime, 190000, 180000);
        this.chkSpeedOnOff = new MyCheck(Txt.getString(126));
        this.add((Control)this.chkSpeedOnOff, 110000, 190000);
        this.edSpeed = new Edit();
        this.add((Control)this.edSpeed, 190000, 180000);
        this.chkDistanceOnOff = new MyCheck(Txt.getString(127));
        this.add((Control)this.chkDistanceOnOff, 110000, 190000);
        this.edDistance = new Edit();
        this.add((Control)this.edDistance, 190000, 180000);
        this.edFix = new Edit();
        this.add((Control)this.edFix, 180000, 190000);
        this.add((Control)new Label(Txt.getString(128)), 170000, 180000);
        this.edSpeed.setValidChars("0123456789");
        this.edDistance.setValidChars("0123456789");
        this.edTime.setValidChars("0123456789.");
        this.chkSBASOnOff = new MyCheck("SBAS");
        this.add((Control)this.chkSBASOnOff, 110000, 190003);
        this.cbDGPSMode = new ComboBox();
        Object[] objectArray = new String[]{Txt.getString(122), Txt.getString(123), Txt.getString(124)};
        this.cbDGPSMode.add(objectArray);
        this.add((Control)this.cbDGPSMode, 190000, 180000);
        this.chkSBASTestOnOff = new MyCheck(Txt.getString(129));
        this.add((Control)this.chkSBASTestOnOff, 130000, 180000);
        this.cbDatumMode = new ComboBox();
        this.cbDatumMode.setEnabled(false);
        this.cbDatumMode.add((Object[])strDatumMode);
        this.add((Control)this.cbDatumMode, 110000, 190006);
        this.btSet = new Button(Txt.getString(58));
        this.add((Control)this.btSet, 120000, 190003);
    }

    public final void updateButtons() {
        this.chkTimeOnOff.setChecked(this.m.getLogTimeInterval() != 0);
        this.edTime.setEnabled(this.m.getLogTimeInterval() != 0);
        if (this.m.getLogTimeInterval() != 0) {
            this.edTime.setText(JavaLibBridge.toString((float)this.m.getLogTimeInterval() / 10.0f, 1));
        }
        this.chkSpeedOnOff.setChecked(this.m.getLogSpeedInterval() != 0);
        this.edSpeed.setEnabled(this.m.getLogSpeedInterval() != 0);
        if (this.m.getLogSpeedInterval() != 0) {
            this.edSpeed.setText("" + this.m.getLogSpeedInterval());
        }
        this.chkDistanceOnOff.setChecked(this.m.getLogDistanceInterval() != 0);
        this.edDistance.setEnabled(this.m.getLogDistanceInterval() != 0);
        if (this.m.getLogDistanceInterval() != 0) {
            this.edDistance.setText(JavaLibBridge.toString((float)this.m.getLogDistanceInterval() / 10.0f, 1));
        }
        this.edFix.setText("" + this.m.getLogFixPeriod());
        this.chkSBASOnOff.setChecked(this.m.isSBASEnabled());
        this.chkSBASTestOnOff.setChecked(this.m.isSBASTestEnabled());
        this.cbDGPSMode.select(this.m.getDgpsMode());
        this.cbDatumMode.select(this.m.getDatum());
    }

    public final void setSettings() {
        if (this.chkTimeOnOff.getChecked()) {
            this.c.setLogTimeInterval((int)(10.0f * JavaLibBridge.toFloat(this.edTime.getText())));
        } else {
            this.c.setLogTimeInterval(0);
        }
        if (this.chkSpeedOnOff.getChecked()) {
            this.c.setLogSpeedInterval(JavaLibBridge.toInt(this.edSpeed.getText()));
        } else {
            this.c.setLogSpeedInterval(0);
        }
        if (this.chkDistanceOnOff.getChecked()) {
            this.c.setLogDistanceInterval((int)(10.0f * JavaLibBridge.toFloat(this.edDistance.getText())));
        } else {
            this.c.setLogDistanceInterval(0);
        }
        this.c.setFixInterval(JavaLibBridge.toInt(this.edFix.getText()));
        this.c.setMtkDataNeeded(11);
        this.c.setMtkDataNeeded(12);
        this.c.setMtkDataNeeded(13);
    }

    public final void onEvent(Event event) {
        super.onEvent(event);
        switch (event.type) {
            case 300: {
                event.consumed = true;
                if (event.target == this.chkTimeOnOff) {
                    this.edTime.setEnabled(this.chkTimeOnOff.getChecked());
                    break;
                }
                if (event.target == this.chkSpeedOnOff) {
                    this.edSpeed.setEnabled(this.chkSpeedOnOff.getChecked());
                    break;
                }
                if (event.target == this.chkDistanceOnOff) {
                    this.edDistance.setEnabled(this.chkDistanceOnOff.getChecked());
                    break;
                }
                if (event.target == this.btSet) {
                    this.setSettings();
                    break;
                }
                if (event.target == this) {
                    this.c.setMtkDataNeeded(11);
                    this.c.setMtkDataNeeded(12);
                    this.c.setMtkDataNeeded(13);
                    this.c.setMtkDataNeeded(16);
                    this.c.setMtkDataNeeded(20);
                    this.c.setMtkDataNeeded(19);
                    this.c.setMtkDataNeeded(24);
                    break;
                }
                if (event.target == this.chkSBASOnOff) {
                    this.c.setSBASEnabled(this.chkSBASOnOff.getChecked());
                    break;
                }
                if (event.target == this.chkSBASTestOnOff) {
                    this.c.setSBASTestEnabled(this.chkSBASTestOnOff.getChecked());
                    break;
                }
                if (event.target == this.cbDGPSMode) {
                    this.c.setDGPSMode(this.cbDGPSMode.getSelectedIndex());
                    break;
                }
                event.consumed = false;
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        switch (modelEvent.getType()) {
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.updateButtons();
                break;
            }
        }
    }
}

