/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.Txt;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.waba_view.AppController;
import gps.BT747Constants;
import waba.ui.Button;
import waba.ui.ComboBox;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Label;

public final class GPSNMEAOutput
extends Container
implements ModelListener {
    private final ComboBox[] chkNMEAItems = new ComboBox[19];
    private static final String[] C_NMEA_PERIODS = new String[]{"0", "1", "2", "3", "4", "5"};
    private Button btSet;
    private Button btSetDefaults;
    private final Model m;
    private final AppController c;

    public GPSNMEAOutput(Model model, AppController appController) {
        this.m = model;
        this.c = appController;
    }

    protected final void onStart() {
        for (int i = 0; i < 19; ++i) {
            this.chkNMEAItems[i] = new ComboBox((Object[])C_NMEA_PERIODS);
            this.add((Control)this.chkNMEAItems[i]);
            this.chkNMEAItems[i].setRect(i < 10 ? 110000 : this.getClientRect().width / 2, i == 0 || i == 10 ? 140000 : 189999, 100000, 99999);
            this.add((Control)new Label(BT747Constants.getNmeaDescription(i)), 190000, 180000);
        }
        this.btSet = new Button(Txt.getString(58));
        this.add((Control)this.btSet, this.getClientRect().width / 2, 190000);
        this.btSetDefaults = new Button(Txt.getString(131));
        this.add((Control)this.btSetDefaults, 190000, 180000);
    }

    private final void updatePeriods() {
        for (int i = 0; i < 19; ++i) {
            this.chkNMEAItems[i].select(this.m.getNMEAPeriod(i));
        }
    }

    private void setPeriods() {
        int[] nArray = new int[19];
        for (int i = 0; i < 19; ++i) {
            nArray[i] = this.chkNMEAItems[i].getSelectedIndex();
        }
        this.c.setNMEAPeriods(nArray);
    }

    public final void onEvent(Event event) {
        switch (event.type) {
            case 300: {
                if (event.target == this) {
                    this.c.setMtkDataNeeded(23);
                    event.consumed = true;
                    break;
                }
                if (event.target == this.btSet) {
                    this.setPeriods();
                    event.consumed = true;
                    break;
                }
                if (event.target != this.btSetDefaults) break;
                this.c.setNMEADefaultPeriods();
                event.consumed = true;
                break;
            }
        }
    }

    public final void modelEvent(ModelEvent modelEvent) {
        int n = modelEvent.getType();
        if (n == 15) {
            this.updatePeriods();
        }
    }
}

