/*
 * Decompiled with CFR 0.152.
 */
package bt747.waba_view;

import bt747.sys.Generic;
import gps.connection.GPSPort;
import waba.io.SerialPort;
import waba.ui.MessageBox;

public final class GPSWabaPort
extends GPSPort {
    private SerialPort sp = null;
    private boolean portIsOK = false;

    public final boolean isConnected() {
        return this.sp != null && this.sp.isOpen();
    }

    public final void closePort() {
        if (this.sp != null && this.sp.isOpen()) {
            this.portIsOK = false;
            this.sp.close();
        }
    }

    public final int openPort() {
        int n = -1;
        this.closePort();
        try {
            Generic.debug("opening " + this.spPortNbr + "@" + this.spSpeed, null);
            this.sp = new SerialPort(this.spPortNbr, this.spSpeed);
            n = this.sp.lastError;
            Generic.debug(this.sp.getStatus(), null);
            this.portIsOK = this.sp.isOpen();
            if (this.portIsOK) {
                this.sp.setReadTimeout(0);
            } else {
                this.sp = null;
            }
        }
        catch (Exception exception) {
            new MessageBox("waba.io.SerialPort open", "Unexpected exception catched").popupBlockingModal();
            this.sp = null;
        }
        return n;
    }

    public final void setBlueTooth() {
        this.spPortNbr = 4099;
    }

    public final void setUSB() {
        this.spPortNbr = 4098;
    }

    public final void write(byte[] byArray) {
        this.sp.writeBytes(byArray, 0, byArray.length);
        if (this.debugFile != null) {
            try {
                this.debugFile.writeBytes("W:".getBytes(), 0, 2);
                this.debugFile.writeBytes(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void write(String string) {
        this.write(string.getBytes());
    }

    public final int readCheck() {
        if (this.sp != null) {
            return this.sp.readCheck();
        }
        return -1;
    }

    public final int readBytes(byte[] byArray, int n, int n2) {
        return this.sp.readBytes(byArray, n, n2);
    }
}

