/*
 * Decompiled with CFR 0.152.
 */
package gps.connection;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Path;

public abstract class GPSPort {
    protected int spPortNbr;
    protected int spSpeed = 115200;
    protected File debugFile = null;
    protected BT747Path debugFileName = new BT747Path("/Palm/gpsRAW.txt");
    public static String os_name = "unknown";
    protected int portType = 0;
    private final String BLUETOOTH_TEXT = "BLUETOOTH";
    private final String USB_TEXT = "USB";
    private final String PORTNBR_TEXT = "";
    private String freeTextPort = "";

    public boolean isConnected() {
        return false;
    }

    public void setPort(int n) {
        this.spPortNbr = n;
        this.portType = 3;
    }

    public int openPort() {
        return -1;
    }

    public void closePort() {
    }

    public void setBlueTooth() {
        this.portType = 1;
    }

    public void setUSB() {
        this.portType = 0;
    }

    public void setFreeTextPort(String string) {
        this.freeTextPort = string;
    }

    public String getFreeTextPort() {
        switch (this.portType) {
            case 0: {
                return "USB";
            }
            case 3: {
                return "";
            }
            case 1: {
                return "BLUETOOTH";
            }
        }
        return this.freeTextPort;
    }

    public final void setSpeed(int n) {
        this.spSpeed = n;
    }

    public final int getSpeed() {
        return this.spSpeed;
    }

    public final int getPort() {
        return this.spPortNbr;
    }

    public abstract void write(String var1);

    public abstract void write(byte[] var1);

    public void writeDebug(String string) {
        if (this.debugFile != null) {
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            try {
                this.debugFile.writeBytes(byArray, 0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void writeDebug(byte[] byArray, int n, int n2) {
        if (this.debugActive()) {
            try {
                this.debugFile.writeBytes(byArray, n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int readCheck() {
        return -1;
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        return -1;
    }

    public final boolean debugActive() {
        return this.debugFile != null;
    }

    public final void startDebug() {
        if (this.debugFile == null) {
            try {
                new File(this.debugFileName).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                File file = new File(this.debugFileName, 4);
                file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.debugFile = new File(this.debugFileName, 3);
            }
            catch (Exception exception) {
                Generic.debug(this.debugFileName.toString(), exception);
            }
        }
    }

    public final void endDebug() {
        if (this.debugFile != null) {
            try {
                this.debugFile.close();
            }
            catch (Exception exception) {
                Generic.debug(this.debugFileName.toString(), exception);
            }
            this.debugFile = null;
        }
    }

    public final void setDebugFileName(String string) {
        this.debugFileName = new BT747Path(string);
    }
}

