/*
 * Decompiled with CFR 0.152.
 */
package gps.connection;

import bt747.sys.Generic;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gps.connection.GPSPort;
import gps.connection.SerialUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public final class GPSRxTxPort
extends GPSPort {
    private CommPort sp = null;
    private OutputStream ds = null;
    private InputStream in = null;
    private String portPrefix = "";
    public static final String os_name = System.getProperty("os.name");
    public static boolean dubiousTried = false;
    private static final String[] macPortPrefixes = new String[]{"/dev/tty.HOLUX_M-241-SPPSlave", "/dev/tty.HoluxM-1000C-SPPslave", "/dev/tty.HOLUX_M-1200E-SPPslave", "/dev/cu.MIPPERGPS-SPPslave", "/dev/tty.iBT-GPS-SPPSlave", "/dev/tty.iBT-GPS-SPPslave", "/dev/cu.QstarzGPS-SPPslave", "/dev/tty.QstarzGPS-SPPslave", "/dev/tty.Qstarz1000XT-SPPslave", "/dev/tty.BlumaxBT-GPS-SPPSlave", "/dev/tty.iBTAGS-SPPslave"};
    private static final String[] possibleUsbPorts = new String[]{"/dev/cu.usbmodemfd110", "/dev/tty.usbmodemfd110", "/dev/tty.usbmodemfd510", "/dev/tty.usbserial"};
    private static final String[] linUsbPortPrefixes = new String[]{"/dev/ttyUSB", "/dev/ttyACM"};

    public GPSRxTxPort() {
        this.portType = 3;
        if (os_name.startsWith("Windows")) {
            this.portPrefix = "COM";
            dubiousTried = true;
        } else if (os_name.startsWith("Linux")) {
            this.portPrefix = "/dev/ttyUSB";
        } else if (os_name.startsWith("Mac")) {
            dubiousTried = true;
            this.setUSB();
            if (this.getFreeTextPort().length() == 0) {
                this.setBlueTooth();
            }
            this.portPrefix = "/dev/cu.SLAB_USBtoUART";
        }
        this.portPrefix = System.getProperty("bt747_prefix", this.portPrefix);
    }

    public final synchronized boolean isConnected() {
        return this.ds != null;
    }

    public final synchronized void closePort() {
        if (this.ds != null) {
            try {
                this.in.close();
                this.in = null;
            }
            catch (Exception exception) {
                Generic.debug("", exception);
            }
            try {
                this.ds.close();
                this.ds = null;
            }
            catch (Exception exception) {
                Generic.debug("", exception);
            }
            try {
                if (this.sp != null) {
                    this.sp.close();
                    this.sp = null;
                }
            }
            catch (Exception exception) {
                Generic.debug("", exception);
            }
        }
    }

    private final void openDubiousPortAsWorkaroundOnLinux() {
        if (!dubiousTried) {
            dubiousTried = true;
            try {
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)"/dev/dubiousport");
                CommPort commPort = commPortIdentifier.open("BT747 2.1.7 " + this.getClass().getName(), 2000);
                commPort.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final synchronized int openPort() {
        int n;
        block32: {
            String string;
            n = -1;
            this.closePort();
            switch (this.portType) {
                case 0: {
                    string = this.getUsbPort();
                    break;
                }
                case 1: {
                    string = this.getBluetoothPort();
                    break;
                }
                default: {
                    string = System.getProperty("bt747_port", this.portType == 3 ? this.portPrefix + this.spPortNbr : "");
                    break;
                }
                case 2: {
                    string = this.getFreeTextPort();
                }
            }
            this.openDubiousPortAsWorkaroundOnLinux();
            try {
                if (Generic.isDebug()) {
                    Generic.debug("Info: trying to open '" + string + "'", null);
                }
                Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
                CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string);
                CommPort commPort = commPortIdentifier.open("BT747 2.1.7 " + this.getClass().getName(), 2000);
                if (Generic.isDebug()) {
                    Generic.debug("Info: Opened port, setting parameters", null);
                }
                if (commPort instanceof SerialPort) {
                    SerialPort serialPort = (SerialPort)commPort;
                    this.sp = serialPort;
                    this.in = this.sp.getInputStream();
                    this.ds = this.sp.getOutputStream();
                    int n2 = this.getSpeed();
                    int n3 = 1;
                    boolean bl = false;
                    try {
                        serialPort.setSerialPortParams(n2, 8, n3, 0);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Generic.debug("Issue when setting parameters:" + n2 + " " + 8 + " " + n3 + " " + 0, throwable);
                    }
                    if (!bl) {
                        n3 = 2;
                        Generic.debug("Trying stopbits = " + n3, null);
                        try {
                            serialPort.setSerialPortParams(n2, 8, n3, 0);
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            Generic.debug("Issue when setting parameters:" + n2 + " " + 8 + " " + n3 + " " + 0, throwable);
                        }
                    }
                    if (Generic.isDebug()) {
                        String string2 = "N/A";
                        try {
                            string2 = serialPort.getUARTType();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        Generic.debug("Information about the opened port: Name:" + serialPort.getName() + " Baud:" + serialPort.getBaudRate() + " StopBits:" + serialPort.getStopBits() + " DataBits:" + serialPort.getDataBits() + " Uart type:" + string2 + " Internal:" + serialPort.toString());
                    }
                    n = 0;
                    break block32;
                }
                this.sp = null;
                this.in = null;
                this.ds = null;
                System.out.println("Error: Only serial ports are handled.");
            }
            catch (NoSuchPortException noSuchPortException) {
                Generic.debug("No Such Port", noSuchPortException);
                Generic.debug("\nListing known ports:");
                try {
                    Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
                    while (enumeration.hasMoreElements()) {
                        String string3;
                        CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                        switch (commPortIdentifier.getPortType()) {
                            case 1: {
                                string3 = "SER  :";
                                break;
                            }
                            case 2: {
                                string3 = "PAR  :";
                                break;
                            }
                            case 3: {
                                string3 = "I2C  :";
                                break;
                            }
                            case 4: {
                                string3 = "RS485:";
                                break;
                            }
                            case 5: {
                                string3 = "RAW  :";
                                break;
                            }
                            default: {
                                string3 = "UNK  :";
                            }
                        }
                        Generic.debug(string3 + commPortIdentifier.getName());
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (PortInUseException portInUseException) {
                Generic.debug("Error: Port " + string + "is currently in use", portInUseException);
            }
            catch (IOException iOException) {
                Generic.debug("Error: IO", iOException);
            }
            catch (Throwable throwable) {
                Generic.debug("Unexpected error", throwable);
            }
        }
        if (Generic.isDebug()) {
            Generic.debug("Port open result (0=open):" + n);
        }
        return n;
    }

    private final boolean isValidPort(String string) {
        boolean bl = false;
        int n = -1;
        try {
            bl = new File(string).exists() && (n = CommPortIdentifier.getPortIdentifier((String)string).getPortType()) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Generic.isDebug()) {
            Generic.debug("isValidPort('" + string + "')?: " + bl + " " + n);
        }
        return bl;
    }

    public final synchronized void setBlueTooth() {
        super.setBlueTooth();
        this.portType = 1;
    }

    private final synchronized String getBluetoothPort() {
        String string = null;
        if (os_name.toLowerCase().startsWith("mac")) {
            string = this.getPortFromPrefixes(macPortPrefixes, 3, "-");
        }
        return string;
    }

    private final synchronized String getPortFromPrefixes(String[] stringArray, int n, String string) {
        String string2 = null;
        for (int i = 0; string2 == null && i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i];
            if (string != null && this.isValidPort(string3 = string4)) {
                string2 = string3;
            }
            for (int j = 0; string2 == null && j < n; ++j) {
                String string5 = string4 + (string != null ? string : "") + j;
                if (!this.isValidPort(string5)) continue;
                string2 = string5;
            }
        }
        return string2;
    }

    public final void setUSB() {
        this.portType = 0;
    }

    public final synchronized String getUsbPort() {
        String[] stringArray;
        boolean bl = false;
        String string = null;
        if (!bl && os_name.startsWith("Windows") && (stringArray = SerialUtils.getSerialPorts()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                bl = true;
            }
        }
        if (!bl) {
            string = "/dev/cu.serial-0001";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.SLAB_USBtoUART";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.iBTAGPS-SPPslave";
            bl = this.isValidPort(string);
        }
        if (!bl && os_name.toLowerCase().startsWith("lin")) {
            string = this.getPortFromPrefixes(linUsbPortPrefixes, 6, null);
            boolean bl2 = bl = string != null;
        }
        if (!bl) {
            string = "/dev/cu.usbmodem1b10";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.usbmodem1d10";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.usbmodem3d10";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.usbmodem3a20";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = "/dev/cu.usbmodem620";
            bl = this.isValidPort(string);
        }
        if (!bl) {
            string = this.getPortFromPrefixes(possibleUsbPorts, -1, "");
            boolean bl3 = bl = string != null;
        }
        if (!bl) {
            string = null;
        }
        return string;
    }

    public final synchronized void setFreeTextPort(String string) {
        if (string != null && string.length() != 0) {
            this.portType = 2;
        }
        super.setFreeTextPort(string);
    }

    public final synchronized String getFreeTextPort() {
        return super.getFreeTextPort();
    }

    public final synchronized void write(byte[] byArray) {
        try {
            if (this.ds != null) {
                this.ds.write(byArray);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        if (this.debugFile != null) {
            try {
                this.debugFile.writeBytes("\nWrite:".getBytes(), 0, 2);
                this.debugFile.writeBytes(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                Generic.debug("", exception);
            }
        }
    }

    public final void write(String string) {
        this.write(string.getBytes());
    }

    public final synchronized int readCheck() {
        if (this.isConnected() && this.in != null) {
            try {
                return this.in.available();
            }
            catch (IOException iOException) {
                Generic.debug("readCheck", iOException);
                this.closePort();
                return 0;
            }
            catch (Exception exception) {
                Generic.debug("", exception);
                return 0;
            }
        }
        return 0;
    }

    public final synchronized int readBytes(byte[] byArray, int n, int n2) {
        try {
            return this.in.read(byArray, n, n2);
        }
        catch (Exception exception) {
            Generic.debug("", exception);
            return 0;
        }
    }
}

