/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747StringTokenizer;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class CSVLogConvert
extends GPSLogConvertInterface {
    private static final String[] MONTHS_AS_TEXT = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private GPSRecord logFormatRecord;
    private GPSRecord activeFileFieldsRecord;
    protected boolean passToFindFieldsActivatedInLog = false;
    private int previousIdx = 0;
    private int error;

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        WindowedFile windowedFile = (WindowedFile)object;
        GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
        boolean bl = true;
        int[] nArray = new int[30];
        try {
            int n;
            nArray[0] = -1;
            int n2 = 0;
            this.logFormatRecord = GPSRecord.getLogFormatRecord(0);
            int n3 = 0;
            try {
                n = windowedFile.getSize();
            }
            catch (Exception exception) {
                Generic.debug("getSize", exception);
                n = 0;
            }
            while (!this.stop && n3 < n) {
                byte[] byArray;
                int n4 = 2048;
                if (n4 + n3 > n) {
                    n4 = n - n3;
                }
                boolean bl2 = true;
                int n5 = 0;
                try {
                    byArray = windowedFile.fillBuffer(n3);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = windowedFile.getPath() + "|" + windowedFile.getLastError();
                    return -3;
                }
                n3 += n4;
                do {
                    int n6;
                    int n7;
                    for (n7 = n5; n7 < n4 && byArray[n7] != 10 && byArray[n7] != 13; ++n7) {
                    }
                    boolean bl3 = bl2 = n7 < n4;
                    if (!bl2) continue;
                    StringBuffer stringBuffer = new StringBuffer(n7 - n5 + 1);
                    for (int i = n5; i < n7; ++i) {
                        stringBuffer.append((char)byArray[i]);
                    }
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(stringBuffer.toString(), ',');
                    for (n5 = n7; n5 < n4 && (byArray[n5] == 10 || byArray[n5] == 13); ++n5) {
                    }
                    if (stringBuffer.length() == 0) continue;
                    if (bl) {
                        bl = false;
                        n6 = 0;
                        this.activeFileFieldsRecord = GPSRecord.getLogFormatRecord(0);
                        for (int i = 0; bT747StringTokenizer.hasMoreTokens() && i < 30; ++i) {
                            String string = bT747StringTokenizer.nextToken();
                            if (string.equals("INDEX")) {
                                nArray[i] = -4;
                            } else if (string.equals("RCR") || string.equals("TAG")) {
                                nArray[i] = 17;
                                n6 |= 0x20000;
                            } else if (string.equals("TIME")) {
                                nArray[i] = -2;
                                n6 |= 1;
                            } else if (string.equals("DATE")) {
                                nArray[i] = -3;
                                n6 |= 1;
                            } else if (string.equals("FIX MODE")) {
                                nArray[i] = -13;
                                n6 |= 2;
                            } else if (string.equals("VALID")) {
                                nArray[i] = 1;
                                n6 |= 2;
                            } else if (string.equals("LATITUDE")) {
                                nArray[i] = 2;
                                n6 |= 4;
                            } else if (string.equals("N/S")) {
                                nArray[i] = -6;
                            } else if (string.equals("LONGITUDE")) {
                                nArray[i] = 3;
                                n6 |= 8;
                            } else if (string.equals("E/W")) {
                                nArray[i] = -5;
                            } else if (string.startsWith("HEIGHT(ft)")) {
                                nArray[i] = 104;
                                n6 |= 0x10;
                            } else if (string.startsWith("HEIGHT")) {
                                nArray[i] = 4;
                                n6 |= 0x10;
                            } else if (string.startsWith("SPEED(mph)")) {
                                nArray[i] = 105;
                                n6 |= 0x20;
                            } else if (string.startsWith("SPEED")) {
                                nArray[i] = 5;
                                n6 |= 0x20;
                            } else if (string.equals("HEADING")) {
                                nArray[i] = 6;
                                n6 |= 0x40;
                            } else if (string.equals("DSTA")) {
                                nArray[i] = 7;
                                n6 |= 0x80;
                            } else if (string.equals("DAGE")) {
                                nArray[i] = 8;
                                n6 |= 0x100;
                            } else if (string.equals("PDOP")) {
                                nArray[i] = 9;
                                n6 |= 0x200;
                            } else if (string.equals("HDOP")) {
                                nArray[i] = 10;
                                n6 |= 0x400;
                            } else if (string.equals("VDOP")) {
                                nArray[i] = 11;
                                n6 |= 0x800;
                            } else if (string.equals("NSAT (USED/VIEW)")) {
                                nArray[i] = 12;
                                n6 |= 0x1000;
                            } else if (string.startsWith("DISTANCE(ft)")) {
                                nArray[i] = 119;
                                n6 |= 0x80000;
                            } else if (string.startsWith("DISTANCE")) {
                                nArray[i] = 19;
                                n6 |= 0x80000;
                            } else if (string.startsWith("SAT INFO (SID")) {
                                nArray[i] = 13;
                                n6 |= 0x2000;
                                if (string.indexOf("-ELE", 12) != -1) {
                                    n6 |= 0x4000;
                                }
                                if (string.indexOf("-AZI", 12) != -1) {
                                    n6 |= 0x8000;
                                }
                                if (string.indexOf("-SNR", 12) != -1) {
                                    n6 |= 0x10000;
                                }
                            } else if (string.equals("LATITUDE N/S")) {
                                nArray[i] = -10;
                                n6 |= 4;
                            } else if (string.equals("LONGITUDE E/W")) {
                                nArray[i] = -11;
                                n6 |= 8;
                            } else if (string.startsWith("LOGTIME")) {
                                nArray[i] = -9;
                                this.activeFileFieldsRecord.logPeriod = 1;
                            } else if (string.startsWith("LOGDIST")) {
                                nArray[i] = -8;
                                this.activeFileFieldsRecord.logDistance = 1;
                            } else if (string.startsWith("LOGSPD")) {
                                nArray[i] = -7;
                                this.activeFileFieldsRecord.logSpeed = 1;
                            } else if (string.equals("VOX")) {
                                nArray[i] = -12;
                                this.activeFileFieldsRecord.voxStr = "";
                            } else {
                                nArray[i] = -100;
                            }
                            nArray[i + 1] = -1;
                        }
                        this.activeFileFieldsRecord.cloneActiveFields(GPSRecord.getLogFormatRecord(n6));
                        if (!this.passToFindFieldsActivatedInLog) continue;
                        return 0;
                    }
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                    gPSRecord.recCount = ++n2;
                    for (n6 = 0; bT747StringTokenizer.hasMoreTokens() && n6 < 30 && nArray[n6] != -1; ++n6) {
                        String string = bT747StringTokenizer.nextToken().trim();
                        if (string.length() == 0) continue;
                        int n8 = nArray[n6];
                        n2 = this.readField(n8, string, gPSRecord, n2);
                    }
                    this.updateLogFormat(gPSFileConverterInterface, gPSRecord);
                    CommonIn.adjustHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                    if (gPSRecord.rcr == 0) {
                        gPSRecord.rcr = 1;
                    }
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                } while (bl2);
                if (n5 != 0) {
                    n3 -= n4 - n5;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Generic.debug("parseFile", exception);
        }
        return 0;
    }

    private final int readField(int n, String string, GPSRecord gPSRecord, int n2) {
        try {
            switch (n) {
                case -9: {
                    gPSRecord.logPeriod = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -8: {
                    gPSRecord.logDistance = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -7: {
                    gPSRecord.logSpeed = (int)(JavaLibBridge.toFloat(string) * 10.0f);
                    break;
                }
                case -6: {
                    if (string.equals("N")) {
                        gPSRecord.latitude = Math.abs(gPSRecord.latitude);
                        break;
                    }
                    if (!string.equals("S")) break;
                    gPSRecord.latitude = -Math.abs(gPSRecord.latitude);
                    break;
                }
                case -5: {
                    if (string.equals("E")) {
                        gPSRecord.longitude = Math.abs(gPSRecord.longitude);
                        break;
                    }
                    if (!string.equals("W")) break;
                    gPSRecord.longitude = -Math.abs(gPSRecord.longitude);
                    break;
                }
                case -4: {
                    n2 = gPSRecord.recCount = JavaLibBridge.toInt(string);
                    break;
                }
                case -3: {
                    if (string.length() == 10) {
                        byte by = string.indexOf(47) == 4 ? (byte)1 : 2;
                        int n3 = JavaLibBridge.getDateInstance(string, by).dateToUTCepoch1970();
                        gPSRecord.utc += n3;
                        break;
                    }
                    if (string.length() == 9) {
                        int n4;
                        if (string.charAt(2) != '-' || string.charAt(6) != '-') break;
                        int n5 = JavaLibBridge.toInt(string.substring(0, 2));
                        int n6 = JavaLibBridge.toInt(string.substring(7, 9)) + 2000;
                        String string2 = string.substring(3, 6);
                        if (string2.equals(MONTHS_AS_TEXT[this.previousIdx])) {
                            n4 = this.previousIdx;
                        } else {
                            for (n4 = 0; n4 < MONTHS_AS_TEXT.length && !string2.equals(string2); ++n4) {
                            }
                        }
                        if (n4 < MONTHS_AS_TEXT.length) {
                            gPSRecord.utc += JavaLibBridge.getDateInstance(n5, n4 + 1, n6).dateToUTCepoch1970();
                        }
                        break;
                    }
                    if (string.length() != 6) break;
                    int n7 = JavaLibBridge.toInt(string.substring(0, 2)) + 2000;
                    int n8 = JavaLibBridge.toInt(string.substring(2, 4));
                    int n9 = JavaLibBridge.toInt(string.substring(4, 6));
                    gPSRecord.utc += JavaLibBridge.getDateInstance(n9, n8, n7).dateToUTCepoch1970();
                    break;
                }
                case -2: {
                    BT747StringTokenizer bT747StringTokenizer;
                    if (string.length() == 6) {
                        int n10 = JavaLibBridge.toInt(string.substring(0, 2));
                        int n11 = JavaLibBridge.toInt(string.substring(2, 4));
                        int n12 = JavaLibBridge.toInt(string.substring(4, 6));
                        gPSRecord.utc += n12 + n11 * 60 + 3600 * n10;
                        break;
                    }
                    int n13 = string.indexOf(46);
                    if (n13 != -1) {
                        gPSRecord.milisecond = JavaLibBridge.toInt(string.substring(n13 + 1));
                        string = string.substring(0, n13);
                    }
                    if ((bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ':')).countTokens() == 3) {
                        gPSRecord.utc += JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) * 3600 + JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) * 60 + JavaLibBridge.toInt(bT747StringTokenizer.nextToken());
                    }
                    break;
                }
                case 1: {
                    if (string.equals("No fix")) {
                        gPSRecord.valid = 1;
                        break;
                    }
                    if (string.equals("SPS")) {
                        gPSRecord.valid = 2;
                        break;
                    }
                    if (string.equals("DGPS")) {
                        gPSRecord.valid = 4;
                        break;
                    }
                    if (string.equals("PPS")) {
                        gPSRecord.valid = 8;
                        break;
                    }
                    if (string.equals("RTK")) {
                        gPSRecord.valid = 16;
                        break;
                    }
                    if (string.equals("FRTK")) {
                        gPSRecord.valid = 32;
                        break;
                    }
                    if (string.equals("Estimated mode")) {
                        gPSRecord.valid = 64;
                        break;
                    }
                    if (string.equals("Manual input mode")) {
                        gPSRecord.valid = 128;
                        break;
                    }
                    if (!string.equals("Simulator mode")) break;
                    gPSRecord.valid = 256;
                    break;
                }
                case -10: {
                    String string3 = string.substring(0, string.length() - 1);
                    char c = string.charAt(string3.length());
                    gPSRecord.latitude = JavaLibBridge.toDouble(string3);
                    if (c == 'N' && gPSRecord.latitude < 0.0 || c == 'S' && gPSRecord.latitude > 0.0) {
                        gPSRecord.latitude = -gPSRecord.latitude;
                    }
                    break;
                }
                case -11: {
                    String string4 = string.substring(0, string.length() - 1);
                    char c = string.charAt(string4.length());
                    gPSRecord.longitude = JavaLibBridge.toDouble(string4);
                    if (c == 'E' && gPSRecord.longitude < 0.0 || c == 'W' && gPSRecord.longitude > 0.0) {
                        gPSRecord.longitude = -gPSRecord.longitude;
                    }
                    break;
                }
                case 2: {
                    gPSRecord.latitude = JavaLibBridge.toDouble(string);
                    break;
                }
                case 3: {
                    gPSRecord.longitude = JavaLibBridge.toDouble(string);
                    break;
                }
                case 4: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.height = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken());
                    break;
                }
                case 104: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.height = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken()) / 3.28084f;
                    break;
                }
                case 5: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.speed = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken());
                    break;
                }
                case 105: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.speed = JavaLibBridge.toFloat(bT747StringTokenizer.nextToken()) / 0.6213712f;
                    break;
                }
                case 6: {
                    gPSRecord.heading = JavaLibBridge.toFloat(string);
                    break;
                }
                case 7: {
                    gPSRecord.dsta = JavaLibBridge.toInt(string);
                    break;
                }
                case 8: {
                    gPSRecord.dage = JavaLibBridge.toInt(string);
                    break;
                }
                case 9: {
                    gPSRecord.pdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 10: {
                    gPSRecord.hdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 11: {
                    gPSRecord.vdop = (int)(JavaLibBridge.toFloat(string) * 100.0f);
                    break;
                }
                case 12: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, '(');
                    if (bT747StringTokenizer.countTokens() >= 2) {
                        gPSRecord.nsat = JavaLibBridge.toInt(bT747StringTokenizer.nextToken()) * 256;
                        String string5 = bT747StringTokenizer.nextToken();
                        string5 = string5.substring(0, string5.indexOf(41));
                        gPSRecord.nsat += JavaLibBridge.toInt(string5);
                    }
                    break;
                }
                case -13: {
                    break;
                }
                case 32: {
                    break;
                }
                case 13: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ';');
                    int n14 = bT747StringTokenizer.countTokens();
                    gPSRecord.sid = new int[n14];
                    gPSRecord.sidinuse = new boolean[n14];
                    gPSRecord.ele = new int[n14];
                    gPSRecord.azi = new int[n14];
                    gPSRecord.snr = new int[n14];
                    for (int i = 0; i < n14; ++i) {
                        String string6 = bT747StringTokenizer.nextToken();
                        if (string6.length() == 0) continue;
                        gPSRecord.sidinuse[i] = string6.charAt(0) == '#';
                        BT747StringTokenizer bT747StringTokenizer2 = JavaLibBridge.getStringTokenizerInstance(string6.substring(gPSRecord.sidinuse[i] ? 1 : 0), '-');
                        if (bT747StringTokenizer2.hasMoreTokens()) {
                            gPSRecord.sid[i] = JavaLibBridge.toInt(bT747StringTokenizer2.nextToken());
                        }
                        if (this.activeFileFieldsRecord.hasEle() && bT747StringTokenizer2.hasMoreTokens()) {
                            gPSRecord.ele[i] = JavaLibBridge.toInt(bT747StringTokenizer2.nextToken());
                        }
                        if (this.activeFileFieldsRecord.hasAzi() && bT747StringTokenizer2.hasMoreTokens()) {
                            gPSRecord.azi[i] = JavaLibBridge.toInt(bT747StringTokenizer2.nextToken());
                        }
                        if (!this.activeFileFieldsRecord.hasSnr() || !bT747StringTokenizer2.hasMoreTokens()) continue;
                        gPSRecord.snr[i] = JavaLibBridge.toInt(bT747StringTokenizer2.nextToken());
                    }
                    break;
                }
                case -12: {
                    if (string.length() == 0) break;
                    gPSRecord.voxStr = string;
                    break;
                }
                case 17: {
                    gPSRecord.rcr = 0;
                    if (string.charAt(0) != 'X') {
                        if (string.indexOf(66, 0) != -1) {
                            gPSRecord.rcr |= 8;
                        }
                        if (string.indexOf(84, 0) != -1) {
                            gPSRecord.rcr |= 1;
                        }
                        if (string.indexOf(83, 0) != -1) {
                            gPSRecord.rcr |= 2;
                        }
                        if (string.indexOf(68, 0) != -1) {
                            gPSRecord.rcr |= 4;
                        }
                        if (string.indexOf(86, 0) != -1) {
                            gPSRecord.rcr = 768;
                        }
                        if (string.indexOf(67, 0) == -1) break;
                        gPSRecord.rcr = 1280;
                        break;
                    }
                    if (string.length() != 5) break;
                    gPSRecord.rcr = Conv.hex2Int(string.substring(1));
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.distance = JavaLibBridge.toDouble(bT747StringTokenizer.nextToken());
                    break;
                }
                case 119: {
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(string, ' ');
                    gPSRecord.distance = JavaLibBridge.toDouble(bT747StringTokenizer.nextToken()) / 3.28083989501312;
                    break;
                }
                case 31: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            Generic.debug("Problem reading record " + gPSRecord.recCount + " field \"" + string + "\"");
        }
        return n2;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(2048);
                this.errorInfo = bT747Path + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    this.error = this.parseFile(object, gPSFileConverterInterface);
                    gPSFileConverterInterface.setActiveFileFields(this.activeFileFieldsRecord);
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("toGPSFile", exception);
        }
        return this.error;
    }

    private void updateLogFormat(GPSFileConverterInterface gPSFileConverterInterface, GPSRecord gPSRecord) {
        if (!gPSRecord.equalsFormat(this.logFormatRecord)) {
            this.logFormatRecord = gPSRecord.cloneRecord();
            this.activeFileFieldsRecord.cloneActiveFields(this.logFormatRecord);
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(this.logFormatRecord);
            }
        }
    }

    public int getType() {
        return 1;
    }
}

