/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;

public final class HoluxTrl2LogConvert
extends GPSLogConvertInterface {
    private int recordSize;
    protected boolean passToFindFieldsActivatedInLog = false;
    protected final int activeFileFields = 29;
    private static final int SECONDS_FROM_1970_TO_2000 = JavaLibBridge.getDateInstance(1, 1, 1990).dateToUTCepoch1970();
    private int error;

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            BT747RAFile bT747RAFile = (BT747RAFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            byte[] byArray = new byte[2048];
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(29));
            }
            this.recordSize = 31;
            int n = 0;
            int n2 = 0;
            int n3 = bT747RAFile.getSize();
            while (!this.stop && n2 + this.recordSize + 1 < n3) {
                int n4 = 2048;
                if (n4 + n2 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                bT747RAFile.setPos(n2);
                int n6 = bT747RAFile.readBytes(byArray, 0, n4);
                if (n6 != n4) {
                    this.errorInfo = bT747RAFile.getPath() + "|" + bT747RAFile.getLastError();
                    return -3;
                }
                n2 += n4;
                while (n4 > n5 + this.recordSize) {
                    int n7 = n5;
                    int n8 = 0;
                    while (n7 < this.recordSize + n5 && n7 < n4 - 1) {
                        n8 ^= byArray[n7++];
                    }
                    int n9 = n5;
                    n5 = ++n7;
                    gPSRecord.recCount = ++n;
                    if (this.passToFindFieldsActivatedInLog) continue;
                    gPSRecord.valid = 65535;
                    gPSRecord.rcr = 1;
                    gPSRecord.utc = (0xFF & byArray[n9++]) << 0 | (0xFF & byArray[n9++]) << 8 | (0xFF & byArray[n9++]) << 16 | (0xFF & byArray[n9++]) << 24;
                    gPSRecord.utc += SECONDS_FROM_1970_TO_2000;
                    int n10 = (0xFF & byArray[n9++]) << 0 | (0xFF & byArray[n9++]) << 8 | (0xFF & byArray[n9++]) << 16 | (0xFF & byArray[n9++]) << 24;
                    gPSRecord.latitude = JavaLibBridge.toFloatBitwise(n10);
                    int n11 = (0xFF & byArray[n9++]) << 0 | (0xFF & byArray[n9++]) << 8 | (0xFF & byArray[n9++]) << 16 | (0xFF & byArray[n9++]) << 24;
                    gPSRecord.longitude = JavaLibBridge.toFloatBitwise(n11);
                    int n12 = (0xFF & byArray[n9++]) << 8 | (0xFF & byArray[n9++]) << 16 | (0xFF & byArray[n9++]) << 24;
                    gPSRecord.height = JavaLibBridge.toFloatBitwise(n12);
                    CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                }
                n2 -= n4 - n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        RAFile rAFile = null;
        if (File.isAvailable() && !(rAFile = new RAFile(bT747Path, 1)).isOpen()) {
            this.errorInfo = bT747Path + "|" + rAFile.getLastError();
            this.error = -1;
            rAFile = null;
        }
        return rAFile;
    }

    protected void closeFileObject(Object object) {
        ((File)object).close();
    }

    public final int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(29));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public int getType() {
        return 9;
    }
}

