/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;

public final class WPLogConvert
extends GPSLogConvertInterface {
    private int recordSize = 16;
    private int logFormat;
    protected boolean passToFindFieldsActivatedInLog = false;
    protected int activeFileFields = 29;
    private int error;

    public void setLoggerType(int n) {
        super.setLoggerType(n);
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                this.activeFileFields = 61;
                this.recordSize = 16;
                break;
            }
            default: {
                this.activeFileFields = 29;
                this.recordSize = 16;
            }
        }
    }

    public static final int longToUtcTime(int n) {
        int n2 = n & 0x3F;
        int n3 = n >> 6 & 0x3F;
        int n4 = n >> 12 & 0x1F;
        int n5 = n >> 17 & 0x1F;
        int n6 = n >> 22 & 0xF;
        int n7 = n >> 26 & 0x3F;
        int n8 = JavaLibBridge.getDateInstance(n5, n6, n7 + 2000).dateToUTCepoch1970() + 3600 * n4 + 60 * n3 + n2;
        return n8;
    }

    public int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            BT747RAFile bT747RAFile = (BT747RAFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            byte[] byArray = new byte[2048];
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(this.getLogFormatRecord(this.logFormat));
            }
            int n = 0;
            this.logFormat = 0;
            int n2 = 0;
            int n3 = bT747RAFile.getSize();
            while (!this.stop && n2 + this.recordSize + 1 < n3) {
                int n4 = 2048;
                if (n4 + n2 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                bT747RAFile.setPos(n2);
                int n6 = bT747RAFile.readBytes(byArray, 0, n4);
                if (n6 != n4) {
                    this.errorInfo = bT747RAFile.getPath() + "|" + bT747RAFile.getLastError();
                    return -3;
                }
                n2 += n4;
                while (n4 > n5 + this.recordSize) {
                    int n7;
                    int n8;
                    int n9;
                    int n10 = n5;
                    int n11 = n5;
                    n5 = n10 += this.recordSize;
                    gPSRecord.recCount = ++n;
                    if (this.passToFindFieldsActivatedInLog) continue;
                    switch (this.getLoggerType()) {
                        case 2: 
                        case 3: {
                            n9 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8 | (0xFF & byArray[n11++]) << 16 | (0xFF & byArray[n11++]) << 24;
                            n8 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8 | (0xFF & byArray[n11++]) << 16 | (0xFF & byArray[n11++]) << 24;
                            int n12 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8 | (0xFF & byArray[n11++]) << 16 | (0xFF & byArray[n11++]) << 24;
                            int n13 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8;
                            gPSRecord.height = n13;
                            CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                            n7 = (0xFF & byArray[n11++]) << 0;
                            int n14 = (0xFF & byArray[n11++]) << 0;
                            gPSRecord.utc = WPLogConvert.longToUtcTime(n12);
                            break;
                        }
                        default: {
                            n9 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8 | (0xFF & byArray[n11++]) << 16 | (0xFF & byArray[n11++]) << 24;
                            n8 = (0xFF & byArray[n11++]) << 0 | (0xFF & byArray[n11++]) << 8 | (0xFF & byArray[n11++]) << 16 | (0xFF & byArray[n11++]) << 24;
                            int n15 = (0xFF & byArray[n11++]) << 0;
                            int n16 = (0xFF & byArray[n11++]) << 0;
                            int n17 = (0xFF & byArray[n11++]) << 0;
                            int n18 = (0xFF & byArray[n11++]) << 0;
                            int n19 = (0xFF & byArray[n11++]) << 0;
                            int n20 = (0xFF & byArray[n11++]) << 0;
                            n7 = (0xFF & byArray[n11++]) << 0;
                            int n14 = (0xFF & byArray[n11++]) << 0;
                            gPSRecord.utc = JavaLibBridge.getDateInstance(n17, n16, n15 + 2000).dateToUTCepoch1970();
                            gPSRecord.utc += 3600 * n18 + 60 * n19 + n20;
                        }
                    }
                    if (n8 == -1) {
                        return 0;
                    }
                    if ((n9 & Integer.MIN_VALUE) != 0) {
                        n9 = -(n9 & Integer.MAX_VALUE);
                    }
                    if ((n8 & Integer.MIN_VALUE) != 0) {
                        n8 = -(n8 & Integer.MAX_VALUE);
                    }
                    gPSRecord.longitude = (double)(n9 / 1000000) + (double)(n9 % 1000000) / 600000.0;
                    gPSRecord.latitude = (double)(n8 / 1000000) + (double)(n8 % 1000000) / 600000.0;
                    gPSRecord.speed = (float)n7 * 1.852f;
                    gPSRecord.valid = 65535;
                    gPSRecord.rcr = 1;
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                }
                n2 -= n4 - n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        RAFile rAFile = null;
        if (File.isAvailable() && !(rAFile = new RAFile(bT747Path, 1)).isOpen()) {
            this.errorInfo = bT747Path + "|" + rAFile.getLastError();
            this.error = -1;
            rAFile = null;
        }
        return rAFile;
    }

    protected void closeFileObject(Object object) {
        ((File)object).close();
    }

    public int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(this.getLogFormatRecord(this.activeFileFields));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public GPSRecord getLogFormatRecord(int n) {
        int n2 = 45;
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                n2 |= 0x10;
                break;
            }
        }
        return GPSRecord.getLogFormatRecord(n2);
    }

    public int getType() {
        return 10;
    }
}

