/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.I18N;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Time;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.out.WayPointStyle;
import gps.log.out.WayPointStyleSet;

public final class CommonOut {
    private static final String[][] IconStyles = new String[][]{{"T", "TimeStamp", "http://maps.google.com/mapfiles/kml/paddle/T.png"}, {"D", "DistanceStamp", "http://maps.google.com/mapfiles/kml/paddle/D.png"}, {"S", "SpeedStamp", "http://maps.google.com/mapfiles/kml/paddle/S.png"}, {"B", "ButtonStamp", "http://maps.google.com/mapfiles/kml/pushpin/ylw-pushpin.png"}, {"M", "MixStamp", "http://maps.google.com/mapfiles/kml/paddle/M.png"}, {"0010", "Picture", "http://maps.google.com/mapfiles/kml/shapes/camera.png"}, {"0020", "Gaz Station", "http://maps.google.com/mapfiles/kml/shapes/gas_stations.png"}, {"0040", "Phone Booth", "http://maps.google.com/mapfiles/kml/shapes/phone.png"}, {"0080", "ATM", "http://maps.google.com/mapfiles/kml/shapes/euro.png"}, {"0100", "Bus Stop", "http://maps.google.com/mapfiles/kml/shapes/bus.png"}, {"0200", "Parking", "http://maps.google.com/mapfiles/kml/shapes/parking_lot.png"}, {"0400", "Post Box", "http://maps.google.com/mapfiles/kml/shapes/post_office.png"}, {"0800", "Railway", "http://maps.google.com/mapfiles/kml/shapes/rail.png"}, {"1000", "Restaurant", "http://maps.google.com/mapfiles/kml/shapes/dining.png"}, {"2000", "Bridge", "http://maps.google.com/mapfiles/kml/shapes/water.png"}, {"4000", "View", "http://maps.google.com/mapfiles/kml/shapes/flag.png"}, {"8000", "Other", "http://maps.google.com/mapfiles/kml/shapes/placemark_circle.png"}, {"0300", "Voice", "http://maps.google.com/mapfiles/kml/paddle/V.png"}, {"0500", "Way Point", "http://maps.google.com/mapfiles/kml/pal4/icon29.png"}};
    private static WayPointStyleSet wayPointStyles = new WayPointStyleSet(IconStyles);

    public static final String getRCRKey(String string) {
        if (string.length() > 0 && string.charAt(0) == 'X') {
            return string.substring(1);
        }
        if (string.length() > 1) {
            return "M";
        }
        return string;
    }

    public static final String getRcrSymbolText(GPSRecord gPSRecord) {
        WayPointStyle wayPointStyle = wayPointStyles.get(CommonOut.getRCRKey(CommonOut.getRCRstr(gPSRecord)));
        if (wayPointStyle != null) {
            return wayPointStyles.get(CommonOut.getRCRKey(CommonOut.getRCRstr(gPSRecord))).getSymbolText();
        }
        return null;
    }

    public static final String getLink(GPSRecord gPSRecord, boolean bl) {
        String string;
        String string2 = gPSRecord.getVoxStr();
        if (string2 == null || string2.length() == 0 || string2.charAt(0) == '/' || string2.charAt(0) == '\\' || string2.charAt(0) == '.' || string2.indexOf(58) >= 0) {
            string = string2;
        } else {
            string = "./" + string2;
            if (gPSRecord.voxStr.startsWith("VOX")) {
                string = string + ".wav";
            }
        }
        if (bl) {
            string = string.toLowerCase();
        }
        return string;
    }

    public static final void getHtml(StringBuffer stringBuffer, GPSRecord gPSRecord, GPSRecord gPSRecord2, BT747Time bT747Time, boolean bl, boolean bl2) {
        CommonOut.getHtml(stringBuffer, gPSRecord, gPSRecord2, bT747Time, bl, bl2, false);
    }

    public static final void getHtml(StringBuffer stringBuffer, GPSRecord gPSRecord, GPSRecord gPSRecord2, BT747Time bT747Time, boolean bl, boolean bl2, boolean bl3) {
        String string = CommonOut.getRCRstr(gPSRecord);
        WayPointStyle wayPointStyle = null;
        wayPointStyle = wayPointStyles.get(CommonOut.getRCRKey(string));
        stringBuffer.append("<table width=400>");
        if (gPSRecord.voxStr != null) {
            stringBuffer.append("<tr><td colspan=2 align='center'>");
            String string2 = gPSRecord.voxStr.toUpperCase();
            boolean bl4 = string2.endsWith(".JPG") || string2.endsWith("PNG");
            stringBuffer.append("<br>");
            if (wayPointStyle != null) {
                stringBuffer.append(I18N.i18n(wayPointStyle.getSymbolText()));
                stringBuffer.append(':');
                if (bl4) {
                    stringBuffer.append("<br>");
                }
            }
            String string3 = bl3 ? gPSRecord.voxStr.toLowerCase() : gPSRecord.voxStr;
            stringBuffer.append("<a target='_new' href='");
            stringBuffer.append(CommonOut.getLink(gPSRecord, bl3));
            stringBuffer.append("'>");
            if (bl4) {
                stringBuffer.append("<img height=150 src='");
                stringBuffer.append(string3);
                stringBuffer.append("' >");
            } else {
                stringBuffer.append(I18N.i18n("Click here") + " (" + string3 + ")");
            }
            stringBuffer.append("</a><br><br>");
            stringBuffer.append("</td></tr>");
        }
        if (bl && gPSRecord.hasRecCount()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("IDX"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(gPSRecord.getRecCount());
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasUtc() && gPSRecord2.hasUtc()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("TIME"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(CommonOut.getDateTimeStr(bT747Time));
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasRcr() && gPSRecord2.hasRcr()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("RCR"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(string);
            if (gPSRecord.voxStr == null && wayPointStyle != null) {
                stringBuffer.append(" <b>(");
                stringBuffer.append(I18N.i18n(wayPointStyle.getSymbolText()));
                stringBuffer.append(")</b>");
            }
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasValid() && gPSRecord2.hasValid()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("VALID"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(I18N.i18n(CommonOut.getFixText(gPSRecord.getValid())));
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasLatitude() && gPSRecord2.hasLatitude()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("LATITUDE"));
            stringBuffer.append(":</td><td>");
            if (gPSRecord.getLatitude() >= 0.0) {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getLatitude(), 6));
                stringBuffer.append(" N");
            } else {
                stringBuffer.append(JavaLibBridge.toString(-gPSRecord.getLatitude(), 6));
                stringBuffer.append(" S");
            }
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasLongitude() && gPSRecord2.hasLongitude()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("LONGITUDE"));
            stringBuffer.append(":</td><td>");
            if (gPSRecord.getLongitude() >= 0.0) {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getLongitude(), 6));
                stringBuffer.append(" E");
            } else {
                stringBuffer.append(JavaLibBridge.toString(-gPSRecord.getLongitude(), 6));
                stringBuffer.append(" W");
            }
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasHeight() && gPSRecord2.hasHeight()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("HEIGHT"));
            stringBuffer.append(":</td><td>");
            if (!bl2) {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getHeight(), 3) + " m");
            } else {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getHeight() * 3.28084f, 3) + " feet");
            }
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasSpeed() && gPSRecord2.hasSpeed()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("SPEED"));
            stringBuffer.append(":</td><td>");
            if (!bl2) {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getSpeed(), 3) + " km/h");
            } else {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.getSpeed() * 0.6213712f, 3) + " mph");
            }
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasHeading() && gPSRecord2.hasHeading()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("HEADING"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(JavaLibBridge.toString(gPSRecord.getHeading()));
            stringBuffer.append("&#176;</td></tr>");
        }
        if (gPSRecord.hasDsta() && gPSRecord2.hasDsta()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("DSTA"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(gPSRecord.getDsta());
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasDage() && gPSRecord2.hasDage()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("DAGE"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(gPSRecord.getDage());
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasPdop() && gPSRecord2.hasPdop()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("PDOP"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(JavaLibBridge.toString((float)gPSRecord.getPdop() / 100.0f, 2));
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasHdop() && gPSRecord2.hasHdop()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("HDOP"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2));
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasVdop() && gPSRecord2.hasVdop()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("VDOP"));
            stringBuffer.append(":</td><td>");
            stringBuffer.append(JavaLibBridge.toString((float)gPSRecord.getVdop() / 100.0f, 2));
            stringBuffer.append("</td></tr>");
        }
        if (gPSRecord.hasDistance() && gPSRecord2.hasDistance()) {
            stringBuffer.append("<tr><td>");
            stringBuffer.append(I18N.i18n("DISTANCE"));
            stringBuffer.append(":</td><td>");
            if (!bl2) {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.distance, 2));
                stringBuffer.append(' ');
                stringBuffer.append(I18N.i18n("m"));
            } else {
                stringBuffer.append(JavaLibBridge.toString(gPSRecord.distance * 3.2808398950131235, 2));
                stringBuffer.append(' ');
                stringBuffer.append(I18N.i18n("feet"));
            }
            stringBuffer.append("</td></tr>");
        }
        stringBuffer.append("</table>");
    }

    public static final String getDateTimeStr(int n) {
        BT747Time bT747Time = JavaLibBridge.getTimeInstance();
        bT747Time.setUTCTime(n);
        return CommonOut.getDateTimeStr(bT747Time);
    }

    public static final String getDateTimeStr(GPSRecord gPSRecord, BT747Time bT747Time) {
        if (gPSRecord.hasUtc()) {
            return CommonOut.getDateTimeStr(bT747Time);
        }
        return "";
    }

    public static final String getTimeStr(BT747Time bT747Time) {
        return (bT747Time.getHour() < 10 ? "0" : "") + bT747Time.getHour() + ":" + (bT747Time.getMinute() < 10 ? "0" : "") + bT747Time.getMinute() + ":" + (bT747Time.getSecond() < 10 ? "0" : "") + bT747Time.getSecond();
    }

    public static final String getDateTxtStr(BT747Time bT747Time) {
        return (bT747Time.getDay() < 10 ? "0" : "") + bT747Time.getDay() + "-" + Conv.idxToShortMonthStr(bT747Time.getMonth() - 1) + "-" + (bT747Time.getYear() % 100 < 10 ? "0" : "") + bT747Time.getYear() % 100;
    }

    public static final String getDateNumStr(BT747Time bT747Time) {
        return bT747Time.getYear() + "/" + (bT747Time.getMonth() < 10 ? "0" : "") + bT747Time.getMonth() + "/" + (bT747Time.getDay() < 10 ? "0" : "") + bT747Time.getDay();
    }

    public static final String getDateTimeStr(BT747Time bT747Time) {
        return CommonOut.getDateTxtStr(bT747Time) + " " + CommonOut.getTimeStr(bT747Time);
    }

    public static final String getDateTimeISO8601(BT747Time bT747Time, int n) {
        return CommonOut.getDateTimeISO8601(bT747Time, n, "Z");
    }

    public static final String getDateTimeISO8601(BT747Time bT747Time, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(bT747Time.getYear());
        stringBuffer.append('-');
        if (bT747Time.getMonth() < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(bT747Time.getMonth());
        stringBuffer.append('-');
        if (bT747Time.getDay() < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(bT747Time.getDay());
        stringBuffer.append('T');
        if (bT747Time.getHour() < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(bT747Time.getHour());
        stringBuffer.append(':');
        if (bT747Time.getMinute() < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(bT747Time.getMinute());
        stringBuffer.append(':');
        if (bT747Time.getSecond() < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(bT747Time.getSecond());
        if (n >= 0 && n < 1000) {
            stringBuffer.append('.');
            if (n < 100) {
                stringBuffer.append('0');
                if (n < 10) {
                    stringBuffer.append('0');
                }
            }
            stringBuffer.append(n);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String getRCRtype(GPSRecord gPSRecord) {
        if (gPSRecord.rcr == 768) {
            return "Voice";
        }
        return CommonOut.getRCRstr(gPSRecord);
    }

    public static final String getRCRstr(GPSRecord gPSRecord) {
        StringBuffer stringBuffer = new StringBuffer(15);
        stringBuffer.setLength(0);
        if ((gPSRecord.rcr & 0xFFF0) == 0) {
            if ((gPSRecord.rcr & 1) != 0) {
                stringBuffer.append("T");
            }
            if ((gPSRecord.rcr & 2) != 0) {
                stringBuffer.append("S");
            }
            if ((gPSRecord.rcr & 4) != 0) {
                stringBuffer.append("D");
            }
            if ((gPSRecord.rcr & 8) != 0) {
                stringBuffer.append("B");
            }
        } else {
            stringBuffer.append("X");
            stringBuffer.append(JavaLibBridge.unsigned2hex(gPSRecord.rcr, 4));
        }
        return stringBuffer.toString();
    }

    public static final String getFixText(int n) {
        switch (n) {
            case 1: {
                return "No fix";
            }
            case 2: {
                return "SPS";
            }
            case 4: {
                return "DGPS";
            }
            case 8: {
                return "PPS";
            }
            case 16: {
                return "RTK";
            }
            case 32: {
                return "FRTK";
            }
            case 64: {
                return "Estimated mode";
            }
            case 128: {
                return "Manual input mode";
            }
            case 256: {
                return "Simulator mode";
            }
        }
        return "Unknown mode";
    }

    public static final WayPointStyleSet getWayPointStyles() {
        return wayPointStyles;
    }
}

